<?php

namespace WPSecurityNinja\MainWPAddon;

class SecurityNinjaMainWPExtension {
    public function __construct() {
        add_action( 'init', array($this, 'init') );
        add_action( 'admin_init', array($this, 'admin_init') );
    }

    /**
     * render_page.
     *
     * @author    Lars Koudal
     * @since v0.0.1
     * @version   v1.0.0  Thursday, April 4th, 2024.
     * @access    public static
     * @return    void
     */
    public static function render_page() {
        global $snmwp_fs;
        $freeversion = true;
        if ( $snmwp_fs ) {
        }
        if ( $freeversion ) {
            $readmore_link = \WPSecurityNinja\MainWPAddon\Security_Ninja_Mainwp::generate_sn_web_link( 'welcome_notice', '/mainwp/' );
            ?>
			<div class="ui segment">

				<div class="ui info message">
					<i class="close icon mainwp-notice-dismiss" notice-id="secnin-pro-upgrade"></i>
					<h3><?php 
            esc_html_e( 'Security Ninja for MainWP Pro', 'security-ninja-mainwp' );
            ?></h3>
					<p><?php 
            esc_html_e( 'To enhance your security management capabilities, consider upgrading to the Pro version of Security Ninja. With Pro, you gain access to a combined event log across all your websites equipped with Security Ninja Pro.', 'security-ninja-mainwp' );
            ?></p>
					<p><?php 
            esc_html_e( 'Additionally, the Sites overview in the Security Ninja column will display more detailed insights, including malware scan reports and specific settings for each website.', 'security-ninja-mainwp' );
            ?></p>
					<p>
					<?php 
            echo wp_kses( 
                /* translators: %s: URL to Security Ninja for MainWP Pro */
                sprintf( __( 'Read more here: <a href="%s" target="_blank">Security Ninja for MainWP Pro</a>', 'security-ninja-mainwp' ), esc_url( $readmore_link ) ),
                array(
                    'a' => array(
                        'href'   => array(),
                        'target' => array(),
                    ),
                )
             );
            ?>
						</p>

					</p>
				</div>
			</div>

			<?php 
        }
        if ( $snmwp_fs ) {
        }
    }

    /**
     * get_childkey.
     *
     * @author    Lars Koudal
     * @since v0.0.1
     * @version   v1.0.0  Thursday, April 4th, 2024.
     * @access    public static
     * @return    mixed
     */
    public static function get_childkey() {
        global $child_enabled;
        $child_enabled = apply_filters( 'mainwp_extension_enabled_check', __FILE__ );
        if ( !$child_enabled ) {
            // Handle error or return a default/fallback value.
            return null;
        }
        $child_key = $child_enabled['key'];
        return $child_key;
    }

    /**
     * Get available sites for filtering
     *
     * @author    Lars Koudal
     * @since v1.0.0
     * @version   v1.0.1  Monday, May 5th, 2025.
     * @access    public static
     * @return    array
     */
    public static function get_available_sites() {
        global $wpdb;
        // Check if MainWP is available
        if ( !class_exists( 'MainWP_DB' ) ) {
            return array();
        }
        // Validate table names to prevent SQL injection
        $mainwp_table = $wpdb->prefix . 'mainwp_wp';
        $events_table = $wpdb->prefix . 'mainwp_security_ninja_events';
        // Additional validation - ensure tables exist
        if ( !self::table_exists( $mainwp_table ) || !self::table_exists( $events_table ) ) {
            return array();
        }
        // Get sites that have events with additional security
        $sites_with_events = $wpdb->get_results( $wpdb->prepare( "SELECT DISTINCT site_id FROM {$events_table} WHERE site_id IS NOT NULL AND site_id > 0", array() ), ARRAY_A );
        if ( !$sites_with_events || !is_array( $sites_with_events ) ) {
            return array();
        }
        // Validate site IDs
        $site_ids = array();
        foreach ( $sites_with_events as $site ) {
            if ( isset( $site['site_id'] ) && is_numeric( $site['site_id'] ) && $site['site_id'] > 0 ) {
                $site_ids[] = intval( $site['site_id'] );
            }
        }
        if ( empty( $site_ids ) ) {
            return array();
        }
        $site_ids_placeholders = implode( ',', array_fill( 0, count( $site_ids ), '%d' ) );
        // Get site details with prepared statement
        $sites = $wpdb->get_results( $wpdb->prepare( "SELECT id, name FROM {$mainwp_table} WHERE id IN ({$site_ids_placeholders}) ORDER BY name ASC", $site_ids ), ARRAY_A );
        // Additional validation of results
        if ( !$sites || !is_array( $sites ) ) {
            return array();
        }
        // Sanitize site data before returning
        $sanitized_sites = array();
        foreach ( $sites as $site ) {
            if ( isset( $site['id'] ) && isset( $site['name'] ) && is_numeric( $site['id'] ) && !empty( $site['name'] ) ) {
                $sanitized_sites[] = array(
                    'id'   => intval( $site['id'] ),
                    'name' => sanitize_text_field( $site['name'] ),
                );
            }
        }
        return $sanitized_sites;
    }

    /**
     * Check if a table exists in the database
     *
     * @author    Lars Koudal
     * @since v1.0.1
     * @version   v1.0.0  Monday, May 5th, 2025.
     * @access    private static
     * @param     string  $table_name
     * @return    boolean
     */
    private static function table_exists( $table_name ) {
        global $wpdb;
        // Sanitize table name
        $table_name = sanitize_text_field( $table_name );
        // Check if table exists using WordPress method
        $result = $wpdb->get_var( $wpdb->prepare( "SHOW TABLES LIKE %s", $table_name ) );
        return $result === $table_name;
    }

    /**
     * Get available actions for filtering
     *
     * @author    Lars Koudal
     * @since v1.0.0
     * @version   v1.0.1  Monday, May 5th, 2025.
     * @access    public static
     * @return    array
     */
    public static function get_available_actions() {
        global $wpdb;
        $events_table = $wpdb->prefix . 'mainwp_security_ninja_events';
        // Validate table exists
        if ( !self::table_exists( $events_table ) ) {
            return array();
        }
        // Get distinct actions with prepared statement
        $actions = $wpdb->get_results( $wpdb->prepare( "SELECT DISTINCT action FROM {$events_table} WHERE action IS NOT NULL AND action != '' ORDER BY action ASC", array() ), ARRAY_A );
        // Validate results
        if ( !$actions || !is_array( $actions ) ) {
            return array();
        }
        // Sanitize action data before returning
        $sanitized_actions = array();
        foreach ( $actions as $action ) {
            if ( isset( $action['action'] ) && !empty( $action['action'] ) && is_string( $action['action'] ) ) {
                $sanitized_action = sanitize_text_field( $action['action'] );
                if ( !empty( $sanitized_action ) ) {
                    $sanitized_actions[] = $sanitized_action;
                }
            }
        }
        return $sanitized_actions;
    }

}
