<?php

class MainWP_Wordfence_Utility {
    public static function format_timestamp( $timestamp ) {
        return date_i18n( get_option( 'date_format' ) . ' ' . get_option( 'time_format' ), $timestamp );
    }

    static function ctype_digit( $str ) {
        return ( is_string( $str ) || is_int( $str ) || is_float( $str ) ) && preg_match( '/^\d+\z/', $str );
    }

    /**
     * Method map_site()
     *
     * Map Site.
     *
     * @param mixed $website Website to map.
     * @param mixed $keys Keys to map.
     * @param bool  $object_output Output format array|object.
     *
     * @return mixed $outputSite Mapped site.
     */
    public static function map_site( &$website, $keys, $object_output = false ) {
        $outputSite = array();
        if ( ! empty( $website ) ) {
            if ( is_object( $website ) ) {
                foreach ( $keys as $key ) {
                    $outputSite[ $key ] = $website->$key;
                }
            } elseif ( is_array( $website ) ) {
                foreach ( $keys as $key ) {
                    $outputSite[ $key ] = $website[ $key ];
                }
            }
        }

        if ( $object_output ) {
            return (object) $outputSite;
        } else {
            return $outputSite;
        }
    }


    public static function is_admin( $user = false ) {
        if ( $user ) {
            if ( is_multisite() ) {
                if ( user_can( $user, 'manage_network' ) ) {
                    return true;
                }
            } elseif ( user_can( $user, 'manage_options' ) ) {
                return true;
            }
        } elseif ( is_multisite() ) {
            if ( current_user_can( 'manage_network' ) ) {
                return true;
            }
        } elseif ( current_user_can( 'manage_options' ) ) {
            return true;
        }

        return false;
    }

    public static function get_site_base_url() {
        return rtrim( site_url(), '/' ) . '/';
    }

    public static function big_rando_hex() {
        return dechex( wp_rand( 0, 2147483647 ) ) . dechex( wp_rand( 0, 2147483647 ) ) . dechex( wp_rand( 0, 2147483647 ) );
    }

    public static function get_data_authed( $website, $open_location = '' ) {
        $paramValue = 'index.php';
        $params     = array();
        if ( $website && $paramValue != '' ) {
            $nonce = wp_rand( 0, 9999 );
            if ( ( $website->nossl == 0 ) && function_exists( 'openssl_verify' ) ) {
                $nossl = 0;
                openssl_sign( $paramValue . $nonce, $signature, base64_decode( $website->privkey ) );
            } else {
                $nossl     = 1;
                $signature = md5( $paramValue . $nonce . $website->nosslkey );
            }
            $signature = base64_encode( $signature );

            $params = array(
                'login_required'  => 1,
                'user'            => $website->adminname,
                'mainwpsignature' => rawurlencode( $signature ),
                'nonce'           => $nonce,
                'nossl'           => $nossl,
                'open_location'   => $open_location,
                'where'           => $paramValue,
            );
        }

        $url  = ( isset( $website->siteurl ) && $website->siteurl != '' ? $website->siteurl : $website->url );
        $url .= ( substr( $url, -1 ) != '/' ? '/' : '' );
        $url .= '?';

        foreach ( $params as $key => $value ) {
            $url .= $key . '=' . $value . '&';
        }

        return rtrim( $url, '&' );
    }

    public static function is_valid_ip( $IP ) {
        return filter_var( $IP, FILTER_VALIDATE_IP ) !== false;
    }
    /**
     * Method cleanup_one_entry_per_line()
     *
     * Cleanup one entry per line.
     *
     * @param string $input String to cleanup.
     *
     * @return string Cleaned up string.
     */
    public static function cleanup_one_entry_per_line( $input ) { // phpcs:ignore -- NOSONAR
        $input = str_replace( "\n", ',', $input ); // Fix old format.
        $parts = preg_split( '/[,\s]+/', $input );

        return implode( "\n", array_unique( array_filter( array_map( 'trim', $parts ) ) ) );
    }

    /**
     * Method cleanup_one_show_entry_per_line()
     *
     * Cleanup one show entry per line.
     *
     * @param string $input String to cleanup.
     *
     * @return string Cleaned up string.
     */
    public static function cleanup_one_show_entry_per_line( $input ) {  // phpcs:ignore -- NOSONAR
        // Turn the comma into the line.
        $input = str_replace( ',', "\n", $input );

        // Eliminate the empty, trim, and remove overlapping.
        return implode( "\n", array_unique( array_filter( array_map( 'trim', explode( "\n", $input ) ) ) ) );
    }

    /**
     * Method format_for_db()
     *
     * Format string for database.
     *
     * @param string $input String to format.
     *
     * @return string Formatted string.
     */
    public static function format_for_db( $input ): string {  // phpcs:ignore -- NOSONAR
        // Standardize the line endings.
        $input = str_replace( array( "\r\n", "\r" ), "\n", $input );
        // Convert commas and spaces in a row.
        $input = preg_replace( '/[,\s]+/', "\n", $input );

        $lines = array_map( 'trim', explode( "\n", $input ) );
        $lines = array_filter( $lines );   // Remove empty.
        $lines = array_unique( $lines );   // Remove duplicate.

        // Grafted into a chain with ','.
        return implode( ', ', $lines );
    }
}
