<?php

/**
 * Class MainWP_Vulnerability_Nvd_Settings
 *
 * Settings for the data https://services.nvd.nist.gov/rest/json/cves/1.0/.
 */
class MainWP_Vulnerability_Nvd_Settings extends MainWP_Vulnerability_Settings_Base { // phpcs:ignore -- NOSONAR - multi methods.


	/**
	 * ID of the class extending the settings API. Used in option names.
	 *
	 * @var string
	 */
	public static $setting_id = 'nvd';

	/**
	 * Private static variable to hold the single instance of the class.
	 *
	 * @static
	 *
	 * @var mixed Default null
	 */
	private static $instance = null;

	/**
	 * Create public static instance.
	 *
	 * @static
	 *
	 * @return MainWP_DB
	 */
	public static function instance() {
		if ( null == self::$instance ) {
			self::$instance = new self();
		}
		return self::$instance;
	}


	/**
	 * Method __construct()
	 *
	 * Contructor.
	 *
	 * @param string $api_key API Key.
	 */
	public function __construct( $api_key = null ) {
	}

	/**
	 * Returns the name of the option in the WP DB.
	 *
	 * @return string
	 */
	protected static function get_settings_id() {
		return self::$setting_id;
	}
}
