<?php

class MainWP_Vulnerability_Nvd_Checker { // phpcs:ignore -- NOSONAR - multi methods.

	protected static $_instance = null;

	public static function instance() {

		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}
		return self::$_instance;
	}

	public function admin_init() {
		add_action( 'wp_ajax_mainwp_vulner_ignore_issue', array( $this, 'ajax_ignore_issue' ) );
		add_action( 'wp_ajax_mainwp_vulner_unignore_item_issue', array( $this, 'ajax_unignore_item_issue' ) );
		add_action( 'wp_ajax_mainwp_vulner_unignore_sites_issue', array( $this, 'ajax_unignore_sites_issue' ) );
	}

	public function ajax_ignore_issue() {

		MainWP_Vulnerability_Checker::verify_nonce();
		// phpcs:disable WordPress.Security.NonceVerification.Missing
		$what     = isset( $_POST['what'] ) ? sanitize_text_field( wp_unslash( $_POST['what'] ) ) : '';
		$type     = isset( $_POST['type'] ) ? sanitize_text_field( wp_unslash( $_POST['type'] ) ) : '';
		$site_id  = isset( $_POST['site_id'] ) ? intval( $_POST['site_id'] ) : 0;
		$cve_id   = isset( $_POST['cve_id'] ) ? sanitize_text_field( wp_unslash( $_POST['cve_id'] ) ) : '';
		$datetime = isset( $_POST['datetime'] ) ? sanitize_text_field( wp_unslash( $_POST['datetime'] ) ) : '';
		$detail   = isset( $_POST['detail'] ) ? sanitize_text_field( wp_unslash( $_POST['detail'] ) ) : '';
		// phpcs:enable WordPress.Security.NonceVerification.Missing
		if ( empty( $cve_id ) || empty( $datetime ) || ! in_array( $type, array( 'plugin', 'theme', 'wp' ) ) ) {
			die( wp_json_encode( array( 'error' => esc_html( MainWP_Vulnerability_Utility::get_common_word( 'invalid-request' ) ) ) ) );
		}

		$ignored_item = array(
			'cve_id'   => $cve_id,
			'datetime' => $datetime,
			'detail'   => $detail,
		);

		$success = false;

		$opt_name = '';

		if ( 'plugin' === $type ) {
			$opt_name = 'ignored_issues_plugins';
		} elseif ( 'theme' === $type ) {
			$opt_name = 'ignored_issues_themes';
		} elseif ( 'wp' === $type ) {
			$opt_name = 'ignored_issues_wp';
		}

		if ( ! empty( $opt_name ) ) {
			if ( 'global' == $what ) {
				$decodedIgnoredIssues = MainWP_Vulnerability_Hooks::get_website_options( false, 0, $opt_name ); // 0: for global.

				if ( ! is_array( $decodedIgnoredIssues ) ) {
					$decodedIgnoredIssues = array();
				}

				if ( ! isset( $decodedIgnoredIssues[ $cve_id ] ) ) {
					$decodedIgnoredIssues[ $cve_id ] = $ignored_item;
					MainWP_Vulnerability_Hooks::update_website_option( 0, $opt_name, wp_json_encode( $decodedIgnoredIssues ) ); // 0: for global.
					$success = true;
				}
			} elseif ( 'site' == $what ) {

				if ( empty( $site_id ) ) {
					die( wp_json_encode( array( 'error' => esc_html( MainWP_Vulnerability_Utility::get_common_word( 'invalid-request' ) ) ) ) );
				}

				$website     = new stdClass();
				$website->id = $site_id;

				$decodedIgnoredIssues = MainWP_Vulnerability_Hooks::get_website_options( false, $website, $opt_name );

				if ( ! is_array( $decodedIgnoredIssues ) ) {
					$decodedIgnoredIssues = array();
				}

				if ( ! isset( $decodedIgnoredIssues[ $cve_id ] ) ) {
					$decodedIgnoredIssues[ $cve_id ] = $ignored_item;
					MainWP_Vulnerability_Hooks::update_website_option( $website, $opt_name, wp_json_encode( $decodedIgnoredIssues ) );
					$success = true;
				}
			}
		}

		if ( $success ) {
			die( wp_json_encode( array( 'result' => 'success' ) ) );
		} else {
			die( wp_json_encode( array( 'error' => esc_html( MainWP_Vulnerability_Utility::get_common_word( 'failed' ) ) ) ) );
		}
	}

	public function ajax_unignore_item_issue() {
		MainWP_Vulnerability_Checker::verify_nonce();
		// phpcs:disable WordPress.Security.NonceVerification.Missing
		$what    = isset( $_POST['what'] ) ? sanitize_text_field( wp_unslash( $_POST['what'] ) ) : '';
		$type    = isset( $_POST['type'] ) ? sanitize_text_field( wp_unslash( $_POST['type'] ) ) : '';
		$cve_id  = isset( $_POST['cve_id'] ) ? sanitize_text_field( wp_unslash( $_POST['cve_id'] ) ) : '';
		$site_id = isset( $_POST['site_id'] ) ? intval( $_POST['site_id'] ) : 0;
		// phpcs:enable WordPress.Security.NonceVerification.Missing
		if ( ! in_array( $type, array( 'plugin', 'theme', 'wp' ) ) ) {
			die( wp_json_encode( array( 'error' => esc_html( MainWP_Vulnerability_Utility::get_common_word( 'invalid-request' ) ) ) ) );
		}

		if ( 'plugin' === $type ) {
			$opt_name = 'ignored_issues_plugins';
		} elseif ( 'theme' === $type ) {
			$opt_name = 'ignored_issues_themes';
		} elseif ( 'wp' === $type ) {
			$opt_name = 'ignored_issues_wp';
		}

		$success = false;

		if ( ! empty( $opt_name ) ) {
			if ( 'global' == $what ) {
				$decodedIgnoredIssues = MainWP_Vulnerability_Hooks::get_website_options( false, 0, $opt_name ); // 0: for global.

				if ( ! is_array( $decodedIgnoredIssues ) ) {
					$decodedIgnoredIssues = array();
				}

				if ( isset( $decodedIgnoredIssues[ $cve_id ] ) ) {
					unset( $decodedIgnoredIssues[ $cve_id ] );
					MainWP_Vulnerability_Hooks::update_website_option( 0, $opt_name, wp_json_encode( $decodedIgnoredIssues ) ); // 0: for global.
					$success = true;
				}
			} elseif ( 'site' == $what ) {

				if ( empty( $site_id ) ) {
					die( wp_json_encode( array( 'error' => esc_html( MainWP_Vulnerability_Utility::get_common_word( 'invalid-request' ) ) ) ) );
				}

				$website     = new stdClass();
				$website->id = $site_id;

				$decodedIgnoredIssues = MainWP_Vulnerability_Hooks::get_website_options( false, $website, $opt_name );

				if ( is_array( $decodedIgnoredIssues ) && isset( $decodedIgnoredIssues[ $cve_id ] ) ) {
					unset( $decodedIgnoredIssues[ $cve_id ] );
					MainWP_Vulnerability_Hooks::update_website_option( $website, $opt_name, wp_json_encode( $decodedIgnoredIssues ) );
					$success = true;
				}
			}
		}
		if ( $success ) {
			die( wp_json_encode( array( 'result' => 'success' ) ) );
		} else {
			die( wp_json_encode( array( 'error' => esc_html( MainWP_Vulnerability_Utility::get_common_word( 'failed' ) ) ) ) );
		}
	}

	public function ajax_unignore_sites_issue() {
		MainWP_Vulnerability_Checker::verify_nonce();
		// phpcs:disable WordPress.Security.NonceVerification.Missing
		$what         = isset( $_POST['what'] ) ? sanitize_text_field( wp_unslash( $_POST['what'] ) ) : '';
		$type         = isset( $_POST['type'] ) ? sanitize_text_field( wp_unslash( $_POST['type'] ) ) : '';
		$all_site_ids = isset( $_POST['all_site_ids'] ) ? sanitize_text_field( wp_unslash( $_POST['all_site_ids'] ) ) : array();
		$all_cve_ids  = isset( $_POST['all_cve_ids'] ) ? sanitize_text_field( wp_unslash( $_POST['all_cve_ids'] ) ) : array();
		// phpcs:enable WordPress.Security.NonceVerification.Missing
		if ( ! in_array( $type, array( 'plugin', 'theme', 'wp' ) ) ) {
			die( wp_json_encode( array( 'error' => esc_html( MainWP_Vulnerability_Utility::get_common_word( 'invalid-request' ) ) ) ) );
		}

		if ( 'plugin' === $type ) {
			$opt_name = 'ignored_issues_plugins';
		} elseif ( 'theme' === $type ) {
			$opt_name = 'ignored_issues_themes';
		} elseif ( 'wp' === $type ) {
			$opt_name = 'ignored_issues_wp';
		}

		$success = false;

		if ( ! empty( $opt_name ) ) {
			if ( 'global' == $what ) {

				if ( empty( $all_cve_ids ) ) {
					die( wp_json_encode( array( 'error' => esc_html( MainWP_Vulnerability_Utility::get_common_word( 'invalid-request' ) ) ) ) );
				}

				$decodedIgnoredIssues = MainWP_Vulnerability_Hooks::get_website_options( false, 0, $opt_name ); // 0: for global.

				if ( ! is_array( $decodedIgnoredIssues ) ) {
					$decodedIgnoredIssues = array();
				}

				foreach ( $all_cve_ids as $cve_id ) {
					if ( isset( $decodedIgnoredIssues[ $cve_id ] ) ) {
						unset( $decodedIgnoredIssues[ $cve_id ] );
						$success = true;
					}
				}

				if ( $success ) {
					MainWP_Vulnerability_Hooks::update_website_option( 0, $opt_name, wp_json_encode( $decodedIgnoredIssues ) ); // 0: for global.
				}
			} elseif ( 'site' == $what ) {

				if ( empty( $all_site_ids ) ) {
					die( wp_json_encode( array( 'error' => esc_html( MainWP_Vulnerability_Utility::get_common_word( 'invalid-request' ) ) ) ) );
				}

				foreach ( $all_site_ids as $item ) {
					if ( ! is_array( $item ) || ! isset( $item['site_id'] ) || empty( $item['site_id'] ) || empty( $item['cve_id'] ) ) {
						continue;
					}
					$site_id = $item['site_id'];
					$cve_id  = $item['cve_id'];

					$website     = new stdClass();
					$website->id = $site_id;

					$website     = new stdClass();
					$website->id = $site_id;

					$decodedIgnoredIssues = MainWP_Vulnerability_Hooks::get_website_options( false, $website, $opt_name );

					if ( ! is_array( $decodedIgnoredIssues ) ) {
						$decodedIgnoredIssues = array();
					}

					if ( isset( $decodedIgnoredIssues[ $cve_id ] ) ) {
						unset( $decodedIgnoredIssues[ $cve_id ] );
						MainWP_Vulnerability_Hooks::update_website_option( $website, $opt_name, wp_json_encode( $decodedIgnoredIssues ) );
						$success = true;
					}
				}
			}
		}
		if ( $success ) {
			die( wp_json_encode( array( 'result' => 'success' ) ) );
		} else {
			die( wp_json_encode( array( 'error' => esc_html( MainWP_Vulnerability_Utility::get_common_word( 'failed' ) ) ) ) );
		}
	}

	public function get_all_total_unignored_vulner() {

		$return = array(
			'total_wp_vulner'     => 0,
			'total_plugin_vulner' => 0,
			'total_theme_vulner'  => 0,
		);

		$results = MainWP_Vulnerability_DB::instance()->get_all_results();
		if ( is_array( $results ) ) {
			foreach ( $results as $result ) {
				$result = $this->recalculate_unignored_counting_numbers( $result );

				$return['total_wp_vulner']     += $result['wp_vulner_count'];
				$return['total_plugin_vulner'] += $result['plugin_vulner_count'];
				$return['total_theme_vulner']  += $result['theme_vulner_count'];
			}
		}

		return $return;
	}

	public function recalculate_unignored_counting_numbers( $value ) {

		if ( empty( $value ) ) {
			return array();
		}

		$update = array(
			'wp_vulner_count'     => 0,
			'plugin_vulner_count' => 0,
			'theme_vulner_count'  => 0,
			'last_check'          => $value['last_check'],
			'site_id'             => $value['site_id'],
		);

		$siteid = $value['site_id'];

		$current_result = array();

		if ( ! empty( $value['result'] ) ) {
			$current_result = json_decode( $value['result'], true ); // get to update later
			if ( ! is_array( $current_result ) ) {
				$current_result = array();
			}
		}

		if ( isset( $current_result['plugin'] ) && is_array( $current_result['plugin'] ) ) {
			$plugin_count = 0;
			foreach ( $current_result['plugin'] as $result ) {
				$result = json_decode( $result, true );
				if ( is_array( $result ) ) {
					$result = current( $result );
				}
				if ( is_array( $result ) && isset( $result['vulnerabilities'] ) && is_array( $result['vulnerabilities'] ) ) {
					$plugin_count += self::get_vuln_count_issues( $result['vulnerabilities'], $siteid, 'plugin' );
				}
			}
			$update['plugin_vulner_count'] = $plugin_count;
		}

		if ( isset( $current_result['theme'] ) && is_array( $current_result['theme'] ) ) {
			$theme_count = 0;
			foreach ( $current_result['theme'] as $result ) {
				$result = isset( $result['vulner_data'] ) ? $result['vulner_data'] : '';
				$result = json_decode( $result, true );
				if ( is_array( $result ) ) {
					$result = current( $result );
				}
				if ( is_array( $result ) && isset( $result['vulnerabilities'] ) && is_array( $result['vulnerabilities'] ) ) {
					$theme_count += self::get_vuln_count_issues( $result['vulnerabilities'], $siteid, 'theme' );
				}
			}

			$update['theme_vulner_count'] = $theme_count;
		}

		if ( isset( $current_result['wp'] ) ) {
			$wp_count = 0;
			$result   = $current_result['wp'];
			$result   = json_decode( $result, true );

			if ( is_array( $result ) ) {
				$result = current( $result );
				if ( is_array( $result ) && isset( $result['vulnerabilities'] ) && is_array( $result['vulnerabilities'] ) ) {
					$wp_count += self::get_vuln_count_issues( $result['vulnerabilities'], $siteid, 'wp' );
				}
				$update['wp_vulner_count'] = $wp_count;
			}
		}
		return $update;
	}

	public static function render_nvd_nist_detail_tabs() {
		$site_id = 0;

		if ( isset( $_GET['id'] ) && ! empty( $_GET['id'] ) ) {
			$site_id = intval( $_GET['id'] );
		}

		if ( empty( $site_id ) ) {
			return;
		}

		$vulner_result = array();

		$result = MainWP_Vulnerability_DB::instance()->get_result_by( 'site_id', $site_id );

		if ( $result && ! empty( $result['result'] ) ) {
			$vulner_result = json_decode( $result['result'], true );
			if ( ! is_array( $vulner_result ) ) {
				$vulner_result = array();
			}
		}

		$website     = new stdClass();
		$website->id = $site_id;

		$site_ignored_wp_issues        = MainWP_Vulnerability_Hooks::get_website_options( false, $website, 'ignored_issues_wp' );
		$site_ignored_plugins_issues   = MainWP_Vulnerability_Hooks::get_website_options( false, $website, 'ignored_issues_plugins' );
		$site_ignored_themes_issues    = MainWP_Vulnerability_Hooks::get_website_options( false, $website, 'ignored_issues_themes' );
		$global_ignored_wp_issues      = MainWP_Vulnerability_Hooks::get_website_options( false, 0, 'ignored_issues_wp' ); // 0: for global.
		$global_ignored_plugins_issues = MainWP_Vulnerability_Hooks::get_website_options( false, 0, 'ignored_issues_plugins' ); // 0: for global.
		$global_ignored_themes_issues  = MainWP_Vulnerability_Hooks::get_website_options( false, 0, 'ignored_issues_themes' ); // 0: for global.

		?>
		<div class="ui segment" id="mainwp-<?php echo esc_attr( $site_id ); ?>-vulnerabilities">
			<div id="mainwp-message-zone" class="ui message" style="display:none"></div>
			<div class="ui info message"><?php esc_html_e( 'NVD Nist API Database can not be searched by plugin/theme slug (which would be unique for each item) and assure better accuracy, it can be searched by keyword only. This means that the API can return some false-positive results. For some vulnerabilities, the NVD Nist API lacks the "Fixed in version" info which can lead to extension showing vulnerabilities that already have been resolved. In order to remove false positives and get accurate results, you can use the "Ignore" function for the detected vulnerabilities if you recognize them as false-positive.', 'mainwp-vulnerability-checker-extension' ); ?></div>
			<h3 class="ui dividing header"><?php esc_html_e( 'WordPress', 'mainwp-vulnerability-checker-extension' ); ?></h3>
			<div class="ui segment">
				<?php

				$wp_results = array();
				if ( is_array( $vulner_result ) && isset( $vulner_result['wp'] ) ) {
					$wp_results = @json_decode( $vulner_result['wp'], true );
					if ( ! is_array( $wp_results ) ) {
						$wp_results = array();
					}
				}

				?>
				<table class="ui table">
					<thead>
						<tr>
							<th scope=""><?php echo esc_html( MainWP_Vulnerability_Utility::get_common_word( 'published-date' ) ); ?></th>
							<th scope=""><?php echo esc_html( MainWP_Vulnerability_Utility::get_common_word( 'detail' ) ); ?></th>
							<th style="width: 15%;"></th>
						</tr>
					</thead>
					<tbody>
						<?php
						foreach ( $wp_results as $wp_vuln_data ) :

							$wp_vuln_issues = self::get_vuln_issues( $wp_vuln_data['vulnerabilities'] );

							if ( ! empty( $wp_vuln_issues ) ) {
								if ( is_array( $site_ignored_wp_issues ) ) {
									$wp_vuln_issues = array_diff_key( $wp_vuln_issues, $site_ignored_wp_issues );
								}
								if ( is_array( $global_ignored_wp_issues ) ) {
									$wp_vuln_issues = array_diff_key( $wp_vuln_issues, $global_ignored_wp_issues );
								}
							}

							if ( ! empty( $wp_vuln_issues ) ) {
								self::vulnche_nvd_nist_list( $wp_vuln_issues, 'wp', $site_id );
							} else {
								echo '<tr colspan="3"><td>' . esc_html__( 'No WordPress vulnerabilities detected.', 'mainwp-vulnerabilities-checker-extension' ) . '</td></tr>';
							}
							?>
						<?php endforeach; ?>
					</tbody>
				</table>
			</div>
			<h3 class="ui dividing header"><?php esc_html_e( 'Plugins', 'mainwp-vulnerability-checker-extension' ); ?></h3>
			<div class="ui segment">
				<?php
				$plug_results = is_array( $vulner_result ) && isset( $vulner_result['plugin'] ) ? $vulner_result['plugin'] : array();
				$found_issues = false;
				foreach ( $plug_results as $plug_slug => $plug_vuln ) :
					if ( ! empty( $plug_vuln ) ) :
						$show_actions = false;
						$plug_vuln    = json_decode( $plug_vuln, true );
						$plugin_name  = '';

						foreach ( $plug_vuln as $pl_name => $pl_vuln_data ) {
							$plugin_name    = esc_html( $pl_name );
							$pl_vuln_issues = self::get_vuln_issues( $pl_vuln_data['vulnerabilities'], 'plugin' );

							if ( ! empty( $pl_vuln_issues ) ) {
								if ( is_array( $site_ignored_plugins_issues ) ) {
									$pl_vuln_issues = array_diff_key( $pl_vuln_issues, $site_ignored_plugins_issues );
								}
								if ( is_array( $global_ignored_plugins_issues ) ) {
									$pl_vuln_issues = array_diff_key( $pl_vuln_issues, $global_ignored_plugins_issues );
								}
							}
							if ( ! empty( $pl_vuln_issues ) ) :
								$found_issues = true;
								?>
								<table class="ui table">
									<thead>
										<tr>
											<th colspan="2" scope=""><?php echo esc_html__( 'Plugin: ', 'mainwp-vulnerabilities-checker-extension' ) . esc_html( $plugin_name ); ?></th>
											<th style="width: 15%;" scope=""></th>
										</tr>
									</thead>
									<tbody>
										<tr class="active">
											<td><?php echo esc_html( MainWP_Vulnerability_Utility::get_common_word( 'published-date' ) ); ?></td>
											<td><?php echo esc_html( MainWP_Vulnerability_Utility::get_common_word( 'detail' ) ); ?></td>
											<td></td>
										</tr>
										<?php
										$show_fix     = self::vulnche_nvd_nist_list( $pl_vuln_issues, 'plugin', $site_id );
										$show_actions = true;
										?>
									</tbody>
									<?php if ( $show_actions ) : ?>
										<tfoot class="full-width">
											<tr class="vulner-detail-actions" action-type="plugin" slug="<?php echo esc_html( $plug_slug ); ?>" website-id="<?php echo intval( $site_id ); ?>">
												<th colspan="3" scope="">
													<?php if ( $show_fix ) : ?>
														<a href="#" what="update" class="ui green right floated button vulner-detail-action-btn"><?php echo esc_html__( 'Update', 'mainwp-vulnerabilities-checker-extension' ) . ' ' . esc_html( $plugin_name ); ?></a>
													<?php endif; ?>
													<a href="#" what="delete" class="ui green basic button vulner-detail-action-btn"><?php echo esc_html__( 'Delete', 'mainwp-vulnerabilities-checker-extension' ) . ' ' . esc_html( $plugin_name ); ?></a>
												</th>
											</tr>
										</tfoot>
									<?php endif; ?>
								</table>
							<?php endif; ?>
						<?php } ?>
					<?php else : ?>
						<?php echo esc_html( $plug_slug ); ?> <?php echo esc_html__( ' is not in the database.', 'mainwp-vulnerabilities-checker-extension' ); ?>
			</div>
		<?php endif; ?>
					<?php
				endforeach;

				if ( ! $found_issues ) {
					?>
		<table class="ui table">
			<thead>
				<tr>
					<th scope=""><?php echo esc_html__( 'Plugin: ', 'mainwp-vulnerabilities-checker-extension' ); ?></th>
					<th scope=""></th>
				</tr>
			</thead>
			<tbody>
				<tr>
					<td colspan="4"><?php echo esc_html__( 'No vulnerable plugins detected.', 'mainwp-vulnerabilities-checker-extension' ); ?></td>
				</tr>
			<tbody>
		</table>
					<?php
				}
				?>
		</div>
		<h3 class="ui dividing header"><?php esc_html_e( 'Themes', 'mainwp-vulnerability-checker-extension' ); ?></h3>
		<div class="ui segment">
			<?php
			$th_results = is_array( $vulner_result ) && isset( $vulner_result['theme'] ) ? $vulner_result['theme'] : array();

			$found_issues = false;
			foreach ( $th_results as $th_slug => $data ) :
				$th_slug      = esc_html( $th_slug );
				$show_actions = false;
				$theme_vuln   = $data['vulner_data'];
				$theme_vuln   = json_decode( $theme_vuln, true );
				$theme_name   = '';
				if ( empty( $theme_vuln['parent'] ) ) :
					foreach ( $theme_vuln as $th_name => $th_vuln_data ) {
						$theme_name     = esc_html( $th_name );
						$th_vuln_issues = self::get_vuln_issues( $th_vuln_data['vulnerabilities'] );

						if ( ! empty( $th_vuln_issues ) ) {
							if ( is_array( $site_ignored_themes_issues ) ) {
								$th_vuln_issues = array_diff_key( $th_vuln_issues, $site_ignored_themes_issues );
							}
							if ( is_array( $global_ignored_themes_issues ) ) {
								$th_vuln_issues = array_diff_key( $th_vuln_issues, $global_ignored_themes_issues );
							}
						}
						if ( ! empty( $th_vuln_issues ) ) :
							$found_issues = true;
							?>
							<table class="ui selectable table stackable">
								<thead>
									<tr>
										<th colspan="2" scope=""><?php echo esc_html__( 'Theme: ', 'mainwp-vulnerabilities-checker-extension' ) . esc_html( $theme_name ); ?></th>
										<th style="width: 15%;" scope=""></th>
									</tr>
								</thead>
								<tbody>
									<tr class="active">
										<td><?php echo esc_html( MainWP_Vulnerability_Utility::get_common_word( 'published-date' ) ); ?></td>
										<td><?php echo esc_html( MainWP_Vulnerability_Utility::get_common_word( 'detail' ) ); ?></td>
										<td></td>
									</tr>
									<?php
									$show_fix     = self::vulnche_nvd_nist_list( $th_vuln_issues, 'theme', $site_id );
									$show_actions = true;
									?>
								</tbody>
								<?php if ( $show_actions ) : ?>
									<tfoot class="full-width">
										<tr class="vulner-detail-actions" action-type="theme" slug="<?php echo esc_attr( $th_slug ); ?>" theme-name="<?php echo esc_html( $data['name'] ); ?>" website-id="<?php echo intval( $site_id ); ?>">
											<th colspan="3" scope="">
												<?php if ( $show_fix ) : ?>
													<a href="#" what="update" class="ui green right floated button vulner-detail-action-btn"><?php echo esc_html__( 'Update', 'mainwp-vulnerabilities-checker-extension' ) . ' ' . esc_html( $theme_name ); ?></a>
												<?php endif; ?>
												<a href="#" what="delete" class="ui green basic button vulner-detail-action-btn"><?php echo esc_html__( 'Delete', 'mainwp-vulnerabilities-checker-extension' ) . ' ' . esc_html( $theme_name ); ?></a>
											</th>
										</tr>
									</tfoot>
								<?php endif; ?>
							</table>
						<?php endif; ?>
					<?php } ?>
				<?php else : ?>
					<div><?php echo esc_html( $th_slug ); ?> <?php echo esc_html__( ' is not in the database.', 'mainwp-vulnerabilities-checker-extension' ); ?></div>
				<?php endif; ?>
				<?php
			endforeach;

			if ( ! $found_issues ) {
				?>
				<table class="ui selectable table stackable">
					<thead>
						<tr>
							<th scope=""><?php echo esc_html__( 'Theme: ', 'mainwp-vulnerabilities-checker-extension' ); ?></th>
							<th scope=""></th>
						</tr>
					</thead>
					<tbody>
						<tr>
							<td colspan="4"><?php echo esc_html__( 'No vulnerable themes detected.', 'mainwp-vulnerabilities-checker-extension' ); ?></td>
						</tr>
					<tbody>
				</table>
				<?php
			}
			?>
		</div>
		</div>
		<?php
	}

	public static function get_vuln_issues( $vulnerabilities, $type = '' ) {
		$items = array();
		foreach ( $vulnerabilities as $vuln ) {
			if ( 'plugin' == $type && 'wordfence' == strtolower( $vuln['slug'] ) ) {
				continue;
			}
			$datetime                 = strtotime( $vuln['date'] );
			$items[ $vuln['cve_id'] ] = array(
				'datetime'       => $datetime,
				'detail'         => $vuln['detail'],
				'cve_id'         => $vuln['cve_id'],
				'missed_version' => isset( $vuln['missed_version'] ) && ! empty( $vuln['missed_version'] ) ? true : false,
			);
		}
		return $items;
	}

	public static function get_vuln_count_issues( $vulnerabilities, $siteid, $type ) {

		$vuln_issues = self::get_vuln_issues( $vulnerabilities, $type );

		if ( ! empty( $vuln_issues ) ) {
			if ( 'wp' == $type ) {
				$site_ignored_wp_issues   = MainWP_Vulnerability_Hooks::get_website_options( false, $siteid, 'ignored_issues_wp' );
				$global_ignored_wp_issues = MainWP_Vulnerability_Hooks::get_website_options( false, 0, 'ignored_issues_wp' ); // 0: for global.
				if ( is_array( $site_ignored_wp_issues ) ) {
					$vuln_issues = array_diff_key( $vuln_issues, $site_ignored_wp_issues );
				}
				if ( is_array( $global_ignored_wp_issues ) ) {
					$vuln_issues = array_diff_key( $vuln_issues, $global_ignored_wp_issues );
				}
			} elseif ( 'plugin' == $type ) {
				$site_ignored_plugins_issues   = MainWP_Vulnerability_Hooks::get_website_options( false, $siteid, 'ignored_issues_plugins' );
				$global_ignored_plugins_issues = MainWP_Vulnerability_Hooks::get_website_options( false, 0, 'ignored_issues_plugins' ); // 0: for global.
				if ( is_array( $site_ignored_plugins_issues ) ) {
					$vuln_issues = array_diff_key( $vuln_issues, $site_ignored_plugins_issues );
				}
				if ( is_array( $global_ignored_plugins_issues ) ) {
					$vuln_issues = array_diff_key( $vuln_issues, $global_ignored_plugins_issues );
				}
			} elseif ( 'theme' == $type ) {
				$site_ignored_themes_issues   = MainWP_Vulnerability_Hooks::get_website_options( false, $siteid, 'ignored_issues_themes' );
				$global_ignored_themes_issues = MainWP_Vulnerability_Hooks::get_website_options( false, 0, 'ignored_issues_themes' ); // 0: for global.
				if ( is_array( $site_ignored_themes_issues ) ) {
					$vuln_issues = array_diff_key( $vuln_issues, $site_ignored_themes_issues );
				}
				if ( is_array( $global_ignored_themes_issues ) ) {
					$vuln_issues = array_diff_key( $vuln_issues, $global_ignored_themes_issues );
				}
			}
		}
		return count( $vuln_issues );
	}


	public static function vulnche_nvd_nist_list( $items, $type, $site_id ) {

		$show_fix = false;

		usort(
			$items,
			function ( $a, $b ) {
				if ( $a['datetime'] == $b['datetime'] ) {
					return 0;
				}
				return ( $a['datetime'] > $b['datetime'] ) ? -1 : 1;
			}
		);

		foreach ( $items as $item ) {
			echo '<tr site-id="' . esc_html( $site_id ) . '" cve-id="' . esc_html( $item['cve_id'] ) . '" cve-detail="' . esc_html( $item['detail'] ) . '" cve-datetime="' . esc_html( $item['datetime'] ) . '" class="' . ( ! empty( $item['missed_version'] ) ? 'warning' : '' ) . '">';
			echo '<td>' . esc_html( MainWP_Vulnerability_Utility::formatTimestamp( MainWP_Vulnerability_Utility::get_timestamp( $item['datetime'] ) ) ) . '</td>';
			echo '<td>' . esc_html( $item['detail'] ) . '</td>';
			echo '<td class="right aligned"><a href="javascript:void(0)" class="ui mini button" onclick="return mainwp_vulner_issues_ignore_detail(\'site\', \'' . esc_html( $type ) . '\', this )">' . esc_html__( 'Ignore', 'mainwp-vulnerability-checker-extension' ) . '</a> <a href="javascript:void(0)" class="ui mini button" onclick="return mainwp_vulner_issues_ignore_detail(\'global\', \'' . esc_html( $type ) . '\', this )">' . esc_html__( 'Ignore Globally', 'mainwp-vulnerability-checker-extension' ) . '</a></td>';
			echo '</tr>';
		}
		return $show_fix;
	}


	public static function render_ignored_tab() {
		?>
		<div class="ui hidden divider"></div>
		<h3 class="ui header">
			<?php esc_html_e( 'Globally Ignored Vulnerabilities', 'mainwp' ); ?>
		</h3>
		<?php
		self::render_global_ignored();
		?>
		<div class="ui hidden divider"></div>
		<h3 class="ui header">
			<?php esc_html_e( 'Per Site Ignored Vulnerabilities' ); ?>
		</h3>
		<?php
		self::render_sites_ignored();
	}

	public static function render_global_ignored() {

		$all_types = array(
			'wp'     => 'ignored_issues_wp',
			'plugin' => 'ignored_issues_plugins',
			'theme'  => 'ignored_issues_themes',
		);

		foreach ( $all_types as $type => $ignored_field_name ) :
			$found_ignored = false;
			?>
			<h3 class="ui dividing header">
				<?php
				if ( 'wp' === $type ) {
					echo esc_html__( 'WordPress', 'mainwp' );
				} elseif ( 'plugin' === $type ) {
					echo esc_html__( 'Plugin', 'mainwp' );
				} else {
					echo esc_html__( 'Theme', 'mainwp' );
				}
				?>
			</h3>
			<table id="mainwp-globally-ignored-plugins" class="ui compact selectable table stackable">
				<thead>
					<tr>
						<th scope=""><?php echo esc_html( MainWP_Vulnerability_Utility::get_common_word( 'published-date' ) ); ?></th>
						<th scope=""><?php echo esc_html( MainWP_Vulnerability_Utility::get_common_word( 'detail' ) ); ?></th>
						<th scope=""></th>
					</tr>
				</thead>
				<tbody id="globally-ignored-plugins-issues-list">
					<?php

					$ignored_issues = MainWP_Vulnerability_Hooks::get_website_options( false, 0, $ignored_field_name ); // 0: for global.
					if ( ! is_array( $ignored_issues ) ) {
						$ignored_issues = array();
					}

					if ( ! empty( $ignored_issues ) ) :
						$found_ignored = true;
						foreach ( $ignored_issues as $cve_id => $item ) :
							?>
							<tr cve-id="<?php echo rawurlencode( $cve_id ); ?>">
								<td><?php echo esc_html( MainWP_Vulnerability_Utility::formatTimestamp( MainWP_Vulnerability_Utility::get_timestamp( $item['datetime'] ) ) ); ?></td>
								<td><?php echo esc_html( $item['detail'] ); ?></td>
								<td class="right aligned"><a class="ui mini button" onclick="return mainwp_vulner_unignore_issue_item( 'global', '<?php echo esc_html( $type ); ?>', this )" href="javascript:void(0)"> <?php esc_html_e( 'Unignore', 'mainwp' ); ?></a></td>
							</tr>
						<?php endforeach; ?>
					<?php endif; ?>

					<?php if ( ! $found_ignored ) : ?>
						<tr>
							<td colspan="999"><?php esc_html_e( 'No ignored issues', 'mainwp' ); ?></td>
						</tr>
					<?php endif; ?>
				</tbody>
				<?php if ( $found_ignored ) : ?>
					<tfoot class="full-width">
						<tr>
							<th colspan="999" scope="">
								<a class="ui right floated small green labeled icon button" onclick="return mainwp_vulner_unignore_issues_all( 'global', '<?php echo esc_html( $type ); ?>', this );" id="mainwp-unignore-globally-all" href="javascript:void(0)">
									<i class="check icon"></i> <?php esc_html_e( 'Unignore All', 'mainwp' ); ?>
								</a>
							</th>
						</tr>
					</tfoot>
				<?php endif; ?>
			</table>
		<?php endforeach; ?>
		<?php
	}


	/**
	 * Render Per Site Ignored table.
	 *
	 * @return void
	 */
	public static function render_sites_ignored() { // phpcs:ignore -- NOSONAR 
		$websites = apply_filters( 'mainwp_db_get_websites_for_current_user', false );
		$cnt      = apply_filters( 'mainwp_db_num_rows', false, $websites );

		$all_types = array(
			'wp'     => 'ignored_issues_wp',
			'plugin' => 'ignored_issues_plugins',
			'theme'  => 'ignored_issues_themes',
		);
		foreach ( $all_types as $type => $ignored_field_name ) :
			$found_ignored = false;
			?>

			<h3 class="ui dividing header">
				<?php
				if ( 'wp' === $type ) {
					echo esc_html__( 'WordPress', 'mainwp' );
				} elseif ( 'plugin' === $type ) {
					echo esc_html__( 'Plugin', 'mainwp' );
				} else {
					echo esc_html__( 'Theme', 'mainwp' );
				}
				?>
			</h3>
			<table id="mainwp-per-site-ignored-plugins" class="ui compact selectable table stackable">
				<thead>
					<tr>
						<th scope=""><?php esc_html_e( 'Site', 'mainwp' ); ?></th>
						<th scope=""><?php echo esc_html( MainWP_Vulnerability_Utility::get_common_word( 'published-date' ) ); ?></th>
						<th scope=""><?php echo esc_html( MainWP_Vulnerability_Utility::get_common_word( 'detail' ) ); ?></th>
						<th scope=""></th>
					</tr>
				</thead>
				<tbody id="ignored-plugins-issues-list">
					<?php
					if ( 0 < $cnt ) :
						do_action( 'mainwp_db_data_seek', $websites, 0 );
						while ( $websites && ( $website = apply_filters( 'mainwp_db_fetch_object', false, $websites ) ) ) {
							$ignored_issues = MainWP_Vulnerability_Hooks::get_website_options( false, $website, $ignored_field_name );
							if ( ! is_array( $ignored_issues ) ) {
								$ignored_issues = array();
							}

							if ( ! empty( $ignored_issues ) ) :
								$found_ignored = true;
								$first         = true;
								foreach ( $ignored_issues as $cve_id => $item ) {
									?>
									<tr site-id="<?php echo intval( $website->id ); ?>" cve-id="<?php echo rawurlencode( $cve_id ); ?>">
										<?php if ( $first ) : ?>
											<td>
												<div><a href="<?php echo esc_url( admin_url( 'admin.php?page=managesites&dashboard=' . esc_attr( $website->id ) ) ); ?>"><?php echo esc_html( stripslashes( $website->name ) ); ?></a></div>
											</td>
											<?php $first = false; ?>
										<?php else : ?>
											<td>
												<div style="display:none;"><a href="<?php echo esc_url( admin_url( 'admin.php?page=managesites&dashboard=' . esc_attr( $website->id ) ) ); ?>"><?php echo esc_html( stripslashes( $website->name ) ); ?></a></div>
											</td>
										<?php endif; ?>
										<td><?php echo esc_html( MainWP_Vulnerability_Utility::formatTimestamp( MainWP_Vulnerability_Utility::get_timestamp( $item['datetime'] ) ) ); ?></td>
										<td><?php echo esc_html( $item['detail'] ); ?></td>
										<td class="right aligned"><a class="ui mini button" onclick="return mainwp_vulner_unignore_issue_item( 'site', '<?php echo esc_html( $type ); ?>', this )" href="javascript:void(0)"> <?php esc_html_e( 'Unignore', 'mainwp' ); ?></a></td>
									</tr>
									<?php
								}
								?>
								<?php
							endif;
						}
						?>

						<?php if ( ! $found_ignored ) : ?>
							<tr>
								<td colspan="999"><?php esc_html_e( 'No ignored issues', 'mainwp' ); ?></td>
							</tr>
						<?php endif; ?>
					<?php endif; ?>
				</tbody>
				<?php if ( $found_ignored ) : ?>
					<tfoot class="full-width">
						<tr>
							<th colspan="999" scope="">
								<a class="ui right floated small green labeled icon button" onclick="return mainwp_vulner_unignore_issues_all( 'site', '<?php echo esc_html( $type ); ?>', this );" id="mainwp-vulner-unignore-issues-all" href="javascript:void(0)">
									<i class="check icon"></i> <?php esc_html_e( 'Unignore All', 'mainwp' ); ?>
								</a>
							</th>
						</tr>
					</tfoot>
				<?php endif; ?>
			</table>
			<?php
		endforeach;
		apply_filters( 'mainwp_db_free_result', false, $websites );
	}
} // End of class
