<?php
class MainWP_Vulnerability_DB { // phpcs:ignore -- NOSONAR - multi methods.

	private $mainwp_vulner_checker_db_version = '1.5';
	// Singleton
	private static $instance = null;
	private $table_prefix;

	public static function instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}
		return self::$instance;
	}
	// Constructor
	public function __construct() {
		global $wpdb;
		$this->table_prefix = $wpdb->prefix . 'mainwp_';
	}

	public function table_name( $suffix ) {

		return $this->table_prefix . $suffix;
	}

	// Support old & new versions of WordPress (3.9+)
	public static function use_mysqli() {

		/** @var $wpdb wpdb */
		if ( ! function_exists( 'mysqli_connect' ) ) {
			return false;
		}

		global $wpdb;
		return $wpdb->dbh instanceof mysqli;
	}

	// Installs new DB
	public function install() {

		global $wpdb;
		$currentVersion = get_site_option( 'mainwp_vulner_checker_db_version' );
		if ( $currentVersion == $this->mainwp_vulner_checker_db_version ) {
			return;
		}
		$charset_collate = $wpdb->get_charset_collate();
		$sql             = array();

		$tbl = 'CREATE TABLE `' . $this->table_name( 'vulnerability_checker' ) . '` (
`id` int(11) NOT NULL AUTO_INCREMENT,
`site_id` text NOT NULL,
`wp_vulner_count` SMALLINT NOT NULL DEFAULT 0,
`plugin_vulner_count` SMALLINT NOT NULL DEFAULT 0,
`theme_vulner_count` SMALLINT NOT NULL DEFAULT 0,
`last_check` int(11) NOT NULL DEFAULT 0,
`result` longtext NOT NULL DEFAULT ""';
		if ( '' == $currentVersion ) {
			$tbl .= ',
PRIMARY KEY  (`id`)  ';
		}
		$tbl  .= ') ' . $charset_collate;
		$sql[] = $tbl;

		require_once ABSPATH . 'wp-admin/includes/upgrade.php';
		foreach ( $sql as $query ) {
			dbDelta( $query );
		}
		update_option( 'mainwp_vulner_checker_db_version', $this->mainwp_vulner_checker_db_version );
	}

	public function update_vulner_result( $result ) {
		global $wpdb;

		if ( empty( $result ) ) {
			return false;
		}

		$site_id = $id = 0;
		if ( isset( $result['id'] ) ) {
			$id = $result['id'];
		} elseif ( isset( $result['site_id'] ) ) {
			$site_id = intval( $result['site_id'] );
		} else {
			return false;
		}

		if ( $id ) {
			if ( $this->get_result_by( 'id', $id ) ) {
				if ( $wpdb->update( $this->table_name( 'vulnerability_checker' ), $result, array( 'id' => intval( $id ) ) ) ) {
					return $this->get_result_by( 'id', $id );
				}
			}
		} elseif ( $site_id ) {
			if ( $this->get_result_by( 'site_id', $site_id ) ) {
				$wpdb->update( $this->table_name( 'vulnerability_checker' ), $result, array( 'site_id' => intval( $site_id ) ) );
				return $this->get_result_by( 'site_id', $site_id );
			} elseif ( $wpdb->insert( $this->table_name( 'vulnerability_checker' ), $result ) ) {
				return $this->get_result_by( 'id', $wpdb->insert_id );
			}
		}

		return false;
	}

	public function get_result_by( $by = 'id', $value = null ) {
		global $wpdb;

		if ( empty( $value ) ) {
			return false;
		}

		if ( 'id' === $by ) {
			$sql = $wpdb->prepare( 'SELECT * FROM ' . $this->table_name( 'vulnerability_checker' ) . ' WHERE `id`=%d ', $value );
		} elseif ( 'site_id' === $by ) {
			$sql = $wpdb->prepare( 'SELECT * FROM ' . $this->table_name( 'vulnerability_checker' ) . ' WHERE `site_id`=%d ', $value );
		} elseif ( 'site_ids' === $by ) {
			$site_ids = (array) $value;
			$site_ids = array_map( 'intval', $site_ids );
			$sql      = 'SELECT * FROM ' . $this->table_name( 'vulnerability_checker' ) . ' WHERE `site_id` IN (' . implode( ',', $site_ids ) . ' ) ';
			return $wpdb->get_results( $sql, ARRAY_A );
		} else {
			return false;
		}
		return $wpdb->get_row( $sql, ARRAY_A );
	}

	public function get_all_results( $all_result = true ) {
		global $wpdb;
		$where = '';
		if ( ! $all_result ) {
			$where = " AND `result` <> '' AND ( wp_vulner_count <> 0 OR plugin_vulner_count <> 0 OR theme_vulner_count <> 0 ) ";
		}

		return $wpdb->get_results( 'SELECT * FROM ' . $this->table_name( 'vulnerability_checker' ) . ' WHERE 1 ' . $where, ARRAY_A );
	}

	public function delete_result_by( $by = 'id', $value = null ) {
		global $wpdb;

		if ( empty( $value ) ) {
			return false;
		}

		if ( 'id' !== $by && 'site_id' !== $by ) {
			return false;
		}

		if ( 'id' == $by ) {
			if ( $wpdb->query( $wpdb->prepare( 'DELETE FROM ' . $this->table_name( 'vulnerability_checker' ) . ' WHERE id=%d ', $value ) ) ) {
				return true;
			}
		} elseif ( $wpdb->query( $wpdb->prepare( 'DELETE FROM ' . $this->table_name( 'vulnerability_checker' ) . ' WHERE site_id=%d ', $value ) ) ) {
			return true;
		}
		return false;
	}

	public function get_sites_to_recheck( $schedule = '', $threshold = 0, $time = 0, $max_check = 4 ) {
		if ( $schedule != 'daily' && $schedule != 'weekly' && $schedule != 'monthly' ) {
			return false;
		}
		global $wpdb;
		return $wpdb->get_results( 'SELECT * FROM ' . $this->table_name( 'vulnerability_checker' ) . ' WHERE ( ( ' . $time . ' - last_check ) >= ' . $threshold . ' ) LIMIT ' . $max_check, ARRAY_A );
	}

	public function get_total_vulner() {
		global $wpdb;
		return $wpdb->get_results( 'SELECT SUM(wp_vulner_count) AS total_wp_vulner, SUM(plugin_vulner_count) AS total_plugin_vulner, SUM(theme_vulner_count) AS total_theme_vulner  FROM ' . $this->table_name( 'vulnerability_checker' ) . ' WHERE 1', ARRAY_A );
	}

	protected function escape( $data ) {
		global $wpdb;
		if ( function_exists( 'esc_sql' ) ) {
			return esc_sql( $data );
		} else {
			return $wpdb->escape( $data );
		}
	}

	public function query( $sql ) {

		if ( null == $sql ) {
			return false;
		}
		/** @var $wpdb wpdb */
		global $wpdb;

		$result = @self::_query( $sql, $wpdb->dbh );

		if ( ! $result || ( @self::num_rows( $result ) == 0 ) ) {
			return false;
		}

		return $result;
	}

	public static function _query( $query, $link ) {
		if ( self::use_mysqli() ) {
			return mysqli_query( $link, $query );
		} else {
			return mysql_query( $query, $link );
		}
	}

	public static function fetch_object( $result ) {
		if ( self::use_mysqli() ) {
			return mysqli_fetch_object( $result );
		} else {
			return mysql_fetch_object( $result );
		}
	}

	public static function free_result( $result ) {
		if ( self::use_mysqli() ) {
			mysqli_free_result( $result );
		} else {
			mysql_free_result( $result );
		}
	}

	public static function data_seek( $result, $offset ) {
		if ( self::use_mysqli() ) {
			return mysqli_data_seek( $result, $offset );
		} else {
			return mysql_data_seek( $result, $offset );
		}
	}

	public static function fetch_array( $result, $result_type = null ) {
		if ( self::use_mysqli() ) {
			return mysqli_fetch_array( $result, ( null == $result_type ? MYSQLI_BOTH : $result_type ) );
		} else {
			return mysql_fetch_array( $result, ( null == $result_type ? MYSQL_BOTH : $result_type ) );
		}
	}

	public static function num_rows( $result ) {
		if ( self::use_mysqli() ) {
			return mysqli_num_rows( $result );
		} else {
			return mysql_num_rows( $result );
		}
	}

	public static function is_result( $result ) {
		if ( self::use_mysqli() ) {
			return ( $result instanceof mysqli_result );
		} else {
			return is_resource( $result );
		}
	}

	public function get_results_result( $sql ) {
		if ( null == $sql ) {
			return null;
		}
		/** @var $wpdb wpdb */
		global $wpdb;
		return $wpdb->get_results( $sql, OBJECT_K );
	}
}
