

jQuery(document).ready(function ($) {
	// Dashboard Actions

	// Activate plugin - trigger
	jQuery(document).on('click', '.mainwp-jetpack-protect-activate-plugin', function () {
		mainwp_jetpack_protect_activate_specific($(this), false);
		return false;
	});

	// Update plugin - trigger
	jQuery(document).on('click', '.mainwp-jetpack-protect-update-plugin', function () {
		mainwp_jetpack_protect_update_specific($(this), false);
		return false;
	});

	// Show/Hide plugin - trigger
	jQuery(document).on('click', '.mainwp-jetpack-protect-showhide-plugin', function () {
		mainwp_jetpack_protect_showhide_specific($(this), false);
		return false;
	});

	// Bulk actions menu trigger
	jQuery(document).on('click', '#mainwp-jetpack-protect-actions-button', function () {
		var action = $('#mainwp-jetpack-protect-actions').val();
		console.log(action);

		var selector = '';
		switch (action) {
			case 'activate-selected':
				selector = 'tbody tr.negative .mainwp-jetpack-protect-activate-plugin';
				break;
			case 'update-selected':
				selector = 'tbody tr.warning .mainwp-jetpack-protect-update-plugin';
				break;
			case 'hide-selected':
				selector = 'tbody tr .mainwp-jetpack-protect-showhide-plugin[showhide="hide"]';
				break;
			case 'show-selected':
				selector = 'tbody tr .mainwp-jetpack-protect-showhide-plugin[showhide="show"]';
				break;
			case 'connect-jetpack':
				selector = 'tbody tr .mainwp-jetpack-protect-connect-disconnect[current-status="disconnect"]';
				break;
			case 'disconnect-jetpack':
				selector = 'tbody tr .mainwp-jetpack-protect-connect-disconnect[current-status="connect"]';
				break;
		}
		if (selector !== '') {
			jQuery(selector).addClass('queue');
			mainwp_jetpack_protect_bulk_init( selector );
			mainwp_jetpack_protect_bulk_action(action, selector);
		}
	});

});

// Bulk actions selector
mainwp_jetpack_protect_bulk_action = function (act, selector ) {
	switch (act) {
		case 'activate-selected':
			mainwp_jetpack_protect_activate_specific_next(selector);
			break;
		case 'update-selected':
			mainwp_jetpack_protect_update_specific_next(selector);
			break;
		case 'hide-selected':
			mainwp_jetpack_protect_showhide_specific_next(selector);
			break;
		case 'show-selected':
			mainwp_jetpack_protect_showhide_specific_next(selector);
			break;
		case 'connect-jetpack':
			mainwp_jetpack_protect_connect_disconnect_specific_next(selector, 'connect');
			break;
		case 'disconnect-jetpack':
			mainwp_jetpack_protect_connect_disconnect_specific_next(selector, 'disconnect');
			break;
	}
}

// Show/Hide plugin - show/hide loop
mainwp_jetpack_protect_showhide_specific_next = function (selector) {
	while ((objProcess = jQuery(selector + '.queue:first')) && (objProcess.length > 0) && (jet_protect_bulkCurrentThreads < jet_protect_bulkMaxThreads)) {
		objProcess.removeClass('queue');
		if (objProcess.closest('tr').find('td input[type="checkbox"]:checked').length == 0) {
			continue;
		}
		mainwp_jetpack_protect_showhide_specific(objProcess, true, selector);
	}
}

// Show/Hide plugin
mainwp_jetpack_protect_showhide_specific = function (pObj, bulk, selector) {
	var parent = pObj.closest('tr');
	var showhide = pObj.attr('showhide');
	var statusEl = parent.find('.visibility');

	if (bulk) {
		jet_protect_bulkCurrentThreads++;
	}

	var data = mainwp_secure_data({
		action: 'mainwp_jetpack_protect_showhide_plugin',
		websiteId: parent.attr('website-id'),
		showhide: showhide
	});

	statusEl.html('<i class="notched circle loading icon"></i>').show();

	jQuery.post(ajaxurl, data, function (response) {
		pObj.removeClass('queue');
		if (response && response['error']) {
			statusEl.html('<i class="red times icon"></i>');
		} else if (response && response['result'] == 'SUCCESS') {
			if (showhide == 'show') {
				pObj.text("Hide Plugin");
				pObj.attr('showhide', 'hide');
				parent.find('.wp-reports-visibility').html(__('No'));
			} else {
				pObj.text("Unhide Plugin");
				pObj.attr('showhide', 'show');
				parent.find('.wp-reports-visibility').html(__('Yes'));
			}
			statusEl.hide();
		} else {
			statusEl.html('<i class="red times icon"></i>');
		}

		if (bulk) {
			jet_protect_bulkCurrentThreads--;
			jet_protect_bulkFinishedThreads++;
			mainwp_jetpack_protect_showhide_specific_next(selector);
			mainwp_jetpack_protect_bulk_done();
		}

	}, 'json');
	return false;
}

// Activate plugin - activate loop
mainwp_jetpack_protect_activate_specific_next = function (selector) {
	while ((objProcess = jQuery(selector + '.queue:first')) && (objProcess.length > 0) && (objProcess.length > 0) && (jet_protect_bulkCurrentThreads < jet_protect_bulkMaxThreads)) {
		objProcess.removeClass('queue');
		if (objProcess.closest('tr').find('td input[type="checkbox"]:checked').length == 0) {
			continue;
		}
		mainwp_jetpack_protect_activate_specific(objProcess, true, selector);
	}
}

// Activate plugin - activate instance
mainwp_jetpack_protect_activate_specific = function (pObj, bulk, selector) {
	var parent = pObj.closest('tr');
	var statusEl = parent.find('.updating');
	var slug = parent.attr('plugin-slug');

	var data = mainwp_secure_data({
		action: 'mainwp_jetpack_protect_active_plugin',
		websiteId: parent.attr('website-id'),
		'plugins[]': [slug],
		nonce: mainwp_jetpack_protect_loc.nonce
	});

	if (bulk) {
		jet_protect_bulkCurrentThreads++;
	}

	statusEl.html('<i class="notched circle loading icon"></i>');

	jQuery.post(ajaxurl, data, function (response) {
		statusEl.html('');
		pObj.removeClass('queue');

		if (response && response['error']) {
			statusEl.html('<i class="red times icon"></i>');
		} else if (response && response['result']) {
			parent.removeClass('negative');
			pObj.remove();
		}

		if (bulk) {
			jet_protect_bulkCurrentThreads--;
			jet_protect_bulkFinishedThreads++;
			mainwp_jetpack_protect_activate_specific_next(selector);
		}

	}, 'json');
	return false;
}

// Update plugin - update loop
mainwp_jetpack_protect_update_specific_next = function (selector) {
	while ((objProcess = jQuery(selector + '.queue:first')) && (objProcess.length > 0) && (objProcess.length > 0) && (jet_protect_bulkCurrentThreads < jet_protect_bulkMaxThreads)) {
		objProcess.removeClass('queue');
		if (objProcess.closest('tr').find('td input[type="checkbox"]:checked').length == 0) {
			continue;
		}
		mainwp_jetpack_protect_update_specific(objProcess, true, selector);
	}
}

// Update plugin - update instance
mainwp_jetpack_protect_update_specific = function (pObj, bulk, selector) {
	var parent = pObj.closest('tr');
	var statusEl = parent.find('.updating');
	var slug = parent.attr('plugin-slug');

	var data = mainwp_secure_data({
		action: 'mainwp_jetpack_protect_upgrade_plugin',
		websiteId: parent.attr('website-id'),
		type: 'plugin',
		'slugs[]': [slug],
		nonce: mainwp_jetpack_protect_loc.nonce
	});

	if (bulk) {
		jet_protect_bulkCurrentThreads++;
	}

	statusEl.html('<i class="notched circle loading icon"></i>');

	jQuery.post(ajaxurl, data, function (response) {
		statusEl.html('');
		pObj.removeClass('queue');

		if (response && response['error']) {
			statusEl.html('<i class="red times icon"></i>');
		} else if (response && response['upgrades'][slug]) {
			pObj.remove();
			parent.removeClass('warning');
		} else {
			statusEl.html('<i class="red times icon"></i>');
		}

		if (bulk) {
			jet_protect_bulkCurrentThreads--;
			jet_protect_bulkFinishedThreads++;
			mainwp_jetpack_protect_update_specific_next(selector);
			mainwp_jetpack_protect_bulk_done();
		}

	}, 'json');
	return false;
}
