<?php
/**
 * Plugin Name: MainWP Code Snippets Extension
 * Plugin URI: https://mainwp.com
 * Description: The MainWP Code Snippets Extension is a powerful PHP platform that enables you to execute php code and scripts on your child sites and view the output on your Dashboard. Requires the MainWP Dashboard plugin.
 * Version: 5.0.4
 * Author: MainWP
 * Author URI: https://mainwp.com
 * Documentation URI: https://mainwp.com/help/category/mainwp-extensions/code-snippets/
 */

if ( ! defined( 'MAINWP_CODE_SNIPPETS_PLUGIN_FILE' ) ) {
	define( 'MAINWP_CODE_SNIPPETS_PLUGIN_FILE', __FILE__ );
}

class MainWP_CS_Extension {
	public static $instance = null;
	protected $plugin_url;
	public $plugin_slug;

	static function get_instance() {

		if ( null === self::$instance ) {
			self::$instance = new MainWP_CS_Extension();
		}
		return self::$instance;
	}

	public function __construct() {
		$this->plugin_url  = plugin_dir_url( __FILE__ );
		$this->plugin_slug = plugin_basename( __FILE__ );
		add_action( 'init', array( &$this, 'init' ) );
		add_action( 'init', array( &$this, 'localization' ) );
		add_action( 'admin_init', array( &$this, 'admin_init' ) );
		add_filter( 'plugin_row_meta', array( &$this, 'plugin_row_meta' ), 10, 2 );
		
	}

	public function init() {
		MainWP_CS_DB::get_instance()->install();
		MainWP_CS::get_instance()->init();
	}

	/**
	 * MainWP Code Snippets Extension localization.
	 */
	public function localization() {
		load_plugin_textdomain( 'mainwp-code-snippets-extension', false,  dirname( plugin_basename( __FILE__ ) ) . '/languages/' );
	}


	public function plugin_row_meta( $plugin_meta, $plugin_file ) {

		if ( $this->plugin_slug != $plugin_file ) {
			return $plugin_meta;
		}

		$slug     = basename( $plugin_file, '.php' );
		$api_data = get_option( $slug . '_APIManAdder' );
		if ( ! is_array( $api_data ) || ! isset( $api_data['activated_key'] ) || $api_data['activated_key'] != 'Activated' || ! isset( $api_data['api_key'] ) || empty( $api_data['api_key'] ) ) {
			return $plugin_meta;
		}

		$plugin_meta[] = '<a href="?do=checkUpgrade" title="Check for updates.">Check for updates now</a>';
		return $plugin_meta;
	}

	public function admin_init() {
		if ( isset( $_GET['page'] ) && ( 'Extensions-Mainwp-Code-Snippets-Extension' == $_GET['page'] ) ) {
			wp_enqueue_style( 'mainwp-cs-extension-codemirror', $this->plugin_url . 'libs/codemirror/lib/codemirror.css' );
			wp_enqueue_style( 'mainwp-cs-extension-codemirror-night', $this->plugin_url . 'libs/codemirror/theme/night.css' );
			wp_enqueue_style( 'mainwp-cs-extension-codemirror-xq-dark', $this->plugin_url . 'libs/codemirror/theme/xq-dark.css' );
			wp_enqueue_style( 'mainwp-cs-extension-codemirror-the-matrix', $this->plugin_url . 'libs/codemirror/theme/the-matrix.css' );
			wp_enqueue_style( 'mainwp-cs-extension-codemirror-erlang-dark', $this->plugin_url . 'libs/codemirror/theme/erlang-dark.css' );
			wp_enqueue_script( 'mainwp-cs-extension-codemirror', $this->plugin_url . 'libs/codemirror/lib/codemirror.js' );
			wp_enqueue_script( 'mainwp-cs-extension-addon-matchbrackets', $this->plugin_url . 'libs/codemirror/addon/edit/matchbrackets.js' );
			wp_enqueue_script( 'mainwp-cs-extension-addon-closebrackets', $this->plugin_url . 'libs/codemirror/addon/edit/closebrackets.js' );
			wp_enqueue_script( 'mainwp-cs-extension-addon-closetag', $this->plugin_url . 'libs/codemirror/addon/edit/closetag.js' );
			wp_enqueue_script( 'mainwp-cs-extension-addon-active-line', $this->plugin_url . 'libs/codemirror/addon/selection/active-line.js' );
			wp_enqueue_script( 'mainwp-cs-extension-addon-mark-selection', $this->plugin_url . 'libs/codemirror/addon/selection/mark-selection.js' );
			wp_enqueue_script( 'mainwp-cs-extension-addon-selection-pointer', $this->plugin_url . 'libs/codemirror/addon/selection/selection-pointer.js' );
			wp_enqueue_script( 'mainwp-cs-extension-mode-htmlmixed', $this->plugin_url . 'libs/codemirror/addon/hint/html-hint.js' );
			wp_enqueue_script( 'mainwp-cs-extension-mode-xml', $this->plugin_url . 'libs/codemirror/addon/hint/xml-hint.js' );
			wp_enqueue_script( 'mainwp-cs-extension-mode-javascript', $this->plugin_url . 'libs/codemirror/addon/lint/javascript-lint.js' );
			wp_enqueue_script( 'mainwp-cs-extension-mode-css', $this->plugin_url . 'libs/codemirror/addon/hint/css-hint.js' );

			wp_enqueue_script( 'mainwp-cs-extension', $this->plugin_url . 'js/mainwp-codesnippets.js' );
			wp_enqueue_style( 'mainwp-cs-extension', $this->plugin_url . 'css/mainwp-codesnippets.css' );
		}
	}
}

class MainWP_CS_Extension_Activator {
	protected $mainwpMainActivated = false;
	protected $childEnabled        = false;
	protected $childKey            = false;
	protected $childFile;
	protected $plugin_handle    = 'mainwp-code-snippets-extension';
	protected $product_id       = 'MainWP Code Snippets Extension';
	protected $software_version = '5.0.4';

	public function __construct() {

		$this->childFile = __FILE__;

		spl_autoload_register( array( $this, 'autoload' ) );
		register_activation_hook( __FILE__, array( $this, 'activate' ) );
		register_deactivation_hook( __FILE__, array( $this, 'deactivate' ) );

		add_filter( 'mainwp_getextensions', array( &$this, 'get_this_extension' ) );
		$this->mainwpMainActivated = apply_filters( 'mainwp_activated_check', false );

		if ( $this->mainwpMainActivated !== false ) {
			$this->activate_this_plugin();
		} else {
			add_action( 'mainwp_activated', array( &$this, 'activate_this_plugin' ) );
		}
		add_action( 'admin_init', array( &$this, 'admin_init' ) );
		add_action( 'admin_notices', array( &$this, 'mainwp_error_notice' ) );
	}

	public function autoload( $class_name ) {
		$class_name = str_replace( '_', '-', strtolower( $class_name ) );
		if ( 0 !== strpos( $class_name, 'mainwp-cs' ) ) {
			return;
		}
		$class_file = WP_PLUGIN_DIR . DIRECTORY_SEPARATOR . str_replace( basename( __FILE__ ), '', plugin_basename( __FILE__ ) ) . 'class' . DIRECTORY_SEPARATOR . $class_name . '.class.php';
		if ( file_exists( $class_file ) ) {
			require_once $class_file;
		}
	}

	public function admin_init() {
		if ( get_option( 'mainwp_code_snippets_extension_activated' ) == 'yes' ) {
			delete_option( 'mainwp_code_snippets_extension_activated' );
			wp_redirect( admin_url( 'admin.php?page=Extensions' ) );
			return;
		}
	}

	public function get_this_extension( $args ) {
		$args[] = array(
			'plugin'     => __FILE__,
			'api'        => $this->plugin_handle,
			'mainwp'     => true,
			'callback'   => array( &$this, 'settings' ),
			'apiManager' => true,
		);
		return $args;
	}

	public function settings() {
		do_action( 'mainwp_pageheader_extensions', __FILE__ );
		MainWP_CS::render();
		do_action( 'mainwp_pagefooter_extensions', __FILE__ );
	}

	public function activate_this_plugin() {
		$this->mainwpMainActivated = apply_filters( 'mainwp_activated_check', $this->mainwpMainActivated );
		$this->childEnabled        = apply_filters( 'mainwp_extension_enabled_check', __FILE__ );
		$this->childKey            = $this->childEnabled['key'];

		if ( function_exists( 'mainwp_current_user_can' ) && ! mainwp_current_user_can( 'extension', 'mainwp-code-snippets-extension' ) ) {
			return;
		}

		new MainWP_CS_Extension();
	}

	public function mainwp_error_notice() {
		global $current_screen;
		if ( $current_screen->parent_base == 'plugins' && $this->mainwpMainActivated == false ) {
			echo '<div class="error"><p>MainWP Code Snippets Extension ' . __( 'requires <a href="https://mainwp.com/" target="_blank">MainWP Dashboard Plugin</a> to be activated in order to work. Please install and activate <a href="https://mainwp.com/" target="_blank">MainWP Dashboard Plugin</a> first.' ) . '</p></div>';
		}
	}

	public function get_child_key() {
		return $this->childKey;
	}

	public function get_child_file() {
		return $this->childFile;
	}

	public function update_option( $option_name, $option_value ) {
		$success = add_option( $option_name, $option_value, '', 'no' );
		if ( ! $success ) {
			$success = update_option( $option_name, $option_value );
		}
		return $success;
	}

	public function activate() {
		$options = array(
			'product_id'       => $this->product_id,
			'software_version' => $this->software_version,
		);
		do_action( 'mainwp_activate_extention', $this->plugin_handle, $options );
	}

	public function deactivate() {
		do_action( 'mainwp_deactivate_extention', $this->plugin_handle );
	}
}

global $mainWPCSExtensionActivator;
$mainWPCSExtensionActivator = new MainWP_CS_Extension_Activator();
