<?php
/*
  Plugin Name: MainWP BackUpWordPress Extension
  Plugin URI: https://mainwp.com
  Description: MainWP BackUpWordPress Extension combines the power of your MainWP Dashboard with the popular WordPress BackUpWordPress Plugin. It allows you to schedule backups on your child sites.
  Version: 4.0.2
  Author: MainWP
  Author URI: https://mainwp.com
  Documentation URI: https://mainwp.com/help/category/mainwp-extensions/backupwordpress/
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( 'No direct access allowed' ); }

// Only load if >= PHP 5.3
if ( version_compare( phpversion(), '5.3', '>=' ) ) {
	if ( ! defined( 'MAINWP_HMBKP_PLUGIN_PATH' ) ) {
		define( 'MAINWP_HMBKP_PLUGIN_PATH', plugin_dir_path( __FILE__ ) );
	}

	if ( ! defined( 'MAINWP_HMBKP_BASENAME' ) ) {
		define( 'MAINWP_HMBKP_BASENAME', plugin_basename( __FILE__ ) );
	}
} else {
	wp_die( sprintf( __( 'MainWP BackUpWordPress Extension will not work on this site. ( PHP Version %s is unsupported )', 'mainwp-backupwordpress-extension' ), phpversion() ), __( 'BackUpWordPress Error', 'mainwp-backupwordpress-extension' ), array( 'back_link' => true ) );
}

if ( ! defined( 'MAINWP_BACKUPWP_PLUGIN_FILE' ) ) {
	define( 'MAINWP_BACKUPWP_PLUGIN_FILE', __FILE__ );
}

define( 'MAINWP_BACKUPWP_DIR', dirname( __FILE__ ) );
define( 'MAINWP_BACKUPWP_URL', plugins_url( '', __FILE__ ) );

class MainWP_BackUp_WordPress_Extension {

	public $plugin_slug;
	public static $isPremium = null;
	public $backupwp_sites = null;
	private static $instance = null;

  static function get_instance() {
		if ( null == MainWP_BackUp_WordPress_Extension::$instance ) {
			MainWP_BackUp_WordPress_Extension::$instance = new MainWP_BackUp_WordPress_Extension();
		}
		return MainWP_BackUp_WordPress_Extension::$instance;
	}

	public function __construct() {

		$this->plugin_slug = plugin_basename( __FILE__ );

		add_filter( 'plugin_row_meta', array( &$this, 'plugin_row_meta' ), 10, 2 );
		add_action( 'init', array( &$this, 'init' ) );
		add_action( 'admin_init', array( &$this, 'admin_init' ) );

		add_filter( 'mainwp-getsubpages-sites', array( &$this, 'managesites_subpage' ), 10, 1 );

    $add_managesites_column = false;
		$primary_backup = get_option( 'mainwp_primaryBackup', null );
		
		if ( 'backupwp' == $primary_backup ) {
			add_filter( 'mainwp-managesites-getbackuplink', array( $this, 'managesites_backup_link' ), 10, 3 );
			add_filter( 'mainwp-getcustompage-backups', array( $this, 'add_page_backups' ), 10, 1 );
			add_filter( 'mainwp-getprimarybackup-activated', array( $this, 'primary_backups_activated' ), 10, 1 );
      $add_managesites_column = true;
		} else if (empty($primary_backup)) {
      $add_managesites_column = true;
    }

    if ($add_managesites_column) {
      add_filter( 'mainwp_managesites_column_url', array( &$this, 'managesites_column_url' ), 10, 2 );
    }

		add_filter( 'mainwp-sync-others-data', array( $this, 'sync_others_data' ), 10, 2 );
		add_action( 'mainwp-site-synced', array( $this, 'synced_site' ), 10, 2 );

		add_filter( 'mainwp-sync-extensions-options', array( &$this, 'mainwp_sync_extensions_options' ), 10, 1 );
		add_action( 'mainwp_applypluginsettings_mainwp-backupwordpress-extension', array( MainWP_BackUp_WordPress::get_instance(), 'mainwp_apply_plugin_settings' ) );

		add_filter( 'mainwp-getprimarybackup-methods', array( $this, 'primary_backups_method' ), 10, 1 );

		//        if (isset($_POST['mainwp_premium_backupwp_site_id']) && isset($_POST['submit'])) {
		//             $is_premium = (isset($_POST['mwp_backupwp_is_premium']) &&  $_POST['mwp_backupwp_is_premium'] == "yes") ? 1 : 0;
		//             if (empty($_POST['mainwp_premium_backupwp_site_id'])) {
		//                update_option("mainwp_backupwp_general_is_premium", $is_premium);
		//            } else {
		//                $update = array(
		//                    'site_id' => $_POST['mainwp_premium_backupwp_site_id'],
		//                    'is_premium' => $is_premium
		//                );
		//                MainWP_BackUp_WordPress_DB::get_instance()->update_backupwp($update);
		//            }
		//            self::$isPremium = $is_premium;
		//        }

		if ( ('backupwp' == $primary_backup) && isset( $_GET['page'] ) && 'managesites' == $_GET['page'] && !isset( $_GET['id'] ) && !isset( $_GET['do']) && !isset( $_GET['dashboard'])) {
			// load data to reduce db query
//			if ( $this->backupwp_sites === null ) {
//				$this->backupwp_sites = MainWP_BackUp_WordPress_Plugin::get_instance()->get_backupwp_websites();
//			}
		}
		require_once( MAINWP_HMBKP_PLUGIN_PATH . 'classes/class-plugin.php' );
	}

	static function is_backupwp_premium() {
		if ( null === self::$isPremium ) {
			if ( MainWP_BackUp_WordPress::is_managesites_page() ) {
				$sid = MainWP_BackUp_WordPress::get_site_id_managesites_backupwp();
				$data = MainWP_BackUp_WordPress_DB::get_instance()->get_backupwp_by( 'site_id', $sid );
				if ( $data ) {
					self::$isPremium = $data->is_premium; }
			} else {
				self::$isPremium = get_option( 'mainwp_backupwp_general_is_premium', 0 );
			}
		}
		return self::$isPremium;
	}

	public function sync_others_data( $data, $pWebsite = null ) {
		if ( ! is_array( $data ) ) {
			$data = array(); }
		$data['syncBackUpWordPress'] = 1;
		return $data;
	}

	function mainwp_sync_extensions_options($values = array()) {
		$values['mainwp-backupwordpress-extension'] = array(
			'plugin_name' => 'BackUpWordPress',
			'plugin_slug' => 'backupwordpress/backupwordpress.php'
		);
		return $values;
	}

	public function synced_site( $pWebsite, $information = array() ) {
		if ( is_array( $information ) && isset( $information['syncBackUpWordPress'] ) ) {
			$data = $information['syncBackUpWordPress'];
			if ( is_array( $data ) ) {
				if ( isset( $data['lasttime_backup'] ) ) {
					$update = array(
						'site_id' => $pWebsite->id,
						'lasttime_backup' => $data['lasttime_backup'],
					);
					MainWP_BackUp_WordPress_DB::get_instance()->update_backupwp( $update );
				}
			}
			unset( $information['syncBackUpWordPress'] );
		}
	}

	public function primary_backups_activated( $input ) {
		return 'backupwp';
	}

	public function primary_backups_method( $methods ) {
		$methods[] = array( 'value' => 'backupwp', 'title' => 'MainWP BackUpWordPress Extension' );
		return $methods;
	}

	public function plugin_row_meta( $plugin_meta, $plugin_file ) {
		if ( $this->plugin_slug != $plugin_file ) {
			return $plugin_meta; }

		$slug = basename($plugin_file, ".php");
		$api_data = get_option( $slug. '_APIManAdder');
		if (!is_array($api_data) || !isset($api_data['activated_key']) || $api_data['activated_key'] != 'Activated' || !isset($api_data['api_key']) || empty($api_data['api_key']) ) {
			return $plugin_meta;
		}

		$plugin_meta[] = '<a href="?do=checkUpgrade" title="Check for updates.">Check for updates now</a>';
		return $plugin_meta;
	}

	function managesites_subpage( $subPage ) {
		$subPage[] = array(
		'title'					 => __( 'BackUpWordPress', 'mainwp-backupwordpress-extension' ),
			'slug'				 => 'BackUpWordPress',
			'sitetab'			 => true,
			'menu_hidden'  => true,
			'callback'		 => array( 'MainWP_BackUp_WordPress', 'render' ),
		);
		return $subPage;
	}

	public function managesites_column_url( $actions, $websiteid ) {
    $actions['backupwordpress'] = sprintf( '<a href="admin.php?page=ManageSitesBackUpWordPress&id=%1$s">' . __( 'BackUpWordPress', 'mainwp-backupwordpress-extension' ) . '</a>', $websiteid );
    return $actions;
	}

	public function managesites_backup_link( $input, $site_id, $last_primary_backup = 0) {

		if ( $site_id ) {
//			$lastbackup = 0;
//			$override = 0;

//			if ( is_array( $this->backupwp_sites ) && isset( $this->backupwp_sites[ $site_id ] ) ) {
//				$d = $this->backupwp_sites[ $site_id ];
//				if ( is_array( $d ) ) {
//					$lastbackup = (isset( $d['lastbackup_gmttime'] )) ? $d['lastbackup_gmttime'] : 0;
//					$override = $d['isOverride'];
//				}
//			}
			$output = '';
			if ( ! empty( $last_primary_backup ) ) {
				$output = MainWP_BackUp_WordPress_Utility::format_timestamp( MainWP_BackUp_WordPress_Utility::get_timestamp( $last_primary_backup ) ) . '<br />';
      } else {
				$output = '<span class="mainwp-red">Never</span><br/>';
      }

      if ( mainwp_current_user_can( 'dashboard', 'execute_backups' ) ) {
	      $link = sprintf( '<a href="admin.php?page=ManageSitesBackUpWordPress&id=%s">' . __( 'Backup Now', 'mainwp-backupwordpress-extension' ) . '</a>', $site_id );
	      $output .= $link;
      }
      return $output;
		} else {
			return $input;
		}
	}

	public function add_page_backups( $input = null ) {
		return array( 'title' => __( 'Existing Backups', 'mainwp-backupwordpress-extension' ), 'slug' => 'MainWP_BackUp_WordPress', 'managesites_slug' => 'BackUpWordPress', 'callback' => array( $this, 'render_redicting' ) );
	}

	public function render_redicting() {
		?>
    <div id="mainwp_background-box">
			<div style="font-size: 30px; text-align: center; margin-top: 5em;"><?php _e( 'You will be redirected to the page immediately.', 'mainwp-backupwordpress-extension' ); ?></div>
      <script type="text/javascript">
      	window.location = "admin.php?page=Extensions-Mainwp-Backupwordpress-Extension";
      </script>
    </div>
		<?php
	}

	public function init() {

	}

	public function admin_init() {
		wp_enqueue_style( 'mainwp-backupwp-extension', MAINWP_BACKUPWP_URL . '/css/mainwp-backupwp.css' );
		wp_enqueue_script( 'mainwp-backupwp-extension', MAINWP_BACKUPWP_URL . '/js/mainwp-backupwp.js' );

		MainWP_BackUp_WordPress::get_instance()->admin_init();
		MainWP_BackUp_WordPress_Plugin::get_instance()->admin_init();
	}
}

class MainWP_BackUp_WordPress_Extension_Activator {

	protected $mainwpMainActivated = false;
	protected $childEnabled = false;
	protected $childKey = false;
	protected $childFile;
	protected $plugin_handle = 'mainwp-backupwordpress-extension';
	protected $product_id = 'MainWP BackUpWordPress Extension';
	protected $software_version = '4.0.2';

	public function __construct() {

		$this->childFile = __FILE__;

    spl_autoload_register( array( $this, 'autoload' ) );
    register_activation_hook( __FILE__, array($this, 'activate') );
    register_deactivation_hook( __FILE__, array($this, 'deactivate') );

		add_filter( 'mainwp-getextensions', array( &$this, 'get_this_extension' ) );
		$this->mainwpMainActivated = apply_filters( 'mainwp-activated-check', false );

		if ( $this->mainwpMainActivated !== false ) {
			$this->activate_this_plugin();
		} else {
			add_action( 'mainwp-activated', array( &$this, 'activate_this_plugin' ) );
		}
		add_action( 'admin_notices', array( &$this, 'mainwp_error_notice' ) );
		MainWP_BackUp_WordPress_DB::get_instance()->install();
	}


  function autoload( $class_name ) {
    $allowedLoadingTypes = array( 'base' );
    $class_name = str_replace( '_', '-', strtolower( $class_name ) );
    foreach ( $allowedLoadingTypes as $allowedLoadingType ) {
      $class_file = WP_PLUGIN_DIR . DIRECTORY_SEPARATOR . str_replace( basename( __FILE__ ), '', plugin_basename( __FILE__ ) ) . $allowedLoadingType . DIRECTORY_SEPARATOR . $class_name . '.class.php';
      if ( file_exists( $class_file ) ) {
        require_once( $class_file );
      }
    }
  }

	function get_this_extension( $pArray ) {
		$pArray[] = array( 'plugin' => __FILE__, 'api' => $this->plugin_handle, 'mainwp' => true, 'callback' => array( &$this, 'settings' ), 'apiManager' => true );
		return $pArray;
	}

	function settings() {
		do_action( 'mainwp-pageheader-extensions', __FILE__ );
		MainWP_BackUp_WordPress::render();
		do_action( 'mainwp-pagefooter-extensions', __FILE__ );
	}

	function activate_this_plugin() {
		$this->mainwpMainActivated = apply_filters( 'mainwp-activated-check', $this->mainwpMainActivated );
		$this->childEnabled = apply_filters( 'mainwp-extension-enabled-check', __FILE__ );
		$this->childKey = $this->childEnabled['key'];
		if ( function_exists( 'mainwp_current_user_can' ) && ! mainwp_current_user_can( 'extension', 'mainwp-backupwordpress-extension' ) ) {
			return;
		}
		MainWP_BackUp_WordPress_Extension::get_instance();
	}

	public function get_child_key() {
		return $this->childKey;
	}

	public function get_child_file() {
		return $this->childFile;
	}

	function mainwp_error_notice() {
		global $current_screen;
		if ( $current_screen->parent_base == 'plugins' && $this->mainwpMainActivated == false ) {
			echo '<div class="error"><p>MainWP BackUpWordPress Extension ' . __( 'requires <a href="https://mainwp.com/" target="_blank">MainWP Dashboard Plugin</a> to be activated in order to work. Please install and activate <a href="https://mainwp.com/" target="_blank">MainWP Dashboard Plugin</a> first.' ) . '</p></div>';
		}
	}

	public function activate() {
		$options = array(
      'product_id' 			 => $this->product_id,
			'software_version' => $this->software_version,
		);
    do_action( 'mainwp_activate_extention', $this->plugin_handle , $options );
	}

	public function deactivate() {
    do_action( 'mainwp_deactivate_extention', $this->plugin_handle );
	}
}

global $mainWPBackUpWordPressExtensionActivator;
$mainWPBackUpWordPressExtensionActivator = new MainWP_BackUp_WordPress_Extension_Activator();
