jQuery( document ).ready(function ($) {
	$( '#mwp_backupwp_dashboard_tab_lnk' ).on('click', function () {
		jQuery( '.backupwp_tabs_lnk a.mainwp_action_down' ).removeClass( 'mainwp_action_down' );
		jQuery( this ).addClass( 'mainwp_action_down' );
		jQuery( '#mainwp_backupwp_screens_tab' ).hide();
		jQuery( '#mwp_backupwp_dashboard_tab' ).show();
		return false;
	});

	$( '#mwp_backupwp_settings_save_btn' ).on('click', function () {
		var statusEl = jQuery( '#mwp_backupwp_perform_individual_status' );
		var loaderEl = jQuery( '#backupwp_site_settings i.loader' );
		statusEl.hide();
		loaderEl.show();
		data = {
			action: 'mainwp_backupwp_site_override_settings',
			backupwpRequestSiteID: $( 'input[name=mainwp_backupwp_settings_site_id]' ).val(),
			override: $( '#mainwp_backupwp_override_general_settings' ).is( ":checked" ) ? 1 : 0,
			_backupwpNonce: mainwp_hmbkp_loc.nonce
		};
		jQuery.post(ajaxurl, data, function (response) {
			loaderEl.hide();
			if (response) {
				if (response.error) {
					statusEl.css( 'color', '#a00' );
					statusEl.html( response.error );
				} else if (response.result == 'success') {
					statusEl.css( 'color', '#f7b100' );
					statusEl.html( '<i class="green check icon"></i> ' + __( 'Saved' ) );
					setTimeout(function ()
						{
						statusEl.fadeOut();
						location.href = location.href;
					}, 2000);
				} else {
					statusEl.css( 'color', '#a00' );
					statusEl.html( '<i class="red times icon"></i> ' + 'Undefined Error' );
				}
			} else {
				statusEl.css( 'color', '#a00' );
				statusEl.html( '<i class="red times icon"></i> ' + 'Undefined Error' );
			}
			statusEl.fadeIn();
		}, 'json');

		return false;
	});

});

jQuery( document ).ready(function ($) {

	jQuery( '#mainwp-backupwp-tips .mainwp-backupwp-show-tut' ).on('click', function () {
		jQuery( '.mainwp-backupwp-tut' ).hide();
		var num = jQuery( this ).attr( 'number' );
		jQuery( '.mainwp-backupwp-tut[number="' + num + '"]' ).show();
		mainwp_setCookie( 'mwp_backupwp_quick_tut_number', jQuery( this ).attr( 'number' ) );
		return false;
	});

	jQuery( '#mainwp-backupwp-quick-start-guide' ).on('click', function () {
		if (mainwp_getCookie( 'mwp_backupwp_quick_guide' ) == 'on') {
			mainwp_setCookie( 'mwp_backupwp_quick_guide', '' ); } else {
			mainwp_setCookie( 'mwp_backupwp_quick_guide', 'on' ); }
			mwp_backupwp_showhide_quick_guide();
			return false;
	});
	jQuery( '#mainwp-backupwp-tips-dismiss' ).on('click', function () {
		mainwp_setCookie( 'mwp_backupwp_quick_guide', '' );
		mwp_backupwp_showhide_quick_guide();
		return false;
	});
	mwp_backupwp_showhide_quick_guide();
});

mwp_backupwp_showhide_quick_guide = function () {
	var show = mainwp_getCookie( 'mwp_backupwp_quick_guide' );
	if (show == 'on') {
		jQuery( '#mainwp-backupwp-tips' ).show();
		jQuery( '#mainwp-backupwp-quick-start-guide' ).hide();
		mwp_backupwp_showhide_quick_tut();
	} else {
		jQuery( '#mainwp-backupwp-tips' ).hide();
		jQuery( '#mainwp-backupwp-quick-start-guide' ).show();
	}
}

mwp_backupwp_showhide_quick_tut = function () {
	var tut = mainwp_getCookie( 'mwp_backupwp_quick_tut_number' );
	jQuery( '.mainwp-backupwp-tut' ).hide();
	jQuery( '.mainwp-backupwp-tut[number="' + tut + '"]' ).show();
}

jQuery( document ).ready(function ($) {
	$( '.backupwp_plugin_upgrade_noti_dismiss' ).live('click', function () {
		var parent = $( this ).closest( '.ext-upgrade-noti' );
		parent.hide();
		var data = {
			action: 'mainwp_backupwp_upgrade_noti_dismiss',
			backupwpRequestSiteID: parent.attr( 'website-id' ),
			new_version: parent.attr( 'version' ),
		}
		jQuery.post(ajaxurl, data, function (response) {

		});
		return false;
	});

	$( '.mwp_backupwp_active_plugin' ).on('click', function () {
		mainwp_backupwp_plugin_active_start_specific( $( this ), false );
		return false;
	});

	$( '.mwp_backupwp_upgrade_plugin' ).on('click', function () {
		mainwp_backupwp_plugin_upgrade_start_specific( $( this ), false );
		return false;
	});

//	$( '.mwp_backupwp_showhide_plugin' ).on('click', function () {
//		mainwp_backupwp_plugin_showhide_start_specific( $( this ), false );
//		return false;
//	});

	$( '#backupwp_plugin_doaction_btn' ).on('click', function () {
		var bulk_act = $( '#mwp_backupwp_plugin_action' ).val();
		mainwp_backupwp_plugin_do_bulk_action( bulk_act );
	});

});

var backupwp_bulkMaxThreads = 3;
var backupwp_bulkTotalThreads = 0;
var backupwp_bulkCurrentThreads = 0;
var backupwp_bulkFinishedThreads = 0;

mainwp_backupwp_plugin_do_bulk_action = function (act) {
	var selector = '';
	switch (act) {
		case 'activate-selected':
			selector = 'tbody tr.negative .mwp_backupwp_active_plugin';
			jQuery( selector ).addClass( 'queue' );
			mainwp_backupwp_plugin_active_start_next( selector );
			break;
		case 'update-selected':
			selector = 'tbody tr.warning .mwp_backupwp_upgrade_plugin';
			jQuery( selector ).addClass( 'queue' );
			mainwp_backupwp_plugin_upgrade_start_next( selector );
			break;
		case 'hide-selected':
			selector = 'tbody tr .mwp_backupwp_showhide_plugin[showhide="hide"]';
			jQuery( selector ).addClass( 'queue' );
			mainwp_backupwp_plugin_showhide_start_next( selector );
			break;
		case 'show-selected':
			selector = 'tbody tr .mwp_backupwp_showhide_plugin[showhide="show"]';
			jQuery( selector ).addClass( 'queue' );
			mainwp_backupwp_plugin_showhide_start_next( selector );
			break;
	}
}

mainwp_backupwp_plugin_showhide_start_next = function (selector) {
	while ((objProcess = jQuery( selector + '.queue:first' )) && (objProcess.length > 0) && (backupwp_bulkCurrentThreads < backupwp_bulkMaxThreads)) {
		objProcess.removeClass( 'queue' );
		if (objProcess.closest( 'tr' ).find( '.check-column input[type="checkbox"]:checked' ).length == 0) {
			continue;
		}
		mainwp_backupwp_plugin_showhide_start_specific( objProcess, true, selector );
	}
}

mainwp_backupwp_plugin_showhide_start_specific = function (pObj, bulk, selector) {
	var parent = pObj.closest( 'tr' );
	var showhide = pObj.attr( 'showhide' );	
	var statusEl = parent.find( '.visibility' );
	
	if (bulk) {
            backupwp_bulkCurrentThreads++; 
        }

	var data = {
		action: 'mainwp_backupwp_showhide_plugin',
		backupwpRequestSiteID: parent.attr( 'website-id' ),
		showhide: showhide
	}
	statusEl.html( '<i class="notched circle loading icon"></i>' );
	jQuery.post(ajaxurl, data, function (response) {
		pObj.removeClass( 'queue' );
		if (response && response['error']) {
			statusEl.html( '<i class="red times icon"></i>' );
		} else if (response && response['result'] == 'SUCCESS') {
			if (showhide == 'show') {
				pObj.text( "Hide Plugin" );
				pObj.attr( 'showhide', 'hide' );
				parent.find( '.wp-backupwp-visibility' ).html( __( 'No' ) );
			} else {
				pObj.text( "Unhide Plugin" );
				pObj.attr( 'showhide', 'show' );
				parent.find( '.wp-backupwp-visibility' ).html( __( 'Yes' ) );
			}
                        statusEl.html('');
		} else {
			statusEl.html( '<i class="red times icon"></i>' );
		}

		if (bulk) {
			backupwp_bulkCurrentThreads--;
			backupwp_bulkFinishedThreads++;
			mainwp_backupwp_plugin_showhide_start_next( selector );
		}

	}, 'json');
	return false;
}

mainwp_backupwp_plugin_upgrade_start_next = function (selector) {
	while ((objProcess = jQuery( selector + '.queue:first' )) && (objProcess.length > 0) && (objProcess.length > 0) && (backupwp_bulkCurrentThreads < backupwp_bulkMaxThreads)) {
		objProcess.removeClass( 'queue' );
		if (objProcess.closest( 'tr' ).prev( 'tr' ).find( '.check-column input[type="checkbox"]:checked' ).length == 0) {
			continue;
		}
		mainwp_backupwp_plugin_upgrade_start_specific( objProcess, true, selector );
	}
}

mainwp_backupwp_plugin_upgrade_start_specific = function (pObj, bulk, selector) {
	var parent = pObj.closest( 'tr' );
	var statusEl = parent.find( '.updating' );
	var slug = parent.attr( 'plugin-slug' );
	var data = {
		action: 'mainwp_backupwp_upgrade_plugin',
		backupwpRequestSiteID: parent.attr( 'website-id' ),
		type: 'plugin',
		'slugs[]': slug
	}

	if (bulk) {
		backupwp_bulkCurrentThreads++; }

	statusEl.html( '<i class="notched circle loading icon"></i>' );
	jQuery.post(ajaxurl, data, function (response) {
		statusEl.html( '' );
		pObj.removeClass( 'queue' );

		if (response && response['error']) {
			statusEl.html( '<i class="red times icon"></i>' );
		} else if (response && response['upgrades'][slug]) {
			pObj.remove();
			parent.removeClass( 'warning' );
		} else {
			statusEl.html( '<i class="red times icon"></i>' );
		}

		if (bulk) {
			backupwp_bulkCurrentThreads--;
			backupwp_bulkFinishedThreads++;
			mainwp_backupwp_plugin_upgrade_start_next( selector );
		}

	}, 'json');
	return false;
}

mainwp_backupwp_plugin_active_start_next = function (selector) {
	while ((objProcess = jQuery( selector + '.queue:first' )) && (objProcess.length > 0) && (objProcess.length > 0) && (backupwp_bulkCurrentThreads < backupwp_bulkMaxThreads)) {
		objProcess.removeClass( 'queue' );
		if (objProcess.closest( 'tr' ).prev( 'tr' ).find( '.check-column input[type="checkbox"]:checked' ).length == 0) {
			continue;
		}
		mainwp_backupwp_plugin_active_start_specific( objProcess, true, selector );
	}
}

mainwp_backupwp_plugin_active_start_specific = function (pObj, bulk, selector) {
	var parent = pObj.closest( 'tr' );
	var statusEl = parent.find( '.updating' );
	var slug = parent.attr( 'plugin-slug' );
	var data = {
		action: 'mainwp_backupwp_active_plugin',
		backupwpRequestSiteID: parent.attr( 'website-id' ),
		'plugins[]': [slug]
	}

	if (bulk) {
		backupwp_bulkCurrentThreads++; }

	statusEl.html( '<i class="notched circle loading icon"></i>' );

	jQuery.post(ajaxurl, data, function (response) {
		statusEl.html( '' );
		pObj.removeClass( 'queue' );
		if (response && response['error']) {
			statusEl.html( '<i class="red times icon"></i>' );
		} else if (response && response['result']) {
			parent.removeClass( 'negative' );
			pObj.remove();
		}
		if (bulk) {
			backupwp_bulkCurrentThreads--;
			backupwp_bulkFinishedThreads++;
			mainwp_backupwp_plugin_active_start_next( selector );
		}

	}, 'json');
	return false;
}

mainwp_backupwp_perform_schedule_start_next = function (what) {
	while ((objProcess = jQuery( '.siteItemProcess[status=queue]:first' )) && (objProcess.length > 0) && (backupwp_bulkCurrentThreads < backupwp_bulkMaxThreads)) {
		objProcess.attr( 'status', 'processed' );
		if (what == 'delete_schedule') {
			mainwp_backupwp_delete_schedule_start_specific( objProcess );
		} else if (what == 'run_schedule') {
			mainwp_backupwp_run_schedule_start_specific( objProcess );
		} else if (what == 'update_schedule') {
			mainwp_backupwp_update_schedule_start_specific( objProcess );
		} else if (what == 'reload_backups') {
			mainwp_backupwp_reload_backups_start_specific( objProcess );
		} else if (what == 'cancel_schedule') {
			mainwp_backupwp_cancel_schedule_start_specific( objProcess );
		} else if (what == 'general_exclude_rules') {
			mainwp_backupwp_general_exclude_rules_specific( objProcess );
		}
	}

	if (backupwp_bulkFinishedThreads > 0 && backupwp_bulkFinishedThreads == backupwp_bulkTotalThreads) {
		jQuery( '#mainwp_backupwp_screens_tab' ).append( '<div class="ui green message">' + __( "Performed action completed." ) + '</div>' );
		setTimeout(function ()
			{
			//location.href = location.href;
		}, 1000);
	}

}

mainwp_backupwp_delete_schedule_start_specific = function (objProcess) {
	var loadingEl = objProcess.find( 'i' );
	var statusEl = objProcess.find( '.status' );
	backupwp_bulkCurrentThreads++;
	var data = {
		action: 'mainwp_backupwp_delete_schedule',
		scheduleId: mainwp_backupwp_schedule_id,
		_backupwpNonce: mainwp_hmbkp_loc.nonce,
		backupwpRequestSiteID: objProcess.attr( 'site-id' )
	};
	statusEl.html( '' );
	loadingEl.show();
	//call the ajax
	jQuery.post(ajaxurl, data, function (response) {
		loadingEl.hide();
		if (response) {
			if (response.error) {
				statusEl.css( 'color', '#a00' );
				statusEl.html( response.error );
			} else if (response.result == 'NOTFOUND') {
				statusEl.css( 'color', '#a00' );
				statusEl.html( '<i class="red times icon"></i> ' + __( 'Schedule has not been found' ) );
			} else if (response.message) {
				statusEl.css( 'color', '#f7b100' );
				statusEl.html( response.message );
			} else if (response.result == 'SUCCESS') {
				statusEl.css( 'color', '#f7b100' );
				statusEl.html( '<i class="green check icon"></i> ' + __( 'Successful' ) );
			} else {
				statusEl.css( 'color', '#a00' );
				statusEl.html( '<i class="red times icon"></i> ' + 'Undefined Error' );
			}
		} else {
			statusEl.css( 'color', '#a00' );
			statusEl.html( '<i class="red times icon"></i> ' + 'Undefined Error' );
		}
		backupwp_bulkCurrentThreads--;
		backupwp_bulkFinishedThreads++;
		mainwp_backupwp_perform_schedule_start_next( 'delete_schedule' );
	}, 'json');
}

mainwp_backupwp_cancel_schedule_start_specific = function (objProcess) {
	var loadingEl = objProcess.find( 'i' );
	var statusEl = objProcess.find( '.status' );
	backupwp_bulkCurrentThreads++;
	var data = {
		action: 'mainwp_backupwp_cancel_schedule',
		scheduleId: mainwp_backupwp_schedule_id,
		_backupwpNonce: mainwp_hmbkp_loc.nonce,
		backupwpRequestSiteID: objProcess.attr( 'site-id' )
	};
	statusEl.html( '' );
	loadingEl.show();
	//call the ajax
	jQuery.post(ajaxurl, data, function (response) {
		loadingEl.hide();
		if (response) {
			if (response.error) {
				statusEl.css( 'color', '#a00' );
				statusEl.html( response.error );
			} else if (response.result == 'NOTFOUND') {
				statusEl.css( 'color', '#a00' );
				statusEl.html( '<i class="red times icon"></i> ' + __( 'Schedule has not been found' ) );
			} else if (response.message) {
				statusEl.css( 'color', '#f7b100' );
				statusEl.html( response.message );
			} else if (response.result == 'SUCCESS') {
				statusEl.css( 'color', '#f7b100' );
				statusEl.html( '<i class="green check icon"></i> ' + __( 'Successful' ) );
			} else {
				statusEl.css( 'color', '#a00' );
				statusEl.html( '<i class="red times icon"></i> ' + 'Undefined Error' );
			}
		} else {
			statusEl.css( 'color', '#a00' );
			statusEl.html( '<i class="red times icon"></i> ' + 'Undefined Error' );
		}
		backupwp_bulkCurrentThreads--;
		backupwp_bulkFinishedThreads++;
		mainwp_backupwp_perform_schedule_start_next( 'cancel_schedule' );
	}, 'json');
}

mainwp_backupwp_reload_backups_start_specific = function (objProcess) {
	var loadingEl = objProcess.find( 'i' );
	var statusEl = objProcess.find( '.status' );
	backupwp_bulkCurrentThreads++;
	var data = {
		action: 'mainwp_backupwp_reload_backups',
		_backupwpNonce: mainwp_hmbkp_loc.nonce,
		backupwpRequestSiteID: objProcess.attr( 'site-id' )
	};
	statusEl.html( '' );
	loadingEl.show();
	//call the ajax
	jQuery.post(ajaxurl, data, function (response) {
		loadingEl.hide();
		if (response) {
			if (response.error) {
				statusEl.css( 'color', '#a00' );
				statusEl.html( response.error );
			} else if (response.result == 'NOTFOUND') {
				statusEl.css( 'color', '#a00' );
				statusEl.html( '<i class="red times icon"></i> ' + __( 'Schedule has not been found' ) );
			} else if (response.message) {
				statusEl.css( 'color', '#f7b100' );
				statusEl.html( response.message );
			} else if (response.result == 'SUCCESS') {
				statusEl.css( 'color', '#f7b100' );
				statusEl.html( '<i class="green check icon"></i> ' + __( 'Successful' ) );
			} else {
				statusEl.css( 'color', '#a00' );
				statusEl.html( '<i class="red times icon"></i> ' + 'Undefined Error' );
			}
		} else {
			statusEl.css( 'color', '#a00' );
			statusEl.html( '<i class="red times icon"></i> ' + 'Undefined Error' );
		}
		backupwp_bulkCurrentThreads--;
		backupwp_bulkFinishedThreads++;
		mainwp_backupwp_perform_schedule_start_next( 'reload_backups' );
	}, 'json');
}

mainwp_backupwp_individual_reload_backups = function (siteId) {
	var loadingEl = jQuery( '#mainwp_backupwp_status_load_backups' ).find( 'i' );
	var statusEl = jQuery( '#mainwp_backupwp_status_load_backups' ).find( '.status' );
	var data = {
		action: 'mainwp_backupwp_reload_backups',
		_backupwpNonce: mainwp_hmbkp_loc.nonce,
		backupwpRequestSiteID: siteId,
		individual: 1
	};
	statusEl.html( '' );
	loadingEl.show();
	//call the ajax
	jQuery.post(ajaxurl, data, function (response) {
		loadingEl.hide();
		if (response) {
			if (response.error) {
				statusEl.css( 'color', '#a00' );
				statusEl.html( response.error );
			} else if (response.result == 'NOTFOUND') {
				statusEl.css( 'color', '#a00' );
				statusEl.html( '<i class="red times icon"></i> ' + __( 'Schedule has not been found on child site' ) );
			} else if (response.result == 'SUCCESS') {
				statusEl.css( 'color', '#f7b100' );
				statusEl.html( '<i class="green check icon"></i> ' + __( 'Done' ) );
				if (response.backupslist_html) {
					jQuery( '.mainwp_backupwp_backupslist_row[site-id="' + siteId + '"]' ).html( response.backupslist_html );
					setTimeout(function ()
						{
						statusEl.fadeOut();
					}, 3000);
				} else {
					location.href = location.href;
				}
			} else {
				statusEl.css( 'color', '#a00' );
				statusEl.html( '<i class="red times icon"></i> ' + 'Undefined Error' );
			}
		} else {
			statusEl.css( 'color', '#a00' );
			statusEl.html( '<i class="red times icon"></i> ' + 'Undefined Error' );
		}
		statusEl.show();
	}, 'json');
}


mainwp_backupwp_individual_reload_excluded = function () {
	var loadingEl = jQuery( '#mainwp_backupwp_status_load_excluded' ).find( 'i' );
	var statusEl = jQuery( '#mainwp_backupwp_status_load_excluded' ).find( '.status' );
	var data = {
		action: 'mainwp_backupwp_reload_excluded',
		scheduleId: mainwp_backupwp_schedule_id,
		_backupwpNonce: mainwp_hmbkp_loc.nonce,
		backupwpRequestSiteID: mainwp_backupwp_current_site_id,
		individual: 1
	};
	statusEl.html( '' );
	loadingEl.show();
	//call the ajax
	jQuery.post(ajaxurl, data, function (response) {
		loadingEl.hide();
		var success = false;
		if (response) {
			if (response.error) {
				msg = response.error;
			} else if (response.result == 'NOTFOUND') {
				msg = '<i class="red times icon"></i> ' + __( 'Schedule has not been found on child site' );
			} else if (response.e) {
				statusEl.css( 'color', '#f7b100' );
				statusEl.html( '<i class="green check icon"></i> ' + __( 'Done' ) );
				jQuery( '#mainwp_backupwp_excluded_content' ).html( response.e );
				setTimeout(function ()
					{
					statusEl.fadeOut();
				}, 3000);
				success = true;
			} else {
				msg = '<i class="red times icon"></i> ' + __( 'Undefined Error' );
			}
		} else {
			msg = '<i class="red times icon"></i> ' + __( 'Undefined Error' );
		}
		if ( ! success) {
			statusEl.css( 'color', '#a00' );
			statusEl.html( msg );
			jQuery( '#mainwp_backupwp_excluded_content' ).html( '<span style="color:red">' + msg + '</span>' );
		}
		statusEl.show();
	}, 'json');
}

var mainwp_backupwp_exclude_current_browse_dir = '';
var mainwp_backupwp_exclude_working = false;

mainwp_backupwp_directory_browse = function (path, pObj) {
	if (mainwp_backupwp_exclude_working) {
		return false; }
	mainwp_backupwp_exclude_working = true;
	var data = {
		action: 'mainwp_backupwp_exclude_directory_browse',
		scheduleId: mainwp_backupwp_schedule_id,
		_backupwpNonce: mainwp_hmbkp_loc.nonce,
		backupwpRequestSiteID: mainwp_backupwp_current_site_id,
		browse_dir: path,
		individual: 1
	};
	jQuery( pObj ).after( '&nbsp;<i style="display: none;" class="notched circle loading icon mwp_backupwp_exc_working"></i>' );
	var loadingEl = jQuery( '.mwp_backupwp_exc_working' );
	loadingEl.show();
	//call the ajax
	jQuery.post(ajaxurl, data, function (response) {
		mainwp_backupwp_exclude_working = false;
		loadingEl.remove();
		jQuery( pObj ).after( '&nbsp;<span class="mwp_backupwp_exc_status"></span>' );
		var statusEl = jQuery( '.mwp_backupwp_exc_status' );
		if (response) {
			if (response.error) {
				statusEl.css( 'color', '#a00' );
				statusEl.html( response.error );
			} else if (response.result == 'NOTFOUND') {
				statusEl.css( 'color', '#a00' );
				statusEl.html( '<i class="red times icon"></i> ' + __( 'Schedule has not been found on child site' ) );
			} else if (response.e) {
				if (response.current_browse_dir) {
					mainwp_backupwp_exclude_current_browse_dir = response.current_browse_dir; } else {
					mainwp_backupwp_exclude_current_browse_dir = ''; }
					jQuery( '#mainwp_backupwp_excluded_content' ).html( response.e );
			} else {
				statusEl.css( 'color', '#a00' );
				statusEl.html( '<i class="red times icon"></i> ' + 'Undefined Error' );
			}
		} else {
			statusEl.css( 'color', '#a00' );
			statusEl.html( '<i class="red times icon"></i> ' + 'Undefined Error' );
		}
	}, 'json');
}

mainwp_backupwp_exclude_add_rule = function (path, pObj) {
	if (mainwp_backupwp_exclude_working) {
		return false; }
	mainwp_backupwp_exclude_working = true;
	var data = {
		action: 'mainwp_backupwp_exclude_directory_add_rule',
		scheduleId: mainwp_backupwp_schedule_id,
		_backupwpNonce: mainwp_hmbkp_loc.nonce,
		backupwpRequestSiteID: mainwp_backupwp_current_site_id,
		exclude_pathname: path,
		browse_dir: mainwp_backupwp_exclude_current_browse_dir,
		individual: 1
	};
	jQuery( '.mwp_backupwp_exc_status' ).remove();
	jQuery( '.mwp_backupwp_exc_working' ).remove();
	jQuery( pObj ).after( '&nbsp;<i style="display: none;" class="fa fa-spinner fa-pulse mwp_backupwp_exc_working"></i>' );
	var loadingEl = jQuery( '.mwp_backupwp_exc_working' );
	loadingEl.show();
	//call the ajax
	jQuery.post(ajaxurl, data, function (response) {
		mainwp_backupwp_exclude_working = false;
		loadingEl.remove();
		jQuery( pObj ).after( '&nbsp;<span class="mwp_backupwp_exc_status"></span>' );
		var statusEl = jQuery( '.mwp_backupwp_exc_status' );
		if (response) {
			if (response.error) {
				statusEl.css( 'color', '#a00' );
				statusEl.html( response.error );
			} else if (response.result == 'NOTFOUND') {
				statusEl.css( 'color', '#a00' );
				statusEl.html( '<i class="red times icon"></i> ' + __( 'Schedule has not been found on child site' ) );
			} else if (response.e) {
				jQuery( '#mainwp_backupwp_excluded_content' ).html( response.e );
				if (response.current_browse_dir) {
					mainwp_backupwp_exclude_current_browse_dir = response.current_browse_dir; } else {
					mainwp_backupwp_exclude_current_browse_dir = ''; }
			} else {
				statusEl.css( 'color', '#a00' );
				statusEl.html( '<i class="red times icon"></i> ' + 'Undefined Error' );
			}
		} else {
			statusEl.css( 'color', '#a00' );
			statusEl.html( '<i class="red times icon"></i> ' + 'Undefined Eerror' );
		}
	}, 'json');
}

mainwp_backupwp_remove_exclude_rule = function (exclude, pObj) {
	if (mainwp_backupwp_exclude_working) {
		return false; }
	mainwp_backupwp_exclude_working = true;
	var data = {
		action: 'mainwp_backupwp_exclude_remove_exclude_rule',
		scheduleId: mainwp_backupwp_schedule_id,
		_backupwpNonce: mainwp_hmbkp_loc.nonce,
		backupwpRequestSiteID: mainwp_backupwp_current_site_id,
		remove_rule: exclude,
		browse_dir: mainwp_backupwp_exclude_current_browse_dir,
		individual: 1
	};
	jQuery( '.mwp_backupwp_exc_status' ).remove();
	jQuery( '.mwp_backupwp_exc_working' ).remove();
	jQuery( pObj ).after( '&nbsp;<i style="display: none;" class="fa fa-spinner fa-pulse mwp_backupwp_exc_working"></i>' );
	var loadingEl = jQuery( '.mwp_backupwp_exc_working' );
	loadingEl.show();
	//call the ajax
	jQuery.post(ajaxurl, data, function (response) {
		mainwp_backupwp_exclude_working = false;
		loadingEl.remove();
		jQuery( pObj ).after( '&nbsp;<span class="mwp_backupwp_exc_status"></span>' );
		var statusEl = jQuery( '.mwp_backupwp_exc_status' );
		if (response) {
			if (response.error) {
				statusEl.css( 'color', '#a00' );
				statusEl.html( response.error );
			} else if (response.result == 'NOTFOUND') {
				statusEl.css( 'color', '#a00' );
				statusEl.html( '<i class="red times icon"></i> ' + __( 'Schedule has not been found on child site' ) );
			} else if (response.e) {
				jQuery( '#mainwp_backupwp_excluded_content' ).html( response.e );
				if (response.current_browse_dir) {
					mainwp_backupwp_exclude_current_browse_dir = response.current_browse_dir; } else {
					mainwp_backupwp_exclude_current_browse_dir = ''; }
			} else {
				statusEl.css( 'color', '#a00' );
				statusEl.html( '<i class="red times icon"></i> ' + 'Undefined Error' );
			}
		} else {
			statusEl.css( 'color', '#a00' );
			statusEl.html( '<i class="red times icon"></i> ' + 'Undefined Error' );
		}
	}, 'json');
}



mainwp_backupwp_edit_exclude_done = function () {
	location.href = 'admin.php?page=ManageSitesBackUpWordPress&mainwp_hmbkp_schedule_id=' + mainwp_backupwp_schedule_id + '&id=' + mainwp_backupwp_current_site_id;
}

mainwp_backupwp_run_schedule_start_specific = function (objProcess) {
	var loadingEl = objProcess.find( 'i' );
	var statusEl = objProcess.find( '.status' );
	backupwp_bulkCurrentThreads++;
	var data = {
		action: 'mainwp_backupwp_run_schedule',
		scheduleId: mainwp_backupwp_schedule_id,
		_backupwpNonce: mainwp_hmbkp_loc.nonce,
		backupwpRequestSiteID: objProcess.attr( 'site-id' )
	};
	statusEl.html( '' );
	loadingEl.show();
	//call the ajax
	jQuery.post(ajaxurl, data, function (response) {
		loadingEl.hide();
		if (response) {
			if (response.error) {
				statusEl.css( 'color', '#a00' );
				statusEl.html( response.error );
			} else if (response.result == 'NOTFOUND') {
				statusEl.css( 'color', '#a00' );
				statusEl.html( '<i class="red times icon"></i> ' + __( 'Schedule has not been found' ) );
			} else if (response.message) {
				statusEl.css( 'color', '#f7b100' );
				statusEl.html( response.message );
			} else if (response.result == 'SUCCESS') {
				statusEl.css( 'color', '#f7b100' );
				statusEl.html( '<i class="green check icon"></i> ' + __( 'Successful' ) );
			} else {
				statusEl.css( 'color', '#a00' );
				statusEl.html( '<i class="red times icon"></i> ' + 'Undefined Error' );
			}
		} else {
			statusEl.css( 'color', '#a00' );
			statusEl.html( '<i class="red times icon"></i> ' + 'Undefined Error' );
		}
		backupwp_bulkCurrentThreads--;
		backupwp_bulkFinishedThreads++;
		mainwp_backupwp_perform_schedule_start_next( 'run_schedule' );
	}, 'json');
}

mainwp_backupwp_update_schedule_start_specific = function (objProcess) {
	var loadingEl = objProcess.find( 'i' );
	var statusEl = objProcess.find( '.status' );
	backupwp_bulkCurrentThreads++;
	var data = {
		action: 'mainwp_backupwp_update_schedule',
		scheduleId: mainwp_backupwp_schedule_id,
		_backupwpNonce: mainwp_hmbkp_loc.nonce,
		backupwpRequestSiteID: objProcess.attr( 'site-id' )
	};
	statusEl.html( '' );
	loadingEl.show();
	//call the ajax
	jQuery.post(ajaxurl, data, function (response) {
		loadingEl.hide();
		if (response) {
			if (response.error) {
				statusEl.css( 'color', '#a00' );
				statusEl.html( response.error );
			} else if (response.result == 'NOTFOUND') {
				statusEl.css( 'color', '#a00' );
				statusEl.html( '<i class="red times icon"></i> ' + __( 'Schedule has not been found' ) );
			} else if (response.result == 'NOTCHANGE') {
				statusEl.css( 'color', '#f7b100' );
				statusEl.html( __( 'Not changed' ) );
			} else if (response.message) {
				statusEl.css( 'color', '#f7b100' );
				statusEl.html( response.message );
			} else if (response.result == 'SUCCESS') {
				statusEl.css( 'color', '#f7b100' );
				statusEl.html( '<i class="green check icon"></i> ' + __( 'Successful' ) );
			} else {
				statusEl.css( 'color', '#a00' );
				statusEl.html( '<i class="red times icon"></i> ' + 'Undefined Error' );
			}
		} else {
			statusEl.css( 'color', '#a00' );
			statusEl.html( '<i class="red times icon"></i> ' + 'Undefined Error' );
		}
		backupwp_bulkCurrentThreads--;
		backupwp_bulkFinishedThreads++;
		mainwp_backupwp_perform_schedule_start_next( 'update_schedule' );
	}, 'json');
}


mainwp_backupwp_general_exclude_rules_specific = function (objProcess) {
	var loadingEl = objProcess.find( 'i' );
	var statusEl = objProcess.find( '.status' );
	backupwp_bulkCurrentThreads++;
	var data = {
		action: 'mainwp_backupwp_general_exclude_rules',
		scheduleId: mainwp_backupwp_schedule_id,
		_backupwpNonce: mainwp_hmbkp_loc.nonce,
		backupwpRequestSiteID: objProcess.attr( 'site-id' )
	};
	statusEl.html( '' );
	loadingEl.show();
	//call the ajax
	jQuery.post(ajaxurl, data, function (response) {
		loadingEl.hide();
		if (response) {
			if (response.error) {
				statusEl.css( 'color', '#a00' );
				statusEl.html( response.error );
			} else if (response.result == 'NOTFOUND') {
				statusEl.css( 'color', '#a00' );
				statusEl.html( '<i class="red times icon"></i> ' + __( 'Schedule has not been found' ) );
			} else if (response.result == 'NOTCHANGE') {
				statusEl.css( 'color', '#f7b100' );
				statusEl.html( __( 'Not changed' ) );
			} else if (response.message) {
				statusEl.css( 'color', '#f7b100' );
				statusEl.html( response.message );
			} else if (response.result == 'SUCCESS') {
				statusEl.css( 'color', '#f7b100' );
				statusEl.html( '<i class="green check icon"></i> ' + __( 'Successful' ) );
			} else {
				statusEl.css( 'color', '#a00' );
				statusEl.html( '<i class="red times icon"></i> ' + 'Undefined Error' );
			}
		} else {
			statusEl.css( 'color', '#a00' );
			statusEl.html( '<i class="red times icon"></i> ' + 'Undefined Error' );
		}
		backupwp_bulkCurrentThreads--;
		backupwp_bulkFinishedThreads++;
		mainwp_backupwp_perform_schedule_start_next( 'general_exclude_rules' );
	}, 'json');
}



jQuery( document ).ready(function ($) {
	// Run a backup
	$( document ).on('click', '.mainwp-hmbkp-run', function (e) {
		e.preventDefault();
		$( '.hmbkp-error' ).removeClass( 'hmbkp-error' );
		var loadingEl = $( this ).closest( '.mwp-hmbkp-schedule-sentence' );
		loadingEl.addClass( 'hmbkp-running' );
		var statusEl = $( this ).closest( '.mwp-hmbkp-schedule-sentence' ).find( '#mwp-hmbkp-schedule-working .status' );
		var schedule_id = $( this ).closest( '.mwp-hmbkp-schedule-sentence' ).attr( 'schedule-id' );
		var backupObj = this;
		var data = {
			action: 'mainwp_backupwp_run_schedule',
			scheduleId: schedule_id,
			_backupwpNonce: mainwp_hmbkp_loc.nonce,
			backupwpRequestSiteID: mainwp_backupwp_current_site_id,
			individual: 1
		};
		statusEl.html( '' );
		//call the ajax
		jQuery.post(ajaxurl, data, function (response) {
			error = true;
			if (response) {
				if (response.error) {
					statusEl.css( 'color', '#a00' );
					statusEl.html( response.error );
					loadingEl.removeClass( 'hmbkp-running' );
				} else if (response.result == 'NOTFOUND') {
					statusEl.css( 'color', '#a00' );
					statusEl.html( '<i class="red times icon"></i> ' + __( 'Schedule has not been found' ) );
				} else if (response.message) {
					statusEl.css( 'color', '#f7b100' );
					statusEl.html( response.message );
				} else if (response.result == 'SUCCESS') {
					statusEl.css( 'color', '#f7b100' );
					statusEl.html( '<i class="green check icon"></i> ' + __( 'Successful' ) );
					setTimeout(function ()
						{
						statusEl.fadeOut();
					}, 3000);
					setTimeout(function ()
						{
						mainwp_backupwp_refresh_backupstatus( backupObj );
					}, 500);
					error = false;
				} else {
					statusEl.css( 'color', '#a00' );
					statusEl.html( '<i class="red times icon"></i> ' + 'Undefined Error' );
				}
			} else {
				statusEl.css( 'color', '#a00' );
				statusEl.html( '<i class="red times icon"></i> ' + 'Undefined Error' );
			}
			if (error) {
				loadingEl.removeClass( 'hmbkp-running' );
			}
			statusEl.show();
		}, 'json');

	});

	// Run a backup
	$( document ).on('click', '.mainwp-hmbkp-cancel', function (e) {
		e.preventDefault();
		$( '.hmbkp-error' ).removeClass( 'hmbkp-error' );
		var loadingEl = $( this ).closest( '.mwp-hmbkp-schedule-sentence' );

		var statusEl = $( this ).closest( '.mwp-hmbkp-schedule-sentence' ).find( '#mwp-hmbkp-schedule-working .status' );
		var spinnerEl = $( this ).closest( '.mwp-hmbkp-schedule-sentence' ).find( '#mwp-hmbkp-schedule-working i' );
		var schedule_id = $( this ).closest( '.mwp-hmbkp-schedule-sentence' ).attr( 'schedule-id' );
		var backupObj = this;
		var data = {
			action: 'mainwp_backupwp_cancel_schedule',
			scheduleId: schedule_id,
			_backupwpNonce: mainwp_hmbkp_loc.nonce,
			backupwpRequestSiteID: mainwp_backupwp_current_site_id,
			individual: 1
		};
		statusEl.html( '' );
		spinnerEl.show();
		//call the ajax
		jQuery.post(ajaxurl, data, function (response) {
			spinnerEl.hide();
			error = true;
			if (response) {
				if (response.error) {
					statusEl.css( 'color', '#a00' );
					statusEl.html( response.error );
					loadingEl.removeClass( 'hmbkp-running' );
				} else if (response.result == 'NOTFOUND') {
					statusEl.css( 'color', '#a00' );
					statusEl.html( '<i class="red times icon"></i> ' + __( 'Scheudule has not been found' ) );
				} else if (response.message) {
					statusEl.css( 'color', '#f7b100' );
					statusEl.html( response.message );
				} else if (response.result == 'SUCCESS') {
					statusEl.css( 'color', '#f7b100' );
					statusEl.html( '<i class="green check icon"></i> ' + __( 'Successful' ) );
					loadingEl.removeClass( 'hmbkp-running' );
					setTimeout(function ()
						{
						statusEl.fadeOut();
					}, 3000);

					error = false;
				} else {
					statusEl.css( 'color', '#a00' );
					statusEl.html( '<i class="red times icon"></i> ' + 'Undefined Error' );
				}
			} else {
				statusEl.css( 'color', '#a00' );
				statusEl.html( '<i class="red times icon"></i> ' + 'Undefined Error' );
			}
			if (error) {
				loadingEl.removeClass( 'hmbkp-running' );
			}
			statusEl.show();
		}, 'json');

	});

});


function mainwp_backupwp_refresh_backupstatus(pObj) {
	var parent = jQuery( pObj ).closest( '.mwp-hmbkp-schedule-sentence' );
	var statusEl = jQuery( pObj ).closest( '.mwp-hmbkp-schedule-sentence' ).find( '#mwp-hmbkp-schedule-working .status' );
	var schedule_id = jQuery( pObj ).closest( '.mwp-hmbkp-schedule-sentence' ).attr( 'schedule-id' );
	var data = {
		action: 'mainwp_backupwp_refresh_backup_status',
		scheduleId: schedule_id,
		_backupwpNonce: mainwp_hmbkp_loc.nonce,
		backupwpRequestSiteID: mainwp_backupwp_current_site_id,
		individual: 1
	};
	//call the ajax
	jQuery.post(ajaxurl, data, function (response) {
		statusEl.html( '' );
		error = true;
		if (response) {
			if (response.error) {
				statusEl.css( 'color', '#a00' );
				statusEl.html( response.error );
			} else if (response.result == 'NOTFOUND') {
				statusEl.css( 'color', '#a00' );
				statusEl.html( '<i class="red times icon"></i> ' + __( 'Schedule has not been found' ) );
			} else if (response.message) {
				statusEl.css( 'color', '#f7b100' );
				statusEl.html( response.message );
			} else if (response.result == 'SUCCESS') {
				if (response.scheduleStatus == '') {
					parent.removeClass( 'hmbkp-running' );
				} else {
					parent.find( '.hmbkp-status .status-text' ).html( response.scheduleStatus );
					setTimeout(function ()
						{
						mainwp_backupwp_refresh_backupstatus( pObj );
					}, 2000);
				}
				error = false;
			} else {
				statusEl.css( 'color', '#a00' );
				statusEl.html( '<i class="red times icon"></i> ' + 'Undefined Error' );
			}
		} else {
			statusEl.css( 'color', '#a00' );
			statusEl.html( '<i class="red times icon"></i> ' + 'Undefined Error' );
		}
		statusEl.show();
	}, 'json');

}

mainwp_backupwp_individual_perform_action = function (pSiteId, pSchId, pWhat) {
	if (pWhat == 'delete_schedule') {
		mainwp_backupwp_individual_delete_schedule( pSiteId, pSchId );
	} else if (pWhat == 'update_schedule') {
		mainwp_backupwp_individual_update_schedule( pSiteId, pSchId );
	} else if (pWhat == 'run_schedule') {
		mainwp_backupwp_individual_run_schedule( pSiteId, pSchId );
	}
}

mainwp_backupwp_individual_delete_schedule = function (pSiteId, pSchId) {
	var statusEl = jQuery( '#mwp_backupwp_perform_individual_status' );
	var loaderEl = jQuery( '#backupwp_site_settings i.loader' );
	loaderEl.show();
	data = {
		action: 'mainwp_backupwp_delete_schedule',
		scheduleId: pSchId,
		backupwpRequestSiteID: pSiteId,
		_backupwpNonce: mainwp_hmbkp_loc.nonce,
		individual: 1
	};
	jQuery.post(ajaxurl, data, function (response) {
		loaderEl.hide();
		if (response) {
			if (response.error) {
				statusEl.css( 'color', '#a00' );
				statusEl.html( response.error );
			} else if (response.result == 'NOTFOUND') {
				statusEl.css( 'color', '#a00' );
				statusEl.html( '<i class="red times icon"></i> ' + __( 'Schedule has not been found' ) );
			} else if (response.message) {
				statusEl.css( 'color', '#f7b100' );
				statusEl.html( response.message );
			} else if (response.result == 'SUCCESS') {
				statusEl.css( 'color', '#f7b100' );
				statusEl.html( '<i class="green check icon"></i> ' + __( 'Scheudule has been deleted successfully' ) );
			} else {
				statusEl.css( 'color', '#a00' );
				statusEl.html( '<i class="red times icon"></i> ' + 'Undefined Error' );
			}
		} else {
			statusEl.css( 'color', '#a00' );
			statusEl.html( '<i class="red times icon"></i> ' + 'Undefined Error' );
		}
		statusEl.show();
	}, 'json');
}


mainwp_backupwp_individual_update_schedule = function (pSiteId, pSchId) {
	var statusEl = jQuery( '#mwp_backupwp_perform_individual_status' );
	var loaderEl = jQuery( '#backupwp_site_settings i.loader' );
	loaderEl.show();
	data = {
		action: 'mainwp_backupwp_update_schedule',
		scheduleId: pSchId,
		backupwpRequestSiteID: pSiteId,
		_backupwpNonce: mainwp_hmbkp_loc.nonce,
		individual: 1
	};
	jQuery.post(ajaxurl, data, function (response) {
		loaderEl.hide();
		if (response) {
			if (response.error) {
				statusEl.css( 'color', '#a00' );
				statusEl.html( response.error );
			} else if (response.result == 'NOTFOUND') {
				statusEl.css( 'color', '#a00' );
				statusEl.html( '<i class="red times icon"></i> ' + __( 'Schedule has not been found' ) );
			} else if (response.result == 'NOTCHANGE') {
				statusEl.css( 'color', '#f7b100' );
				statusEl.html( __( 'Not Changed' ) );
			} else if (response.message) {
				statusEl.css( 'color', '#f7b100' );
				statusEl.html( response.message );
			} else if (response.result == 'SUCCESS') {
				statusEl.css( 'color', '#f7b100' );
				statusEl.html( '<i class="green check icon"></i> ' + __( 'Successful' ) );
			} else {
				statusEl.css( 'color', '#a00' );
				statusEl.html( '<i class="red times icon"></i> ' + 'Undefined Error' );
			}
		} else {
			statusEl.css( 'color', '#a00' );
			statusEl.html( '<i class="red times icon"></i> ' + 'Undefined Error' );
		}
		statusEl.show();
	}, 'json');
}


mainwp_backupwp_individual_run_schedule = function (pSiteId, pSchId) {
	var statusEl = jQuery( '#mwp_backupwp_perform_individual_status' );
	var loaderEl = jQuery( '#backupwp_site_settings i.loader' );
	loaderEl.show();
	data = {
		action: 'mainwp_backupwp_run_schedule',
		scheduleId: pSchId,
		backupwpRequestSiteID: pSiteId,
		_backupwpNonce: mainwp_hmbkp_loc.nonce,
		individual: 1
	};
	jQuery.post(ajaxurl, data, function (response) {
		loaderEl.hide();
		if (response) {
			if (response.error) {
				statusEl.css( 'color', '#a00' );
				statusEl.html( response.error );
			} else if (response.result == 'NOTFOUND') {
				statusEl.css( 'color', '#a00' );
				statusEl.html( '<i class="red times icon"></i> ' + __( 'Schedule has not been found' ) );
			} else if (response.message) {
				statusEl.css( 'color', '#f7b100' );
				statusEl.html( response.message );
			} else if (response.result == 'SUCCESS') {
				statusEl.css( 'color', '#f7b100' );
				statusEl.html( '<i class="green check icon"></i> ' + __( 'Successful' ) );
			} else {
				statusEl.css( 'color', '#a00' );
				statusEl.html( '<i class="red times icon"></i> ' + 'Undefined Error' );
			}
		} else {
			statusEl.css( 'color', '#a00' );
			statusEl.html( '<i class="red times icon"></i> ' + 'Undefined Error' );
		}
		statusEl.show();
	}, 'json');
}


function mainwp_backupwp_utf8_to_b64(str) {
	return window.btoa( str );
	//return window.btoa(encodeURIComponent( escape( str )));
}

function mainwp_backupwp_get_donwnloadlink(site_id, location) {
	location = location + '&_mwpNoneName=hmbkp_download_backup_nonce&_mwpNoneValue=hmbkp_download_backup';
	return 'admin.php?page=Extensions-Mainwp-Backupwordpress-Extension&action=mwpBackupWPOpenSite&websiteid=' + site_id + '&open_location=' + mainwp_backupwp_utf8_to_b64( location );
}

mainwp_backupwp_download_backup = function (encoded_file, sch_id, pObj) {
	var loc = 'admin-post.php?hmbkp_backup_archive=' + encoded_file + '&action=hmbkp_request_download_backup&hmbkp_schedule_id=' + sch_id;
	var site_id = jQuery( pObj ).closest( '.backupslist_row' ).attr( 'site-id' );
	var url = mainwp_backupwp_get_donwnloadlink( site_id, loc );
	window.open( url, '_blank' );
}

mainwp_backupwp_delete_backup = function (encoded_file, sch_id, pObj) {
	if ( ! confirm( __( "Are you sure?" ) )) {
		return false; }

	var site_id = jQuery( pObj ).closest( '.backupslist_row' ).attr( 'site-id' );
	var individual = jQuery( '#mainwp_backupwp_backupslist_content' ).attr( 'is-individual' );
	var data = {
		action: 'mainwp_backupwp_delete_file_backup',
		scheduleId: sch_id,
		_backupwpNonce: mainwp_hmbkp_loc.nonce,
		backupwpRequestSiteID: site_id,
		hmbkp_encoded_file: encoded_file,
		individual: individual
	};
	jQuery( '.mwp_backupwp_del_status' ).remove();
	jQuery( '.mwp_backupwp_del_working' ).remove();
	jQuery( pObj ).after( '&nbsp;<i style="display: none;" class="fa fa-spinner fa-pulse mwp_backupwp_del_working"></i>' );
	var loadingEl = jQuery( '.mwp_backupwp_del_working' );
	loadingEl.show();
	//call the ajax
	jQuery.post(ajaxurl, data, function (response) {
		loadingEl.remove();
		jQuery( pObj ).after( '&nbsp;<span class="mwp_backupwp_del_status"></span>' );
		var statusEl = jQuery( '.mwp_backupwp_del_status' );
		if (response) {
			if (response.error) {
				statusEl.css( 'color', '#a00' );
				statusEl.html( response.error );
			} else if (response.result == 'NOTFOUND') {
				statusEl.css( 'color', '#a00' );
				statusEl.html( '<i class="red times icon"></i> ' + __( 'The schedule has not been found on child site' ) );
			} else if (response.result == 'SUCCESS') {
				jQuery( pObj ).closest( 'tr' ).remove();
				mainwp_backupwp_individual_reload_backups( site_id )
			} else {
				statusEl.css( 'color', '#a00' );
				statusEl.html( '<i class="red times icon"></i> ' + 'Undefined Error' );
			}
		} else {
			statusEl.css( 'color', '#a00' );
			statusEl.html( '<i class="red times icon"></i> ' + 'Undefined Error' );
		}
	}, 'json');
}
