<?php

/**
 * Displays a row in the manage backups table
 *
 * @param string                 $file
 * @param MAINWP\BackUpWordPress\Scheduled_Backup $schedule
 */
// not used any more
function mainwp_hmbkp_get_backup_row( $file, MAINWP\BackUpWordPress\Scheduled_Backup $schedule ) {

	$encoded_file = urlencode( base64_encode( $file ) );
	$offset = get_option( 'gmt_offset' ) * 3600;
	?>

	<tr class="mainwp_hmbkp_manage_backups_row">

		<th scope="row">
			<?php echo esc_html( date_i18n( get_option( 'date_format' ) . ' - ' . get_option( 'time_format' ), @filemtime( $file ) + $offset ) ); ?>
		</th>

		<td class="code">
			<?php echo esc_html( size_format( @filesize( $file ) ) ); ?>
		</td>

		<td><?php echo esc_html( mainwp_hmbkp_human_get_type( $file, $schedule ) ); ?></td>

		<td>

			<?php //if ( mainwp_hmbkp_is_path_accessible( mainwp_hmbkp_path() ) ) : ?>
				<a href="<?php echo esc_url( wp_nonce_url( add_query_arg( array( 'mainwp_hmbkp_backup_archive' => $encoded_file, 'mainwp_hmbkp_schedule_id' => $schedule->get_id(), 'action' => 'mainwp_hmbkp_request_download_backup' ), admin_url( 'admin-post.php' ) ), 'mainwp_hmbkp_download_backup', 'mainwp_hmbkp_download_backup_nonce' ) ); ?>" class="download-action"><?php _e( 'Download', 'mainwp-backupwordpress-extension' ); ?></a> |
			<?php //endif; ?>

			<a href="<?php echo esc_url( wp_nonce_url( add_query_arg( array( 'mainwp_hmbkp_backup_archive' => $encoded_file, 'mainwp_hmbkp_schedule_id' => $schedule->get_id(), 'action' => 'mainwp_hmbkp_request_delete_backup' ), admin_url( 'admin-post.php' ) ), 'mainwp_hmbkp_delete_backup', 'mainwp_hmbkp_delete_backup_nonce' ) ); ?>" class="delete-action"><?php _e( 'Delete', 'mainwp-backupwordpress-extension' ); ?></a>

		</td>

	</tr>

	<?php
}

/**
 * Displays admin notices for various error / warning
 * conditions
 *
 * @return void
 */
function mainwp_hmbkp_admin_notices() {

	$current_screen = get_current_screen();

	if ( ! isset( $current_screen ) || MAINWP_HMBKP_ADMIN_PAGE !== $current_screen->id ) {
		return;
	}

	$notices = MAINWP\BackUpWordPress\Notices::get_instance()->get_notices();

	if ( empty( $notices ) ) {
		return;
	}

	ob_start();
	?>

	<?php if ( ! empty( $notices['backup_errors'] ) ) : ?>

		<div id="hmbkp-warning" class="error fade">
			<p>
				<strong><?php _e( 'BackUpWordPress detected issues with your last backup.', 'mainwp-backupwordpress-extension' ); ?></strong>
				<a href="<?php echo esc_url( wp_nonce_url( add_query_arg( array( 'action' => 'mainwp_hmbkp_dismiss_error' ), admin_url( 'admin-post.php' ) ), 'mainwp_hmbkp_dismiss_error', 'mainwp_hmbkp_dismiss_error_nonce' ) ); ?>" style="float: right;" class="button">
					<?php _e( 'Dismiss', 'mainwp-backupwordpress-extension' ); ?>
				</a>
			</p>

			<ul>
				<?php foreach ( $notices['backup_errors'] as $notice ) : ?>
					<li><pre><?php echo esc_html( $notice ); ?></pre></li>
				<?php endforeach; ?>
							</ul>

						</div>

	<?php endif; ?>

	<?php if ( ! empty( $notices['server_config'] ) ) : ?>

						<div id="hmbkp-warning" class="error fade">

							<ul>
				<?php foreach ( $notices['server_config'] as $notice ) : ?>
											<li><?php echo wp_kses_data( $notice ); ?></li>
				<?php endforeach; ?>
							</ul>

						</div>

	<?php endif; ?>

	<?php
	echo ob_get_clean();
}

/**
 * Hook in an change the plugin description when BackUpWordPress is activated
 *
 * @param array $plugins
 * @return array $plugins
 */
function mainwp_hmbkp_plugin_row( $plugins ) {
	//
	//  $menu = is_multisite() ? 'Settings' : 'Tools';
	//
	//  if ( isset( $plugins[MAINWP_HMBKP_PLUGIN_SLUG . '/backupwordpress.php'] ) ) {
	//      $plugins[MAINWP_HMBKP_PLUGIN_SLUG . '/backupwordpress.php']['Description'] = str_replace( 'Once activated you\'ll find me under <strong>' . $menu . ' &rarr; Backups</strong>', 'Find me under <strong><a href="' . esc_url( mainwp_hmbkp_get_settings_url() ) . '">' . $menu . ' &rarr; Backups</a></strong>', $plugins[MAINWP_HMBKP_PLUGIN_SLUG . '/backupwordpress.php']['Description'] );
	//  }
	//
	//  return $plugins;
}

//add_filter( 'all_plugins', 'mainwp_hmbkp_plugin_row', 10 );

/**
 * Parse the json string of errors and
 * output as a human readable message
 *
 * @access public
 * @return null
 */
function mainwp_hmbkp_backup_errors_message() {

	$message = '';

	//  foreach ( (array) json_decode( mainwp_hmbkp_backup_errors() ) as $key => $errors ) {
	//      foreach ( $errors as $error ) {
	//          $message .= '<p><strong>' . esc_html( $key ) . '</strong>: <code>' . implode( ':', array_map( 'esc_html', (array) $error ) ) . '</code></p>';
	//      }
	//  }

	return $message;
}

/**
 * Get the human readable backup type in.
 *
 * @access public
 * @param string                 $type
 * @param MAINWP\BackUpWordPress\Scheduled_Backup $schedule (default: null)
 * @return string
 */
function mainwp_hmbkp_human_get_type( $type, MAINWP\BackUpWordPress\Scheduled_Backup $schedule = null ) {

	if ( strpos( $type, 'complete' ) !== false ) {
		return __( 'Database and Files', 'mainwp-backupwordpress-extension' );
	}

	if ( strpos( $type, 'file' ) !== false ) {
		return __( 'Files', 'mainwp-backupwordpress-extension' );
	}

	if ( strpos( $type, 'database' ) !== false ) {
		return __( 'Database', 'mainwp-backupwordpress-extension' );
	}

	if ( ! is_null( $schedule ) ) {
		return mainwp_hmbkp_human_get_type( $schedule->get_type() );
	}

	return __( 'Legacy', 'mainwp-backupwordpress-extension' );
}


function mainwp_hmbkp_translated_schedule_title( $slug, $title ) {

	$titles = array(
		'complete-hourly' => esc_html__( 'Complete Hourly', 'mainwp-backupwordpress-extension' ),
		'file-hourly' => esc_html__( 'File Hourly', 'mainwp-backupwordpress-extension' ),
		'database-hourly' => esc_html__( 'Database Hourly', 'mainwp-backupwordpress-extension' ),
		'complete-twicedaily' => esc_html__( 'Complete Twicedaily', 'mainwp-backupwordpress-extension' ),
		'file-twicedaily' => esc_html__( 'File Twicedaily', 'mainwp-backupwordpress-extension' ),
		'database-twicedaily' => esc_html__( 'Database Twicedaily', 'mainwp-backupwordpress-extension' ),
		'complete-daily' => esc_html__( 'Complete Daily', 'mainwp-backupwordpress-extension' ),
		'file-daily' => esc_html__( 'File Daily', 'mainwp-backupwordpress-extension' ),
		'database-daily' => esc_html__( 'Database Daily', 'mainwp-backupwordpress-extension' ),
		'complete-weekly' => esc_html__( 'Complete Weekly', 'mainwp-backupwordpress-extension' ),
		'file-weekly' => esc_html__( 'File Weekly', 'mainwp-backupwordpress-extension' ),
		'database-weekly' => esc_html__( 'Database Weekly', 'mainwp-backupwordpress-extension' ),
		'complete-fortnightly' => esc_html__( 'Complete Biweekly', 'mainwp-backupwordpress-extension' ),
		'file-fortnightly' => esc_html__( 'File Biweekly', 'mainwp-backupwordpress-extension' ),
		'database-fortnightly' => esc_html__( 'Database Biweekly', 'mainwp-backupwordpress-extension' ),
		'complete-monthly' => esc_html__( 'Complete Monthly', 'mainwp-backupwordpress-extension' ),
		'file-monthly' => esc_html__( 'File Monthly', 'mainwp-backupwordpress-extension' ),
		'database-monthly' => esc_html__( 'Database Monthly', 'mainwp-backupwordpress-extension' ),
		'complete-manually' => esc_html__( 'Complete Manually', 'mainwp-backupwordpress-extension' ),
		'file-manually' => esc_html__( 'File Manually', 'mainwp-backupwordpress-extension' ),
		'database-manually' => esc_html__( 'Database Manually', 'mainwp-backupwordpress-extension' ),
	);

	if ( isset( $titles[ $slug ] ) ) {
		return $titles[ $slug ];
	}

	return $title;
}

function mainwp_hmbkp_get_settings_url() {

	$url = MAINWP_HMBKP_EXTENSION_URL;

	MAINWP\BackUpWordPress\schedules::get_instance()->refresh_schedules();

	if ( ! empty( $_REQUEST['mainwp_hmbkp_schedule_id'] ) && MAINWP\BackUpWordPress\schedules::get_instance()->get_schedule( sanitize_text_field( $_REQUEST['mainwp_hmbkp_schedule_id'] ) ) ) {
		$url = add_query_arg( 'mainwp_hmbkp_schedule_id', sanitize_text_field( $_REQUEST['mainwp_hmbkp_schedule_id'] ), $url );
	}

	return $url;
}

function mainwp_hmbkp_get_delete_schedule_url() {

	$url = MAINWP_HMBKP_EXTENSION_URL;

	MAINWP\BackUpWordPress\schedules::get_instance()->refresh_schedules();

	if ( ! empty( $_REQUEST['mainwp_hmbkp_schedule_id'] ) ) {
		$query_arg = array(
			'mainwp_hmbkp_schedule_id' => sanitize_text_field( $_REQUEST['mainwp_hmbkp_schedule_id'] ),
			'_perform_action' => 'delete_schedule',
			'mainwp_hmbkp_delete_schedule' => wp_create_nonce( 'mainwp_hmbkp_delete_schedule_nonce' ),
		);
		$url = add_query_arg( $query_arg, $url );
	}

	return $url;
}

function mainwp_hmbkp_get_update_schedule_url() {

	$url = MAINWP_HMBKP_EXTENSION_URL;

	if ( ! empty( $_REQUEST['mainwp_hmbkp_schedule_id'] ) ) {
		$query_arg = array(
			'mainwp_hmbkp_schedule_id' => sanitize_text_field( $_REQUEST['mainwp_hmbkp_schedule_id'] ),
			'_perform_action' => 'update_schedule',
			'mainwp_hmbkp_update_schedule' => wp_create_nonce( 'mainwp_hmbkp_update_schedule_nonce' ),
			'action' => 'mainwp_hmbkp_edit_schedule',
			'mainwp_hmbkp_panel' => 'mainwp_hmbkp_edit_schedule_settings',
		);

		$url = add_query_arg( $query_arg, $url );
	}
	return $url;
}

function mainwp_hmbkp_get_update_schedule_excluded_url() {

	$url = MAINWP_HMBKP_EXTENSION_URL;

	if ( ! empty( $_REQUEST['mainwp_hmbkp_schedule_id'] ) ) {
		$query_arg = array(
			'mainwp_hmbkp_schedule_id' => sanitize_text_field( $_REQUEST['mainwp_hmbkp_schedule_id'] ),
			'_perform_action' => 'general_exclude_rules',
			'mainwp_hmbkp_update_schedule' => wp_create_nonce( 'mainwp_hmbkp_update_schedule_nonce' ),
			'action' => 'mainwp_hmbkp_edit_schedule',
			'mainwp_hmbkp_panel' => 'mainwp_hmbkp_edit_schedule_excludes',
		);

		$url = add_query_arg( $query_arg, $url );
	}
	return $url;
}

/**
 * Add an error message to the array of messages.
 *
 * @param $error_message
 */
function mainwp_hmbkp_add_settings_error( $error_message ) {

	$mainwp_hmbkp_settings_errors = get_transient( 'mainwp_hmbkp_settings_errors' );

	// If it doesnt exist, create.
	if ( ! $mainwp_hmbkp_settings_errors ) {
		set_transient( 'mainwp_hmbkp_settings_errors', (array) $error_message );
	} else {
		set_transient( 'mainwp_hmbkp_settings_errors', array_unique( array_merge( $mainwp_hmbkp_settings_errors, (array) $error_message ) ) );
	}
}

/**
 * Fetch the form submission errors for display.
 *
 * @return mixed
 */
function mainwp_hmbkp_get_settings_errors() {
	return get_transient( 'mainwp_hmbkp_settings_errors' );
}

/**
 * Clear all error messages.
 *
 * @return bool
 */
function mainwp_hmbkp_clear_settings_errors() {
	return delete_transient( 'mainwp_hmbkp_settings_errors' );
}
