<?php

class MainWP_BackUp_WordPress {

	public static $instance = null;

	public static function get_instance() {
		if ( null == self::$instance ) {
			self::$instance = new self(); }
		return self::$instance;
	}

	public function __construct() {

	}

	public function init() {

	}

	public function admin_init() {
		add_action( 'wp_ajax_mainwp_backupwp_delete_schedule', array( $this, 'ajax_delete_schedule' ) );
		add_action( 'wp_ajax_mainwp_backupwp_cancel_schedule', array( $this, 'ajax_cancel_schedule' ) );
		add_action( 'wp_ajax_mainwp_backupwp_run_schedule', array( $this, 'ajax_run_schedule' ) );
		add_action( 'wp_ajax_mainwp_backupwp_refresh_backup_status', array( $this, 'ajax_refresh_backup_status' ) );
		add_action( 'wp_ajax_mainwp_backupwp_update_schedule', array( $this, 'ajax_update_schedule' ) );
		add_action( 'wp_ajax_mainwp_backupwp_reload_backups', array( $this, 'ajax_reload_backups' ) );
		add_action( 'wp_ajax_mainwp_backupwp_delete_file_backup', array( $this, 'ajax_delete_backups' ) );
		add_action( 'wp_ajax_mainwp_backupwp_reload_excluded', array( $this, 'ajax_reload_excluded' ) );
		add_action( 'wp_ajax_mainwp_backupwp_exclude_directory_browse', array( $this, 'ajax_directory_browse' ) );
		add_action( 'wp_ajax_mainwp_backupwp_exclude_directory_add_rule', array( $this, 'ajax_exclude_add_rule' ) );
		add_action( 'wp_ajax_mainwp_backupwp_exclude_remove_exclude_rule', array( $this, 'ajax_remove_exclude_rule' ) );
		add_action( 'wp_ajax_mainwp_backupwp_site_override_settings', array( $this, 'ajax_override_settings' ) );
		add_action( 'mainwp_delete_site', array( &$this, 'delete_site_data' ), 10, 1 );
        add_action( 'wp_ajax_mainwp_backupwp_general_exclude_rules', array( $this, 'ajax_general_exclude_rules' ) );
	}

	public function delete_site_data( $website ) {
		if ( $website ) {
			MainWP_BackUp_WordPress_DB::get_instance()->delete_backupwp( 'site_id', $website->id );
		}
	}

	public static function render() {

		$website = null;
		if ( isset( $_GET['id'] ) && ! empty( $_GET['id'] ) ) {
			global $mainWPBackUpWordPressExtensionActivator;
			$option = array(
			'plugin_upgrades' => true,
				'plugins' => true,
			);
			$dbwebsites = apply_filters( 'mainwp-getdbsites', $mainWPBackUpWordPressExtensionActivator->get_child_file(), $mainWPBackUpWordPressExtensionActivator->get_child_key(), array( $_GET['id'] ), array(), $option );

			if ( is_array( $dbwebsites ) && ! empty( $dbwebsites ) ) {
				$website = current( $dbwebsites );
			}
		}

		if ( self::is_managesites_page() ) {
			$error = '';
			if ( empty( $website ) || empty( $website->id ) ) {
				$error = __( 'Error: Site not found.', 'mainwp-backupwordpress-extension' );
			} else {
				$activated = false;
				if ( $website && $website->plugins != '' ) {
					$plugins = json_decode( $website->plugins, 1 );
					if ( is_array( $plugins ) && count( $plugins ) > 0 ) {
						foreach ( $plugins as $plugin ) {
							if ( ('backupwordpress/backupwordpress.php' == $plugin['slug']) ) {
								if ( $plugin['active'] ) {
									$activated = true; }
								break;
							}
						}
					}
				}
				if ( ! $activated ) {
					$error = __( 'BackUpWordPress plugin is not installed or activated on the site.', 'mainwp-backupwordpress-extension' );
				}
			}

			if ( ! empty( $error ) ) {
				do_action( 'mainwp-pageheader-sites', 'BackUpWordPress' );
				echo '<div class="mainwp_info-box-red">' . $error . '</div>';
				do_action( 'mainwp-pagefooter-sites', 'BackUpWordPress' );
				return;
			}
		}
		self::render_tabs( $website );
	}

	public static function render_tabs( $pWebsite = null ) {
		if ( isset( $_GET['action'] ) && 'mwpBackupWPOpenSite' == $_GET['action'] ) {
			self::open_site();
			return;
		}
		global $mainWPBackUpWordPressExtensionActivator;
		$dbwebsites_backupwp = array();
		$sitesName = array();

		if ( ! self::is_managesites_page() ) {
			$websites = apply_filters( 'mainwp-getsites', $mainWPBackUpWordPressExtensionActivator->get_child_file(), $mainWPBackUpWordPressExtensionActivator->get_child_key(), null );
			$sites_ids = array();
			if ( is_array( $websites ) ) {
				foreach ( $websites as $site ) {
					$sites_ids[] = $site['id'];
				}
				unset( $websites );
			}
			$option = array(
			'plugin_upgrades' => true,
				'plugins' => true,
			);

			$dbwebsites = apply_filters( 'mainwp-getdbsites', $mainWPBackUpWordPressExtensionActivator->get_child_file(), $mainWPBackUpWordPressExtensionActivator->get_child_key(), $sites_ids, array(), $option );
			//print_r($dbwebsites);
			$selected_group = 0;

			if ( isset( $_POST['mainwp_backupwp_plugin_groups_select'] ) ) {
				$selected_group = intval( $_POST['mainwp_backupwp_plugin_groups_select'] );
			}

			$pluginDataSites = array();
			if ( count( $sites_ids ) > 0 ) {
				$pluginDataSites = MainWP_BackUp_WordPress_DB::get_instance()->get_backupwps_data( $sites_ids );
			}

			$dbwebsites_backupwp = MainWP_BackUp_WordPress_Plugin::get_instance()->get_websites_with_the_plugin( $dbwebsites, $selected_group, $pluginDataSites );

			foreach ( $dbwebsites_backupwp as $site ) {
				$sitesName[ $site['id'] ] = $site['name'];
			}

			unset( $dbwebsites );
			unset( $pluginDataSites );
		}

		$style_tab_dashboard = $style_tab_schedules = $style_tab_add_schedule = $style_tab_edit_schedule = $style_tab_backup = ' style="display: none" ';

		$perform_action = '';

		if ( isset( $_GET['_perform_action'] ) && ! empty( $_GET['_perform_action'] ) ) {
			$perform_action = esc_html( $_GET['_perform_action'] );
			$security_error = false;
			if ( 'update_schedule' == $perform_action || 'general_exclude_rules' == $perform_action) {
				if ( ! isset( $_GET['mainwp_hmbkp_update_schedule'] ) || ! wp_verify_nonce( $_GET['mainwp_hmbkp_update_schedule'], 'mainwp_hmbkp_update_schedule_nonce' ) ) {
					$security_error = true;
				}
			} else if ( 'delete_schedule' == $perform_action ) {
				if ( ! isset( $_GET['mainwp_hmbkp_delete_schedule'] ) || ! wp_verify_nonce( $_GET['mainwp_hmbkp_delete_schedule'], 'mainwp_hmbkp_delete_schedule_nonce' ) ) {
					$security_error = true;
				}
			} else if ( 'reload_backups' == $perform_action ) {
				if ( ! isset( $_GET['mainwp_hmbkp_reload_backups'] ) || ! wp_verify_nonce( $_GET['mainwp_hmbkp_reload_backups'], 'mainwp_hmbkp_reload_backups_nonce' ) ) {
					$security_error = true;
				}
			} else if ( 'run_schedule' == $perform_action ) {
				if ( ! isset( $_GET['mainwp_hmbkp_run_global_schedule'] ) || ! wp_verify_nonce( $_GET['mainwp_hmbkp_run_global_schedule'], 'mainwp_hmbkp_run_global_schedule_nonce' ) ) {
					$security_error = true;
				}
			} else if ( 'cancel_schedule' == $perform_action ) {
				if ( ! isset( $_GET['mainwp_hmbkp_cancel_global_schedule'] ) || ! wp_verify_nonce( $_GET['mainwp_hmbkp_cancel_global_schedule'], 'mainwp_hmbkp_cancel_global_schedule_nonce' ) ) {
					$security_error = true;
				}
			}

			if ( $security_error ) {
				_e( 'Security Error', 'mainwp-backupwordpress-extension' );
				return;
			}

			$style_tab_schedules = '';
		}

		if ( self::is_managesites_page() ) {
			do_action( 'mainwp-pageheader-sites', 'BackUpWordPress' );
			$is_individual = true;
		} else {
			$is_individual = false;
		}

		if ( empty( $perform_action ) ) {
			if ( isset( $_GET['tab'] ) ) {
				if ( 'schedules' == $_GET['tab'] ) {
					$style_tab_schedules = '';
				} else if ( 'backups' == $_GET['tab'] ) {
					$style_tab_backup = '';
				}
			} else if ( isset( $_GET['mainwp_hmbkp_add_schedule'] ) && 1 == $_GET['mainwp_hmbkp_add_schedule'] ) {
				$style_tab_add_schedule = '';
			} else if ( isset( $_GET['mainwp_hmbkp_schedule_id'] ) && ! empty( $_GET['mainwp_hmbkp_schedule_id'] ) ) {
				$style_tab_edit_schedule = '';
			} else {
				if ( $is_individual ) {
					$style_tab_schedules = '';
				} else {
					$style_tab_dashboard = '';
				}
			}
		}

		// Refresh the schedules from the database to make sure we have the latest changes
		MAINWP\BackUpWordPress\Schedules::get_instance()->refresh_schedules();
		$schedules = MAINWP\BackUpWordPress\Schedules::get_instance()->get_schedules();

		if ( ! is_array( $schedules ) ) {
			$schedules = array(); }

		if ( isset( $_GET['mainwp_hmbkp_schedule_id'] ) & ! empty( $_GET['mainwp_hmbkp_schedule_id'] ) ) {
			$current_schedule = new MAINWP\BackUpWordPress\Scheduled_Backup( sanitize_text_field( $_GET['mainwp_hmbkp_schedule_id'] ) );
			$schedule_id = intval($_GET['mainwp_hmbkp_schedule_id']);
		} else {
			$current_schedule = null;
			$schedule_id = 0;
		}

		$current_site_id = ! empty( $pWebsite ) ? $pWebsite->id : 0;

		$backups_list_data = array();
		$backupsPath = '';
		$is_override = false;
		if ( $is_individual ) {
			$backupwp = MainWP_BackUp_WordPress_DB::get_instance()->get_backupwp_by( 'site_id', $current_site_id, 'backups_path,override' );
			if ( $backupwp ) {
				$backupsPath = $backupwp->backups_path;
				$is_override = $backupwp->override;
			}
			$backups_list_data = MainWP_BackUp_WordPress::get_instance()->get_individual_backup( $current_site_id );
		} else {
			$backups_list_data = MainWP_BackUp_WordPress::get_instance()->get_backups_data();
		}

		if ( $is_individual ) {
			$dashboard_link = '';
		} else {
			$dashboard_link = '<a id="mwp_backupwp_dashboard_tab_lnk" href="#" class="item ' . (empty( $style_tab_dashboard ) ? 'active selected' : '') . '">' . __( 'BackUpWordPress Dashboard', 'mainwp-backupwordpress-extension' ) . '</a>';
		}

		$edit_scheduled_link = '';
		$edit_count_backups = 0;
		if ( isset( $_GET['mainwp_hmbkp_schedule_id'] ) && ! empty( $_GET['mainwp_hmbkp_schedule_id'] ) && ! isset( $_GET['mainwp_hmbkp_add_schedule'] ) ) {
			if ( 'delete_schedule' !== $perform_action ) {
				$style_tab_edit_schedule = '';
				$arg_edit = array(
					'mainwp_hmbkp_schedule_id' => $current_schedule->get_id(),
					'action' => 'mainwp_hmbkp_edit_schedule',
					'mainwp_hmbkp_panel' => 'mainwp_hmbkp_edit_schedule_settings',
					'_referer_slug' => $is_individual ? 'ManageSitesBackUpWordPress' : 'Extensions-Mainwp-Backupwordpress-Extension',
				);
				$style_tab_schedules = ' style="display: none" '; // fix bug

				if ( is_array( $backups_list_data ) ) {
					if ( $is_individual ) {
						$_backupwp = $backups_list_data[ $schedule_id ];
						$edit_count_backups = $_backupwp['backups_count'];
					} else {
						$_count = 0;
						foreach ( $backups_list_data as $_site_id => $_schedules ) {
							if ( isset( $_schedules[ $schedule_id ] ) ) {
								$_count += $_schedules[ $schedule_id ]['backups_count'];
							}
						}
						$edit_count_backups = $_count;
					}
				}
				$edit_scheduled_link = '<a class="schedule_tab_link item active selected ' . ( ( $current_schedule->get_status() ) ? 'hmbkp-running' : '') . '" ' . ( $current_schedule->get_status() ? ' title="' . esc_attr( strip_tags( $current_schedule->get_status() ) ) . '" ' : '' ) . ' href="' . esc_url( add_query_arg( $arg_edit, MAINWP_HMBKP_EXTENSION_URL ) ) . '"> ' . esc_html( mainwp_hmbkp_translated_schedule_title( $current_schedule->get_slug(), $current_schedule->get_name() ) ) . ' <span class="count">(' . intval( $edit_count_backups ) . ')</span></a>';
			}
		}

		$primary_backup = get_option( 'mainwp_primaryBackup', null );
		?>
        <script type="text/javascript">
			var mainwp_backupwp_current_site_id = <?php echo $current_site_id; ?>;
			var mainwp_backupwp_schedule_id = '<?php echo $schedule_id; ?>';
        </script>

				<div class="ui labeled icon inverted menu mainwp-sub-submenu"><?php
					echo $dashboard_link;
					?><a class="item <?php if ( empty( $style_tab_schedules ) ) { ?> active selected<?php } ?>" href="<?php echo esc_url( add_query_arg( array( 'tab' => 'schedules' ), MAINWP_HMBKP_EXTENSION_URL ) ); ?>"><?php _e( 'Schedules', 'mainwp-backupwordpress-extension' ); ?></a><?php
					echo $edit_scheduled_link;
					?><a class="item <?php if ( empty( $style_tab_add_schedule ) ) { ?> active selected<?php } ?>" href="<?php echo esc_url( add_query_arg( array( 'mainwp_hmbkp_add_schedule' => '1', 'action' => 'mainwp_hmbkp_edit_schedule', 'mainwp_hmbkp_schedule_id' => time(), 'mainwp_hmbkp_panel' => 'mainwp_hmbkp_edit_schedule_settings' ), MAINWP_HMBKP_EXTENSION_URL ) ); ?>"><?php _e( 'Add Schedule', 'mainwp-backupwordpress-extension' ); ?></a><?php
					?><a class="item <?php if ( empty( $style_tab_backup ) ) { ?> active selected<?php } ?>" href="<?php echo esc_url( add_query_arg( array( 'tab' => 'backups' ), MAINWP_HMBKP_EXTENSION_URL ) ); ?>"><?php _e( 'Existing Backups', 'mainwp-backupwordpress-extension' ); ?></a><?php
					?>
				</div>


        <div id="mainwp_backupwp_settings">
          <div id="mwp_backupwp_backup_started" class="ui green message" style="display:none;"></div>
          <div id="mwp_backupwp_backup_error" class="ui red message" style="display:none;"></div>
          <div id="mwp_backupwp_info" class="ui info message" style="display:none;"></div>


					<?php if ( ! $is_individual ) { ?>
						<div id="mwp_backupwp_dashboard_tab" <?php echo $style_tab_dashboard; ?>>
							<?php MainWP_BackUp_WordPress_Plugin::gen_actions_row(); ?>
							<?php MainWP_BackUp_WordPress_Plugin::gen_plugin_dashboard_tab( $dbwebsites_backupwp ); ?>
            </div>
					<?php } ?>

          <div id="mainwp_backupwp_screens_tab">
						<?php
							if ( ! $is_individual && ('delete_schedule' == $perform_action || 'reload_backups' == $perform_action || 'run_schedule' == $perform_action || 'general_exclude_rules' == $perform_action || 'update_schedule' == $perform_action || 'cancel_schedule' == $perform_action) ) {
								MainWP_BackUp_WordPress::ajax_general_load_sites( $perform_action, $schedule_id );
							} else {
								if ( $is_individual ) {
									self::site_settings_box();
								}

								if ( isset($_GET['action']) && isset($_GET['mainwp_hmbkp_panel']) && 'mainwp_hmbkp_edit_schedule' === $_GET['action'] && 'mainwp_hmbkp_edit_schedule_excludes' === $_GET['mainwp_hmbkp_panel'] ) {
									if ( $is_individual ) {
										?>
                    <div class="mainwp-actions-bar">
										   <a href="#" onclick="mainwp_backupwp_individual_reload_excluded(<?php echo $current_site_id; ?>,<?php echo $schedule_id; ?>); return false;" class="ui mini green button right floated"><?php _e( 'Reload Excluded Data', 'mainwp-backupwordpress-extension' ); ?></a>
                       <div id="mainwp_backupwp_status_load_excluded" style="display: inline-block; float:right; margin-right: 10px; margin-top: 5px"><i class="notched circle loading icon" style="display: none;"></i> <span class="status hidden"></span></div>
											 <div class="ui fitted hidden clearing divider"></div>
										</div>
										<?php
									}
								}
								?>
								<div data-hmbkp-schedule-id="<?php echo esc_attr( $schedule_id ); ?>" class="mainwp_hmbkp_schedule">
									<?php
									if ( empty( $style_tab_backup ) ) {
										?>
                    <div class="mainwp-actions-bar">
											<?php if ( $current_site_id ) {
												?>
											   <a href="#" onclick="mainwp_backupwp_individual_reload_backups(<?php echo $current_site_id; ?>); return false;" class="ui mini green button right floated"><?php _e( 'Reload Data', 'mainwp-backupwordpress-extension' ); ?></a>
                         <div id="mainwp_backupwp_status_load_backups" style="display: inline-block; float:right; margin-right: 10px; margin-top: 5px"><i class="notched circle loading icon" style="display: none;"></i> <span class="status hidden"></span></div>
												<?php
											} else {
											$arg_reload_global = array(
												'_perform_action' => 'reload_backups',
												'mainwp_hmbkp_reload_backups' => wp_create_nonce( 'mainwp_hmbkp_reload_backups_nonce' ),
											);
											?>
											<a href="<?php echo esc_url( add_query_arg( $arg_reload_global, MAINWP_HMBKP_EXTENSION_URL ), 'hmbkp-edit-schedule' ); ?>" class="ui mini green button right floated"><?php _e( 'Reload Data', 'mainwp-backupwordpress-extension' ); ?></a>
												<?php } ?>
												<div class="ui fitted hidden clearing divider"></div>
                		</div>



										<?php
										MainWP_BackUp_WordPress::gen_backupslist_html( $schedules, $backups_list_data, $current_site_id, $sitesName, $is_individual, $is_override );
									} else if ( empty( $style_tab_schedules ) ) {
										MainWP_BackUp_WordPress::gen_schedules_table( $schedules, $backups_list_data, $backupsPath, $current_site_id, $is_individual, $is_override );
									} else if ( empty( $style_tab_add_schedule ) || empty( $style_tab_edit_schedule ) ) {
										MainWP_BackUp_WordPress::gen_add_edit_schedule( $current_schedule, $backupsPath, $current_site_id, $is_individual );
									}
									?>
                </div>
								<?php } ?>
              </div>
						</div>


		<?php
		if ( $is_individual ) {
			if ( ! empty( $perform_action ) ) {
			?>
			<script type="text/javascript">
				  mainwp_backupwp_individual_perform_action(<?php echo $current_site_id; ?>, <?php echo $schedule_id; ?>, '<?php echo $perform_action; ?>');
			</script>
			<?php
			}
			do_action( 'mainwp-pagefooter-sites', 'BackUpWordPress' );
		}
	}

	public static function gen_backupslist_html( $schedules, $pBackupList, $siteId, $pSitesName = '', $is_individual = false, $isOverride = false ) {
		ob_start();
		?>
        <div class="backupslist_row">
            <table class="ui table">
                <thead>
                    <tr>
						<th><?php _e( 'No backups completed', 'mainwp-backupwordpress-extension' ); ?></th>
						<th><?php _e( 'Size', 'mainwp-backupwordpress-extension' ); ?></th>
						<th><?php _e( 'Type', 'mainwp-backupwordpress-extension' ); ?></th>
						<th><?php _e( 'Actions', 'mainwp-backupwordpress-extension' ); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
						<td class="hmbkp-no-backups" colspan="4"><?php _e( 'This is where your backups will appear once you have some.', 'mainwp-backupwordpress-extension' ); ?></td>
                    </tr>
                </tbody>
            </table>
        </div>

		<?php $empty_backupslist = ob_get_clean(); ?>

		<?php
		$arg_edit = array(
			'action' => 'mainwp_hmbkp_edit_schedule',
			'mainwp_hmbkp_panel' => 'mainwp_hmbkp_edit_schedule_settings',
			'_referer_slug' => $siteId ? 'ManageSitesBackUpWordPress' : 'Extensions-Mainwp-Backupwordpress-Extension',
		);

		$reload = false;
		$sites_backups_html = '';

		if ( $siteId ) {
			foreach ( $schedules as $schedule ) {
				$sch_id = $schedule->get_id();
				$arg_edit['mainwp_hmbkp_schedule_id'] = $sch_id;
				$edit_link = '<p>' . __( 'Schedule:', 'mainwp-backupwordpress-extension' ) . ' <a' . ( $schedule->get_status() ? ' title="' . esc_attr( strip_tags( $schedule->get_status() ) ) . '" ' : '' ) . ' href="' . esc_url( add_query_arg( $arg_edit, MAINWP_HMBKP_EXTENSION_URL ) ) . '"> ' . esc_html( mainwp_hmbkp_translated_schedule_title( $schedule->get_slug(), $schedule->get_name() ) ) . ' <span class="count">(' . (isset( $pBackupList[ $sch_id ]['backups_count'] ) ? intval( $pBackupList[ $sch_id ]['backups_count'] ) : 0) . ')</span></a></p>';
				$_backup_list_html = '';

				if ( isset( $pBackupList[ $sch_id ] ) && ! empty( $pBackupList[ $sch_id ]['backups_html'] ) ) {
					$_backup_list_html = '<div class="backupslist_row" schedule-id="' . $sch_id . '" site-id="' . $siteId . '">' . $pBackupList[ $sch_id ]['backups_html'] . '</div>';

					if ( ! $reload ) {
						$reload = ((time() - $pBackupList[ $sch_id ]['lasttime_reload_backups']) > 5 * 60) ? true : false; }
				}

				$sites_backups_html .= $edit_link;
				if ( empty( $_backup_list_html ) ) {
					$sites_backups_html .= $empty_backupslist;
				} else {
					$sites_backups_html .= $_backup_list_html;
				}
				$sites_backups_html .= '<br/>';
			}
		} else {
			$general_schedule_ids = array();
			foreach ( $schedules as $schedule ) {
				$general_schedule_ids[] = $schedule->get_id();
			}
			$sites_backups_html = array();
			foreach ( $pBackupList as $site_id => $_schedules ) {
				$_backup_list_html = '';
				foreach ( $_schedules as $sch_id => $_backup ) {
					if ( empty( $sch_id ) ) {
						continue; }
					$arg_edit['mainwp_hmbkp_schedule_id'] = $sch_id;
					if ( in_array( $sch_id, $general_schedule_ids ) ) {
						$arg_edit['page'] = $arg_edit['_referer_slug'] = 'Extensions-Mainwp-Backupwordpress-Extension';
						unset( $arg_edit['id'] );
						$schedule = new MAINWP\BackUpWordPress\Scheduled_Backup( (string) $sch_id, 0, false );
					} else {
						$arg_edit['page'] = $arg_edit['_referer_slug'] = 'ManageSitesBackUpWordPress';
						$arg_edit['id'] = $site_id;
						$schedule = new MAINWP\BackUpWordPress\Scheduled_Backup( (string) $sch_id, $site_id, true );
					}

					$edit_link = '<p>' . __( 'Schedule:', 'mainwp-backupwordpress-extension' ) . ' <a' . ( $schedule->get_status() ? ' title="' . esc_attr( strip_tags( $schedule->get_status() ) ) . '" ' : '' ) . ' href="' . esc_url( add_query_arg( $arg_edit, MAINWP_HMBKP_EXTENSION_URL ) ) . '"> ' . esc_html( mainwp_hmbkp_translated_schedule_title( $schedule->get_slug(), $schedule->get_name() ) ) . ' <span class="count">(' . (isset( $pBackupList[ $site_id ][ $sch_id ]['backups_count'] ) ? intval( $pBackupList[ $site_id ][ $sch_id ]['backups_count'] ) : 0) . ')</span></a></p>';

					$_backup_list_html .= $edit_link;

					$bkl_html = $_backup['backups_html'];
					if ( empty( $bkl_html ) ) {
						$_backup_list_html .= $empty_backupslist;
					} else {
						$_backup_list_html .= '<div class="backupslist_row" schedule-id="' . $sch_id . '" site-id="' . $site_id . '">' . $bkl_html . '</div>';
					}
				}
				$sites_backups_html[ $site_id ] .= $_backup_list_html;
			}
		}
		?>
		<div id="mainwp_backupwp_backupslist_content" class="ui segment " is-individual="<?php echo ($is_individual ? 1 : 0); ?>">
      <div>
				<?php
				if ( empty( $sites_backups_html ) ) {
					echo __( 'No backups completed', 'mainwp-backupwordpress-extension' );
				} else {
					if ( $siteId ) {
						echo '<div class="mainwp_backupwp_backupslist_row" site-id="' . $siteId . '">';
						echo $sites_backups_html;
						echo '</div>';
					} else {
						foreach ( $sites_backups_html as $site_id => $backups_html ) {
							echo '<div class="ui segment mainwp_backupwp_backupslist_row" site-id="' . $site_id . '">';
							echo '<h3 class="ui dividing header">' . (isset( $pSitesName[ $site_id ] ) ? $pSitesName[ $site_id ] : 'INVALID') . ' Backups </h3>';
							echo $backups_html;
							echo '</div>';
						}
					}
				}
				?>
        </div>
      </div>

		<?php if ( $isOverride && $siteId && $reload ) { ?>
            <script type="text/javascript">
                jQuery(document).ready(function ($) {
					mainwp_backupwp_individual_reload_backups(<?php echo $siteId; ?>);
                })
            </script>
			<?php
}
	}

	public static function gen_schedules_table( $schedules, $pBackupList, $backupsPath, $current_site_id, $is_individual, $is_override = false ) {
		$server = '';
		if ( ! empty( $backupsPath ) ) {
			$server = '<code>' . esc_attr( $backupsPath ) . '</code>';
		}
		$general_sch_ids = array();
		if ( $is_individual && ! $is_override ) {
			$general_sch_ids = self::get_general_schedules_ids();
		}
		?>
        <div id="mainwp_backupwp_content">
			<?php if ( ! empty( $server ) ) { ?>
                <div class="mainwp-backupw-backup-in">
					<?php echo __( 'Find your backups in:', 'mainwp-backupwordpress-extension' ) . ' ' . $server; ?>
                </div>
			<?php } ?>

            <div class="mainwp-actions-bar">
				<?php if ( $current_site_id ) {
					?>
				   <a href="#" onclick="mainwp_backupwp_individual_reload_backups(<?php echo $current_site_id; ?>); return false;" class="ui mini green right floated button"><?php _e( 'Reload Data', 'mainwp-backupwordpress-extension' ); ?></a>
			<div id="mainwp_backupwp_status_load_backups" style="display: inline-block; float:right; margin-right: 10px; margin-top: 5px"><i class="notched circle loading icon" style="display: none;"></i> <span class="status hidden"></span></div>
					<?php
					} else {
						$arg_reload_global = array(
							'_perform_action' => 'reload_backups',
							'mainwp_hmbkp_reload_backups' => wp_create_nonce( 'mainwp_hmbkp_reload_backups_nonce' ),
						);
						?>
						<a href="<?php echo esc_url( add_query_arg( $arg_reload_global, MAINWP_HMBKP_EXTENSION_URL ), 'hmbkp-edit-schedule' ); ?>" class="ui mini green right floated button"><?php _e( 'Reload Data', 'mainwp-backupwordpress-extension' ); ?></a>
					<?php } ?>
					<div class="ui fitted hidden clearing divider"></div>
            </div>
						<div class="ui segment">
            <table class="ui table" id="mainwp_backupwp_table" >
              <thead>
                <tr>
                  <th id="schedule"><?php _e( 'Schedule' ); ?></th>
                  <th id="backup"><?php _e( 'Backup' ); ?></th>
                  <th id="number"><?php _e( 'Number of backups' ); ?></th>
                </tr>
              </thead>
                <tfoot>
					<tr>
						<th id="schedule"><?php _e( 'Schedule' ); ?></th>
						<th id="backup"><?php _e( 'Backup' ); ?></th>
						<th id="number"><?php _e( 'Number of backups' ); ?></th>
					</tr>
                </tfoot>
                <tbody id="the-mainwpbackupwp-list">
					<?php

	                    foreach ( $schedules as $schedule ) {
		                    $sch_id = $schedule->get_id();

		                    if ( $is_individual && ! $is_override ) {
			                    if ( in_array( $sch_id, $general_sch_ids ) ) {
				                    continue;
			                    }
		                    }

		                    if ( $is_individual ) {
			                    $countBackup  = isset( $pBackupList[ $sch_id ]['backups_count'] ) ? intval( $pBackupList[ $sch_id ]['backups_count'] ) : 0;
			                    $fileSizeText = isset( $pBackupList[ $sch_id ]['file_size_text'] ) ? $pBackupList[ $sch_id ]['file_size_text'] : '';
			                    $startedAgo   = isset( $pBackupList[ $sch_id ]['started_ago'] ) ? $pBackupList[ $sch_id ]['started_ago'] : '0';
		                    } else {
			                    $fileSizeText = '';
			                    $startedAgo   = '';
			                    $countBackup  = 0;
			                    foreach ( $pBackupList as $_site_id => $_schedules ) {
				                    if ( is_array( $_schedules ) && isset( $_schedules[ $sch_id ] ) ) {
					                    $countBackup += $_schedules[ $sch_id ]['backups_count'];
				                    }
			                    }
		                    }
		                    self::gen_schedules_table_row( $schedule, $countBackup, $startedAgo, $fileSizeText, $current_site_id, $is_individual );
	                    }

					?>
                </tbody>
            </table>
						<script type="text/javascript">
						jQuery( '#mainwp_backupwp_table' ).DataTable( {
							"columnDefs": [ { "orderable": false, "targets": "no-sort" } ],
							"order": [ [ 0, "asc" ] ],
							"language": { "emptyTable": "No schedules were found." }
						} );
						</script>
            </div>
        </div>
		<?php
	}

	public static function gen_metabox_schedule_settings() {
		if ( isset( $_GET['mainwp_hmbkp_schedule_id'] ) && ! empty( $_GET['mainwp_hmbkp_schedule_id'] ) ) {
			$schedule_id = intval($_GET['mainwp_hmbkp_schedule_id']);
			$schedule = new MAINWP\BackUpWordPress\Scheduled_Backup( sanitize_text_field( $schedule_id ) );
		} else {
			return; }
		$current_site_id = (isset( $_GET['id'] ) && ! empty( $_GET['id'] )) ? intval($_GET['id']) : 0;
		require( MAINWP_HMBKP_PLUGIN_PATH . 'admin/schedule-settings.php' );
	}

	public static function gen_metabox_schedule_excluded() {
		if ( isset( $_GET['mainwp_hmbkp_schedule_id'] ) && ! empty( $_GET['mainwp_hmbkp_schedule_id'] ) ) {
			$schedule_id = intval( $_GET['mainwp_hmbkp_schedule_id'] );
			$schedule = new MAINWP\BackUpWordPress\Scheduled_Backup( sanitize_text_field( $schedule_id ) );
		} else {
			return;
    }

		$current_site_id = (isset( $_GET['id'] ) && ! empty( $_GET['id'] )) ? intval( $_GET['id'] ) : 0;

        if (empty($current_site_id)) {
            // general excluded
            if (isset($_GET['page']) && $_GET['page'] == 'Extensions-Mainwp-Backupwordpress-Extension') {
                $schedule = \MainWP_BackUp_WordPress::get_instance()->get_backupwp_schedule( $schedule_id, false, false );
                $schedule_options = array();
                if ( ! empty( $schedule ) && is_array( $schedule ) && isset($schedule['options'])) {
                    $schedule_options = is_array($schedule['options']) ? $schedule['options'] : array();
                }

                $exclude_paths = isset($schedule_options['exclude_paths']) ? $schedule_options['exclude_paths'] : '';
                $un_exclude_paths = isset($schedule_options['un_exclude_paths']) ? $schedule_options['un_exclude_paths'] : '';
                ?>
                <form method="post" action="<?php echo admin_url( 'admin-post.php' ); ?>">
                    <input type="hidden" name="mainwp_hmbkp_schedule_id" value="<?php echo esc_attr( $schedule_id ); ?>" />
                    <input type="hidden" name="action" value="mainwp_hmbkp_edit_schedule_excluded_submit" />
                    <?php wp_nonce_field( 'mainwp-hmbkp-edit-schedule-excluded', 'mainwp-hmbkp-edit-schedule-excluded-nonce' ); ?>
                     <table class="form-table">
                        <tbody>
                            <tr valign="top">
                                <th scope="row">
                                    <label for="mainwp_hmbkp_schedule_excluded">Excluded directories and files</label>
                                </th>
                                <td>
                                    <textarea name="mainwp_hmbkp_schedule_excluded" id="mainwp_hmbkp_schedule_excluded" style="width: 100%; height: 135px;"><?php echo htmlspecialchars( $exclude_paths ); ?></textarea>
                                    <span class="description">One exclusion per line. <b>Enter relative to WordPress root.</b></span>
                                </td>
                            </tr>
                            <tr valign="top">
                                <th scope="row">
                                    <label for="mainwp_hmbkp_schedule_un_excluded">Un-excluded directories and files</label>
                                </th>
                                <td>
                                    <textarea name="mainwp_hmbkp_schedule_un_excluded" id="mainwp_hmbkp_schedule_un_excluded" style="width: 100%; height: 135px;"><?php echo htmlspecialchars( $un_exclude_paths ); ?></textarea>
                                    <span class="description">One exclusion per line. <b>Enter relative to WordPress root.</b></span>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                    <button type="submit" class="button-primary"><?php _e('Save', 'mainwp-buddy-extension'); ?></button>
                </form>
                <?php
                return;
            } else {
                // invalid
                return;
            }
        }

        // individual excluded
		$is_override = false;
		$_excluded_html = '';
		$_excluded_lasttime_reload = 0;

		if ( $current_site_id ) {
			$_backupwp_sche = \MainWP_BackUp_WordPress::get_instance()->get_backupwp_schedule( $schedule_id, $current_site_id, true );
			if ( ! empty( $_backupwp_sche ) && is_array( $_backupwp_sche ) ) {
				$is_override = $_backupwp_sche['override'];
				$_excluded_html = $_backupwp_sche['e'];
				$_excluded_lasttime_reload = $_backupwp_sche['lasttime_reload_excluded'];
			}
		}
		?>
        <div id="mainwp_backupwp_excluded_content">
			<?php
			if ( ! empty( $_excluded_html ) ) {
				echo $_excluded_html; } else if ( $is_override ) {
				echo '<p>' . __( 'Loading ...', 'mainwp-backupwordpress-extension' ) . '</p>';
				}
			?>
        </div>
		<?php if ( $is_override && (empty( $_excluded_html ) || ((time() - $_excluded_lasttime_reload) > 5 * 60)) ) { ?>
            <script type="text/javascript">
                jQuery(document).ready(function ($) {
                    mainwp_backupwp_individual_reload_excluded();
                })
            </script>
			<?php
}
	}

	public static function gen_add_edit_schedule( $schedule, $pBackupsPath, $current_site_id, $is_individual ) {

		$filesize = '';
		$startedAgo = '0';
		if ( $is_individual ) {
			$_schedule = \MainWP_BackUp_WordPress::get_instance()->get_backupwp_schedule( $schedule->get_id(), $current_site_id, $is_individual );
			if ( is_array( $_schedule ) && isset( $_schedule['file_size_text'] ) ) {
				$filesize = $_schedule['file_size_text'];
				$startedAgo = $_schedule['started_ago'];
			}
		}

		// Backup Type
		$type = strtolower( mainwp_hmbkp_human_get_type( $schedule->get_type() ) );

		// Backup Time
		$day = date_i18n( 'l', $schedule->get_next_occurrence( false ) );

		$next_backup = 'title="' . esc_attr( sprintf( __( 'The next backup will be on %1$s at %2$s %3$s', 'mainwp-backupwordpress-extension' ), date_i18n( get_option( 'date_format' ), $schedule->get_next_occurrence( false ) ), date_i18n( get_option( 'time_format' ), $schedule->get_next_occurrence( false ) ), date_i18n( 'T', $schedule->get_next_occurrence( false ) ) ) ) . '"';

		// Backup Re-occurrence
		switch ( $schedule->get_reoccurrence() ) :

			case 'hmbkp_hourly' :

				$reoccurrence = date_i18n( 'i', $schedule->get_next_occurrence( false ) ) === '00' ? '<span ' . $next_backup . '>' . __( 'hourly on the hour', 'mainwp-backupwordpress-extension' ) . '</span>' : sprintf( __( 'hourly at %s minutes past the hour', 'mainwp-backupwordpress-extension' ), '<span ' . $next_backup . '>' . intval( date_i18n( 'i', $schedule->get_next_occurrence( false ) ) ) ) . '</span>';

				break;

			case 'hmbkp_daily' :

				$reoccurrence = sprintf( __( 'daily at %s', 'mainwp-backupwordpress-extension' ), '<span ' . $next_backup . '>' . esc_html( date_i18n( get_option( 'time_format' ), $schedule->get_next_occurrence( false ) ) ) . '</span>' );

				break;

			case 'hmbkp_twicedaily' :

				$times[] = date_i18n( get_option( 'time_format' ), $schedule->get_next_occurrence( false ) );
				$times[] = date_i18n( get_option( 'time_format' ), strtotime( '+ 12 hours', $schedule->get_next_occurrence( false ) ) );

				sort( $times );

				$reoccurrence = sprintf( __( 'every 12 hours at %1$s &amp; %2$s', 'mainwp-backupwordpress-extension' ), '<span ' . $next_backup . '>' . esc_html( reset( $times ) ) . '</span>', '<span>' . esc_html( end( $times ) ) ) . '</span>';

				break;

			case 'hmbkp_weekly' :

				$reoccurrence = sprintf( __( 'weekly on %1$s at %2$s', 'mainwp-backupwordpress-extension' ), '<span ' . $next_backup . '>' . esc_html( $day ) . '</span>', '<span>' . esc_html( date_i18n( get_option( 'time_format' ), $schedule->get_next_occurrence( false ) ) ) . '</span>' );

				break;

			case 'hmbkp_fortnightly' :

				$reoccurrence = sprintf( __( 'biweekly on %1$s at %2$s', 'mainwp-backupwordpress-extension' ), '<span ' . $next_backup . '>' . $day . '</span>', '<span>' . esc_html( date_i18n( get_option( 'time_format' ), $schedule->get_next_occurrence( false ) ) ) . '</span>' );

				break;

			case 'hmbkp_monthly' :

				$reoccurrence = sprintf( __( 'on the %1$s of each month at %2$s', 'mainwp-backupwordpress-extension' ), '<span ' . $next_backup . '>' . esc_html( date_i18n( 'jS', $schedule->get_next_occurrence( false ) ) ) . '</span>', '<span>' . esc_html( date_i18n( get_option( 'time_format' ), $schedule->get_next_occurrence( false ) ) ) . '</span>' );

				break;

			case 'manually' :

				$reoccurrence = __( 'manually', 'mainwp-backupwordpress-extension' );

				break;

			default :

				$reoccurrence = __( 'manually', 'mainwp-backupwordpress-extension' );
				$schedule->set_reoccurrence( 'manually' );

		endswitch;
		$server = '';
		if ( ! empty( $pBackupsPath ) ) {
			$server = '<span title="' . esc_attr( $pBackupsPath ) . '">' . __( 'child server', 'mainwp-backupwordpress-extension' ) . '</span>';
			$server = '<code>' . esc_attr( $pBackupsPath ) . '</code>';
		}

		// Backup to keep
		switch ( $schedule->get_max_backups() ) :

			case 1 :
				if ( ! empty( $server ) ) {
					$backup_to_keep = sprintf( __( 'store the most recent backup in %s', 'mainwp-backupwordpress-extension' ), $server ); } else {
					$backup_to_keep = sprintf( __( 'store the most recent backup', 'mainwp-backupwordpress-extension' ) ); }
				break;

			case 0 :
				$backup_to_keep = sprintf( __( 'don\'t store any backups in on this server', 'mainwp-backupwordpress-extension' ), $server );

				break;

			default :
				if ( ! empty( $server ) ) {
					$backup_to_keep = sprintf( __( 'store the last %1$s backups in %2$s', 'mainwp-backupwordpress-extension' ), esc_html( $schedule->get_max_backups() ), $server ); } else {
					$backup_to_keep = sprintf( __( 'store the last %1$s backups', 'mainwp-backupwordpress-extension' ), esc_html( $schedule->get_max_backups() ) ); }

		endswitch;

		?>

		<?php if ( MAINWP\BackUpWordPress\Schedules::get_instance()->get_schedule( $schedule->get_id() ) ) { ?>

			<div class="mwp-hmbkp-schedule-sentence edit-screen <?php if ( $schedule->get_status() ) { ?> hmbkp-running<?php } ?>" schedule-id="<?php echo $schedule->get_id(); ?>">

				<?php
				$sentence = sprintf( _x( 'Backup my %1$s %2$s %3$s, %4$s.', '1: Backup Type 2: Total size of backup 3: Schedule 4: Number of backups to store', 'mainwp-backupwordpress-extension' ), '<span>' . $type . '</span>', $filesize, $reoccurrence, $backup_to_keep );


				echo $sentence;
				?>

				<?php
				if ( MAINWP\BackUpWordPress\Schedules::get_instance()->get_schedule( $schedule->get_id() ) ) {
					?>
					<span class="hmbkp-status"<?php if ( $schedule->get_status() ) { ?> title="<?php printf( __( 'Started %s ago', 'mainwp-backupwordpress-extension' ), $startedAgo ); ?>"<?php } ?>>
						<span class="status-text"><?php echo $schedule->get_status() ? wp_kses_data( $schedule->get_status() ) : __( 'Starting Backup', 'mainwp-backupwordpress-extension' ); ?></span>
						<a class="mainwp-hmbkp-cancel" href="#"><?php _e( 'Cancel', 'mainwp-backupwordpress-extension' ); ?></a>
            </span>
					<?php
					
				}

				$arg_setting = array( 'action' => 'mainwp_hmbkp_edit_schedule', 'mainwp_hmbkp_panel' => 'mainwp_hmbkp_edit_schedule_settings', 'mainwp_hmbkp_schedule_id' => $schedule->get_id() );
				$arg_exclude = array( 'action' => 'mainwp_hmbkp_edit_schedule', 'mainwp_hmbkp_panel' => 'mainwp_hmbkp_edit_schedule_excludes', 'mainwp_hmbkp_schedule_id' => $schedule->get_id() );
				$arg_edit = array( 'action' => 'mainwp_hmbkp_edit_schedule', 'mainwp_hmbkp_panel' => 'mainwp_hmbkp_edit_schedule_settings_' , 'mainwp_hmbkp_schedule_id' => $schedule->get_id() );
				$arg_delete = array( 'action' => 'mainwp_hmbkp_request_delete_schedule', 'mainwp_hmbkp_schedule_id' => $schedule->get_id() );

				$arg_more = array( '_referer_slug' => 'Extensions-Mainwp-Backupwordpress-Extension' );
				if ( $is_individual ) {
					$arg_more['id'] = $current_site_id;
					$arg_more['_referer_slug'] = 'ManageSitesBackUpWordPress';
				} else {
					$arg_run_global = array(
						'mainwp_hmbkp_schedule_id' => $schedule->get_id(),
						'_perform_action' => 'run_schedule',
						'mainwp_hmbkp_run_global_schedule' => wp_create_nonce( 'mainwp_hmbkp_run_global_schedule_nonce' ),
					);
					$arg_cancel = array(
						'action' => 'mainwp_hmbkp_request_cancle_schedule',
						'mainwp_hmbkp_schedule_id' => $schedule->get_id(),
						'_perform_action' => 'cancel_schedule',
						'mainwp_hmbkp_cancel_global_schedule' => wp_create_nonce( 'mainwp_hmbkp_cancel_global_schedule_nonce' ),
					);
				}

				$arg_setting = array_merge( $arg_setting, $arg_more );
				$arg_exclude = array_merge( $arg_exclude, $arg_more );
				$arg_delete = array_merge( $arg_delete, $arg_more );

				if ( MAINWP\BackUpWordPress\Schedules::get_instance()->get_schedule( $schedule->get_id() ) ) {
					?>
          <div class="mwp-hmbkp-schedule-actions">
						<?php if ( $current_site_id ) { ?>
							<a class="mainwp-hmbkp-run" href="#"><i class="fa fa-play"></i>  <?php _e( 'Run now', 'mainwp-backupwordpress-extension' ); ?></a>  |
						<?php } else { ?>
							<a href="<?php echo esc_url( add_query_arg( $arg_run_global, MAINWP_HMBKP_EXTENSION_URL ), 'hmbkp-edit-schedule' ); ?>"><i class="fa fa-play"></i> <?php _e( 'Run now', 'mainwp-backupwordpress-extension' ); ?></a> |
						<?php } ?>
						<a href="<?php echo esc_url( add_query_arg( $arg_setting, mainwp_hmbkp_get_settings_url() ), 'hmbkp-edit-schedule' ); ?>"><i class="fa fa-cog"></i> <?php _e( 'Settings', 'mainwp-backupwordpress-extension' ); ?></a> |

						<?php
						// Only show excludes if we are backing up files
						if ( 'database' !== $schedule->get_type() ) :
							?>
							<a href="<?php echo esc_url( add_query_arg( $arg_exclude, mainwp_hmbkp_get_settings_url() ) ); ?>"><i class="fa fa-times"></i> <?php _e( 'Excludes', 'mainwp-backupwordpress-extension' ); ?></a> |
						<?php endif; ?>

						<?php
						foreach ( MAINWP\BackUpWordPress\Services::get_services( $schedule ) as $service ) :

							if ( ! $service->has_form() ) {
								continue; }
							?>

							<a href="<?php echo esc_url( add_query_arg( $arg_edit, mainwp_hmbkp_get_settings_url() ) ); ?>"><?php echo esc_html( $service->name ); ?></a> |

						<?php endforeach; ?>

						<i class="fa fa-trash-o"></i> <a class="delete-action" href="<?php echo esc_url( wp_nonce_url( add_query_arg( $arg_delete, admin_url( 'admin-post.php' ) ), 'mainwp_hmbkp_delete_schedule', 'mainwp_hmbkp_delete_schedule_nonce' ) ); ?>"><?php _e( 'Delete', 'mainwp-backupwordpress-extension' ); ?></a>

						<?php if ( ! $is_individual ) : ?>
							| <a href="<?php echo esc_url( add_query_arg( $arg_cancel, mainwp_hmbkp_get_settings_url() ) ); ?>"><i class="fa fa-times"></i> <?php _e( 'Cancel', 'mainwp-backupwordpress-extension' ); ?></a>
						<?php endif; ?>
                    </div>

				<?php } ?>
                <p id="mwp-hmbkp-schedule-working"><i style="display: none;" class="fa fa-spinner fa-pulse"></i><span class="status"></span></p>
            </div>
			<?php
}

if ( ! isset( $_GET['action'] ) || 'mainwp_hmbkp_edit_schedule' !== $_GET['action'] || ! isset( $_GET['mainwp_hmbkp_panel'] ) ) {
	return;
}
		?>
        <div id="poststuff">
			<?php
			wp_nonce_field( 'meta-box-order', 'meta-box-order-nonce', false );
			wp_nonce_field( 'closedpostboxes', 'closedpostboxesnonce', false );

			if ( 'mainwp_hmbkp_edit_schedule' === $_GET['action'] ) {
				if ( 'mainwp_hmbkp_edit_schedule_settings' === $_GET['mainwp_hmbkp_panel'] ) {
					$screen = 'mainwp_hmbkp_page_schedule_settings';
				} else if ( 'mainwp_hmbkp_edit_schedule_excludes' === $_GET['mainwp_hmbkp_panel'] ) {
					$screen = 'mainwp_hmbkp_page_schedule_excluded';
				}

				if ( ! empty( $screen ) ) {
					do_meta_boxes( $screen, 'advanced', null );
				}
			}
			?>
      </div>

    <script type="text/javascript">
		var pagenow_mainwp_backupwp = '<?php echo $screen; ?>';
      </script>

		<?php
	}

	public static function gen_schedules_table_row( $schedule, $countBackup, $pStartedAgo, $pFileSizeText = '', $current_site_id = 0, $is_individual = false ) {

		if ( ! empty( $pFileSizeText ) ) {
			$filesize = $pFileSizeText; } else {
			$filesize = ''; }

			// Backup Type
			$type = strtolower( mainwp_hmbkp_human_get_type( $schedule->get_type() ) );
			// Backup Time
			$day = date_i18n( 'l', $schedule->get_next_occurrence( false ) );

			if ( $is_individual ) {
				$next_backup = 'title="' . esc_attr( sprintf( __( 'The next backup will be on %1$s at %2$s %3$s', 'mainwp-backupwordpress-extension' ), date_i18n( get_option( 'date_format' ), $schedule->get_next_occurrence( false ) ), date_i18n( get_option( 'time_format' ), $schedule->get_next_occurrence( false ) ), date_i18n( 'T', $schedule->get_next_occurrence( false ) ) ) ) . '"'; } else {
				$next_backup = ''; }

				// Backup Re-occurrence
				switch ( $schedule->get_reoccurrence() ) :

					case 'hmbkp_hourly' :
						if ( $is_individual ) {
							$reoccurrence = date_i18n( 'i', $schedule->get_next_occurrence( false ) ) === '00' ? '<span ' . $next_backup . '>' . __( 'hourly on the hour', 'mainwp-backupwordpress-extension' ) . '</span>' : sprintf( __( 'hourly at %s minutes past the hour', 'mainwp-backupwordpress-extension' ), '<span ' . $next_backup . '>' . intval( date_i18n( 'i', $schedule->get_next_occurrence( false ) ) ) ) . '</span>'; } else {
							$reoccurrence = __( 'hourly', 'mainwp-backupwordpress-extension' ); }

						break;

					case 'hmbkp_daily' :
						if ( $is_individual ) {
							$reoccurrence = sprintf( __( 'daily at %s', 'mainwp-backupwordpress-extension' ), '<span ' . $next_backup . '>' . esc_html( date_i18n( get_option( 'time_format' ), $schedule->get_next_occurrence( false ) ) ) . '</span>' ); } else {
							$reoccurrence = __( 'daily', 'mainwp-backupwordpress-extension' ); }

						break;

					case 'hmbkp_twicedaily' :
						if ( $is_individual ) {
							$times[] = date_i18n( get_option( 'time_format' ), $schedule->get_next_occurrence( false ) );
							$times[] = date_i18n( get_option( 'time_format' ), strtotime( '+ 12 hours', $schedule->get_next_occurrence( false ) ) );

							sort( $times );

							$reoccurrence = sprintf( __( 'every 12 hours at %1$s &amp; %2$s', 'mainwp-backupwordpress-extension' ), '<span ' . $next_backup . '>' . esc_html( reset( $times ) ) . '</span>', '<span>' . esc_html( end( $times ) ) ) . '</span>';
						} else {
							$reoccurrence = __( 'every 12 hours', 'mainwp-backupwordpress-extension' );
						}

						break;

					case 'hmbkp_weekly' :
						if ( $is_individual ) {
							$reoccurrence = sprintf( __( 'weekly on %1$s at %2$s', 'mainwp-backupwordpress-extension' ), '<span ' . $next_backup . '>' . esc_html( $day ) . '</span>', '<span>' . esc_html( date_i18n( get_option( 'time_format' ), $schedule->get_next_occurrence( false ) ) ) . '</span>' ); } else {
							$reoccurrence = __( 'weekly', 'mainwp-backupwordpress-extension' ); }

						break;

					case 'hmbkp_fortnightly' :
						if ( $is_individual ) {
							$reoccurrence = sprintf( __( 'biweekly on %1$s at %2$s', 'mainwp-backupwordpress-extension' ), '<span ' . $next_backup . '>' . $day . '</span>', '<span>' . esc_html( date_i18n( get_option( 'time_format' ), $schedule->get_next_occurrence( false ) ) ) . '</span>' ); } else {
							$reoccurrence = __( 'biweekly', 'mainwp-backupwordpress-extension' ); }

						break;

					case 'hmbkp_monthly' :
						if ( $is_individual ) {
							$reoccurrence = sprintf( __( 'on the %1$s of each month at %2$s', 'mainwp-backupwordpress-extension' ), '<span ' . $next_backup . '>' . esc_html( date_i18n( 'jS', $schedule->get_next_occurrence( false ) ) ) . '</span>', '<span>' . esc_html( date_i18n( get_option( 'time_format' ), $schedule->get_next_occurrence( false ) ) ) . '</span>' ); } else {
							$reoccurrence = __( 'monthly', 'mainwp-backupwordpress-extension' ); }
						break;

					case 'manually' :

						$reoccurrence = __( 'manually', 'mainwp-backupwordpress-extension' );

						break;

					default :

						$reoccurrence = __( 'manually', 'mainwp-backupwordpress-extension' );
						$schedule->set_reoccurrence( 'manually' );

		endswitch;
				$server = '';

				// Backup to keep
				switch ( $schedule->get_max_backups() ) :

					case 1 :
						if ( ! empty( $server ) ) {
							$backup_to_keep = sprintf( __( 'store the most recent backup in %s', 'mainwp-backupwordpress-extension' ), $server ); } else {
							$backup_to_keep = sprintf( __( 'store the most recent backup', 'mainwp-backupwordpress-extension' ) ); }
						break;

					case 0 :
						$backup_to_keep = sprintf( __( 'don\'t store any backups in on this server', 'mainwp-backupwordpress-extension' ), $server );

						break;

					default :
						if ( ! empty( $server ) ) {
							$backup_to_keep = sprintf( __( 'store the last %1$s backups in %2$s', 'mainwp-backupwordpress-extension' ), esc_html( $schedule->get_max_backups() ), $server ); } else {
							$backup_to_keep = sprintf( __( 'store the last %1$s backups', 'mainwp-backupwordpress-extension' ), esc_html( $schedule->get_max_backups() ) ); }

		endswitch;
				
		?>
        <tr><td>
				<div class="mwp-hmbkp-schedule-sentence<?php if ( $schedule->get_status() ) { ?> hmbkp-running<?php } ?>" schedule-id="<?php echo $schedule->get_id(); ?>">

					<?php
					$sentence = sprintf( _x( 'Backup my %1$s %2$s %3$s, %4$s.', '1: Backup Type 2: Total size of backup 3: Schedule 4: Number of backups to store', 'mainwp-backupwordpress-extension' ), '<span>' . $type . '</span>', $filesize, $reoccurrence, $backup_to_keep );
					echo $sentence;
					?>

					<?php
					if ( MAINWP\BackUpWordPress\Schedules::get_instance()->get_schedule( $schedule->get_id() ) ) {
						?>
						<span class="hmbkp-status"<?php if ( $schedule->get_status() ) { ?> title="<?php if ( ! empty( $pStartedAgo ) ) { printf( __( 'Started %s ago', 'mainwp-backupwordpress-extension' ), $pStartedAgo ); } ?>"<?php } ?>>
							<span class="status-text"><?php echo $schedule->get_status() ? wp_kses_data( $schedule->get_status() ) : __( 'Starting Backup', 'mainwp-backupwordpress-extension' ); ?></span>
							<a class="mainwp-hmbkp-cancel" href="#"><?php _e( 'Cancel', 'mainwp-backupwordpress-extension' ); ?></a>
                        </span>
						<?php
					}

					$arg_setting = array( 'action' => 'mainwp_hmbkp_edit_schedule', 'mainwp_hmbkp_panel' => 'mainwp_hmbkp_edit_schedule_settings', 'mainwp_hmbkp_schedule_id' => $schedule->get_id() );
					$arg_exclude = array( 'action' => 'mainwp_hmbkp_edit_schedule', 'mainwp_hmbkp_panel' => 'mainwp_hmbkp_edit_schedule_excludes', 'mainwp_hmbkp_schedule_id' => $schedule->get_id() );
					$arg_edit = array( 'action' => 'mainwp_hmbkp_edit_schedule', 'mainwp_hmbkp_panel' => 'mainwp_hmbkp_edit_schedule_settings_', 'mainwp_hmbkp_schedule_id' => $schedule->get_id() );
					$arg_delete = array( 'action' => 'mainwp_hmbkp_request_delete_schedule', 'mainwp_hmbkp_schedule_id' => $schedule->get_id() );

					$arg_more = array( '_referer_slug' => 'Extensions-Mainwp-Backupwordpress-Extension' );
					if ( $is_individual ) {
						$arg_more['id'] = $current_site_id;
						$arg_more['_referer_slug'] = 'ManageSitesBackUpWordPress';
					} else {
						$arg_run_global = array(
							'mainwp_hmbkp_schedule_id' => $schedule->get_id(),
							'_perform_action' => 'run_schedule',
							'mainwp_hmbkp_run_global_schedule' => wp_create_nonce( 'mainwp_hmbkp_run_global_schedule_nonce' ),
						);
						$arg_cancel = array(
							'action' => 'mainwp_hmbkp_request_cancle_schedule',
							'mainwp_hmbkp_schedule_id' => $schedule->get_id(),
							'_perform_action' => 'cancel_schedule',
							'mainwp_hmbkp_cancel_global_schedule' => wp_create_nonce( 'mainwp_hmbkp_cancel_global_schedule_nonce' ),
						);
					}

					$arg_setting = array_merge( $arg_setting, $arg_more );
					$arg_exclude = array_merge( $arg_exclude, $arg_more );
					$arg_delete = array_merge( $arg_delete, $arg_more );

					if ( MAINWP\BackUpWordPress\Schedules::get_instance()->get_schedule( $schedule->get_id() ) ) {
						?>
                        <div class="mwp-hmbkp-schedule-actions">
							<?php if ( $current_site_id ) { ?>
								<a class="mainwp-hmbkp-run" href="#"><i class="fa fa-play"></i> <?php _e( 'Run now', 'mainwp-backupwordpress-extension' ); ?></a>  |
							<?php } else { ?>
								<a href="<?php echo esc_url( add_query_arg( $arg_run_global, MAINWP_HMBKP_EXTENSION_URL ), 'hmbkp-edit-schedule' ); ?>"><i class="fa fa-play"></i> <?php _e( 'Run now', 'mainwp-backupwordpress-extension' ); ?></a> |
							<?php } ?>
							<a href="<?php echo esc_url( add_query_arg( $arg_setting, mainwp_hmbkp_get_settings_url() ), 'hmbkp-edit-schedule' ); ?>"><i class="fa fa-cog"></i> <?php _e( 'Settings', 'mainwp-backupwordpress-extension' ); ?></a> |

							<?php
							// Only show excludes if we are backing up files
							if ( 'database' !== $schedule->get_type() && $is_individual ) :
								?>
								<a href="<?php echo esc_url( add_query_arg( $arg_exclude, mainwp_hmbkp_get_settings_url() ) ); ?>"><i class="fa fa-times"></i> <?php _e( 'Excludes', 'mainwp-backupwordpress-extension' ); ?></a> |
							<?php endif; ?>

							<?php
							foreach ( MAINWP\BackUpWordPress\Services::get_services( $schedule ) as $service ) :

								if ( ! $service->has_form() ) {
									continue; }
								?>

								<a href="<?php echo esc_url( add_query_arg( $arg_edit, mainwp_hmbkp_get_settings_url() ) ); ?>"><?php echo esc_html( $service->name ); ?></a> |

							<?php endforeach; ?>

							<a class="delete-action" href="<?php echo esc_url( wp_nonce_url( add_query_arg( $arg_delete, admin_url( 'admin-post.php' ) ), 'mainwp_hmbkp_delete_schedule', 'mainwp_hmbkp_delete_schedule_nonce' ) ); ?>"><i class="fa fa-trash-o"></i>  <?php _e( 'Delete', 'mainwp-backupwordpress-extension' ); ?></a>

							<?php if ( ! $is_individual ) : ?>
								| <a href="<?php echo esc_url( add_query_arg( $arg_cancel, mainwp_hmbkp_get_settings_url() ) ); ?>"><i class="fa fa-times"></i> <?php _e( 'Cancel', 'mainwp-backupwordpress-extension' ); ?></a>
							<?php endif; ?>
                        </div>

					<?php } ?>
                    <p id="mwp-hmbkp-schedule-working"><i style="display: none;" class="fa fa-spinner fa-pulse"></i><span class="status"></span></p>
                </div>
            </td><td>
				<?php echo esc_html( mainwp_hmbkp_translated_schedule_title( $schedule->get_slug(), $schedule->get_name() ) ); ?>
            </td><td>
				<?php echo $countBackup; ?>
            </td>
        </tr>
		<?php
	}

	public static function site_settings_box() {
		$site_id = isset( $_GET['id'] ) ? intval($_GET['id']) : 0;
		$override = 0;
		if ( $site_id ) {
			$site_backupwp = MainWP_BackUp_WordPress_DB::get_instance()->get_backupwp_by( 'site_id', $site_id, 'override' );
			if ( $site_backupwp ) {
				$override = $site_backupwp->override;
			}
		}
		?>
    <div class="ui segment form" id="backupwp_site_settings">
			<h3 class="ui dividing header"><?php _e( 'BackUpWordPress Site Settings', 'mainwp-backupwordpress-extension' ); ?></h3>
			<input type="hidden" name="mainwp_backupwp_settings_site_id" value="<?php echo $site_id; ?>">
			<div class="ui info message"><?php echo __( 'To Run, Edit or Create schedules for this site, you need to set the Override General Settings option to yes and click the Save button.', 'mainwp-backupwordpress-extension' ); ?></div>
			<div class="ui grid field">
				<label class="six wide column middle aligned"><?php _e( 'Override General Settings', 'mainwp-backupwordpress-extension' ); ?></label>
			  <div class="one wide column ui toggle checkbox">
					<input type="checkbox" id="mainwp_backupwp_override_general_settings" name="mainwp_backupwp_override_general_settings"  <?php echo (0 == $override ? '' : 'checked="checked"'); ?> value="1"/><label></label>
				</div>
				<div class="one wide column middle aligned">
					<input class="ui green mini button" id="mwp_backupwp_settings_save_btn" type="button" value="<?php echo __( 'Save', 'mainwp-backupwordpress-extension' ); ?>" />
				</div>
				<div class="eight wide column middle aligned">
					<i style="display: none;" class="notched circle loading icon"></i> <span id="mwp_backupwp_perform_individual_status" class="hidden"></span>
				</div>
			</div>
    </div>
		<?php
		global $current_user;
		if ( get_option( 'mainwp_backupwp_perform_individual_settings_update' ) == 1 ) {
			delete_option( 'mainwp_backupwp_perform_individual_settings_update' );
			?>
			<script type="text/javascript">
					  mainwp_backupwp_individual_save_settings(<?php echo $site_id; ?>);
			</script>
			<?php
		}
	}

	public static function premium_setting_box( $site_id = 0 ) {
		$is_premium = MainWP_BackUp_WordPress_Extension::is_backupwp_premium();
		?>
    <div class="postbox" id="backupwp_premium_setting">
			<h3 class="mainwp_box_title"><span><i class="fa fa-cog"></i> <?php _e( 'BackUpWordPress Version Settings', 'mainwp-backupwordpress-extension' ); ?></span></h3>
            <div class="inside">
                <form method="post" action="" >
					<input type="hidden" name="mainwp_premium_backupwp_site_id" value="<?php echo $site_id; ?>">
                    <table class="form-table" >
                        <tr valign="top">
                            <th scope="row" class="settinglabel">
								<?php _e( 'Use premium version', 'mainwp-backupwordpress-extension' ); ?> <?php do_action( 'mainwp_renderToolTip', __( 'Set to YES if you want to use with the BackupWPWordpress premium version.', 'mainwp-backupwordpress-extension' ) ); ?>
                            </th>
                            <td class="settingfield">
                                <div class="mainwp-checkbox">
									<input type="checkbox" id="mwp_backupwp_is_premium" name="mwp_backupwp_is_premium"  <?php echo ($is_premium ? 'checked="checked"' : ''); ?> value="yes"/>
                                    <label for="mwp_backupwp_is_premium"></label>
                                </div>&nbsp;&nbsp;
                            </td>
                        </tr>
                    </table>
					<input class="button-primary" type="submit" name="submit" value="<?php echo __( 'Save', 'mainwp-backupwordpress-extension' ); ?>" />
                </form>
            </div>
        </div>
		<?php
		global $current_user;
	}

	public static function open_site() {
		$id = intval($_GET['websiteid']);
		global $mainWPBackUpWordPressExtensionActivator;
		$websites = apply_filters( 'mainwp-getdbsites', $mainWPBackUpWordPressExtensionActivator->get_child_file(), $mainWPBackUpWordPressExtensionActivator->get_child_key(), array( $id ) );
		$website = null;
		if ( $websites && is_array( $websites ) ) {
			$website = current( $websites );
		}

		$open_location = '';
		if ( isset( $_GET['open_location'] ) ) {
			$open_location = esc_html( $_GET['open_location'] ); 			
		}
		?>
        <div id="mainwp_background-box">
			<?php
			if ( function_exists( 'mainwp_current_user_can' ) && ! mainwp_current_user_can( 'dashboard', 'access_wpadmin_on_child_sites' ) ) {
				mainwp_do_not_have_permissions( 'WP-Admin on child sites' );
			} else {
				?>
				<div style="font-size: 30px; text-align: center; margin-top: 5em;"><?php _e( 'You will be redirected to your website immediately.', 'mainwp-backupwordpress-extension' ); ?></div>
				<form method="POST" action="<?php echo MainWP_BackUp_WordPress_Utility::get_get_data_authed( $website, 'index.php', 'where', $open_location ); ?>" id="redirectForm">
                </form>
			<?php } ?>
        </div>
		<?php
	}

	public static function is_backupwp_page( $tabs = array() ) {
		if ( isset( $_GET['page'] ) && ('Extensions-Mainwp-Backupwordpress-Extension' == $_GET['page'] || 'ManageSitesBackUpWordPress' == $_GET['page']) ) {
			if ( 'ManageSitesBackUpWordPress' == $_GET['page'] ) {
				if ( ! isset( $_GET['tab'] ) || empty( $_GET['tab'] ) ) {
					$_GET['tab'] = 'settings';
				}
			}
			if ( empty( $tabs ) ) {
				return true;
			} else if ( is_array( $tabs ) && isset( $_GET['tab'] ) && in_array( $_GET['tab'], $tabs ) ) {
				return true;
			} else if ( isset( $_GET['tab'] ) && $_GET['tab'] == $tabs ) {
				return true;
			}
		}
		return false;
	}

	public static function is_managesites_page( $tabs = array() ) {
		if ( isset( $_POST['individual'] ) && ! empty( $_POST['individual'] ) && isset( $_POST['backupwpRequestSiteID'] ) && ! empty( $_POST['backupwpRequestSiteID'] ) ) {
			return true;
		} else if ( isset( $_GET['page'] ) && ('ManageSitesBackUpWordPress' == $_GET['page']) ) {
			return true;
		} else if ( isset( $_GET['_referer_slug'] ) && ('ManageSitesBackUpWordPress' == $_GET['_referer_slug']) ) {
			return true;
		} else if ( isset( $_REQUEST['mainwp_backupwp_site_id'] ) && ! empty( $_REQUEST['mainwp_backupwp_site_id'] ) ) {
			return true;
		}
		return false;
	}

	public static function get_site_id_managesites_backupwp() {
		$site_id = 0;
		if ( self::is_managesites_page() ) {
			// ajax
			if ( isset( $_POST['individual'] ) && ! empty( $_POST['individual'] ) && isset( $_REQUEST['backupwpRequestSiteID'] ) && ! empty( $_REQUEST['backupwpRequestSiteID'] ) ) {
				$site_id = $_REQUEST['backupwpRequestSiteID']; 				
			} else if ( isset( $_GET['id'] ) && ! empty( $_GET['id'] ) ) {
				$site_id = $_GET['id']; 				
			} else if ( isset( $_REQUEST['mainwp_backupwp_site_id'] ) && ! empty( $_REQUEST['mainwp_backupwp_site_id'] ) ) {
					$site_id = $_REQUEST['mainwp_backupwp_site_id']; 					
			}
		}
		return intval($site_id);
	}

	public function get_schedules_ids( $site_id = false ) {

		if ( false === $site_id ) {
			$site_id = self::get_site_id_managesites_backupwp(); }

		if ( $site_id ) {
			$backupwp = MainWP_BackUp_WordPress_DB::get_instance()->get_backupwp_by( 'site_id', $site_id );
			if ( empty( $backupwp ) ) {
				return array(); }
			$backupwp_schedules = unserialize( base64_decode( $backupwp->schedules ) );

			$ids = array();
			if ( is_array( $backupwp_schedules ) ) {
				foreach ( $backupwp_schedules as $id => $sch ) {
					$ids[] = $id;
				}
			}
			return $ids;
		} else {
			return self::get_general_schedules_ids();
		}
		return false;
	}

	public function get_backupwp_schedule( $sch_id, $site_id = false, $isIndividual = false ) {
		if ( empty( $sch_id ) ) {
			return array(); }

		if ( $isIndividual ) {
			if ( empty( $site_id ) ) {
				return array(); }
			$backupwp = MainWP_BackUp_WordPress_DB::get_instance()->get_backupwp_by( 'site_id', $site_id );
			if ( empty( $backupwp ) ) {
				return array(); }
			$schedules = unserialize( base64_decode( $backupwp->schedules ) );
			if ( ! is_array( $schedules ) || ! isset( $schedules[ $sch_id ] ) ) {
				return array(); }
			$schedule = $schedules[ $sch_id ];
			$schedule['override'] = $backupwp->override;
			return $schedule;
		} else {
			return $this->get_general_schedule( $sch_id );
		}
		return false;
	}

	public function get_individual_backup( $site_id = false ) {
		if ( empty( $site_id ) ) {
			return false; }

		$backupwp = MainWP_BackUp_WordPress_DB::get_instance()->get_backupwp_by( 'site_id', $site_id );
		if ( empty( $backupwp ) ) {
			return array(); }

		$schedules = unserialize( base64_decode( $backupwp->schedules ) );

		if ( ! is_array( $schedules ) ) {
			return array(); }

		$bcks = array();
		foreach ( $schedules as $sch_id => $_sche ) {
			$bcks[ $sch_id ] = $_sche;
			//                                array('backups_html' => isset($_sche['backups_html']) ? $_sche['backups_html'] : "",
			//                                    'backups_count' =>  isset($_sche['backups_count']) ? $_sche['backups_count'] : 0,
			//                                    'lasttime_reload_backups' => isset($_sche['lasttime_reload_backups']) ? $_sche['lasttime_reload_backups'] : 0,
			//                                    'excludes_html' => isset($_sche['excludes_html']) ? $_sche['excludes_html'] : '',
			//                                    'lasttime_reload_excluded' => isset($_sche['lasttime_reload_excluded']) ? $_sche['lasttime_reload_excluded'] : 0,
			//                                    'file_size_text' => isset($_sche['file_size_text']) ? $_sche['file_size_text'] : "",
			//                                    'scheduleStatus' => isset($_sche['scheduleStatus']) ? $_sche['scheduleStatus'] : "",
			//                                );
		}
		return $bcks;
	}

	public function get_backups_data( $site_ids = array() ) {
		$backupwps = MainWP_BackUp_WordPress_DB::get_instance()->get_backups( $site_ids );
		if ( ! is_array( $backupwps ) ) {
			return array(); }
		return $backupwps;
	}

	public function delete_backupwp_schedule( $sch_id, $site_id = false ) {
		if ( false === $site_id ) {
			$site_id = self::get_site_id_managesites_backupwp(); }

		if ( $site_id ) {
			return MainWP_BackUp_WordPress_DB::get_instance()->delete_backup_schedule( $site_id, $sch_id );
		} else {
			return $this->delete_general_schedule( $sch_id );
		}
		return false;
	}

	public function update_backupwp_schedule( $sch_id, $data, $site_id = false ) {
		if ( false === $site_id ) {
			$site_id = self::get_site_id_managesites_backupwp(); 			
		}

		if ( $site_id ) {
			return MainWP_BackUp_WordPress_DB::get_instance()->update_backupwp_schedule( $site_id, $sch_id, $data );
		} else {
			return $this->update_general_schedule( $sch_id, $data );
		}
		return false;
	}

	private function get_general_schedule( $sch_id ) {
		$current_schedules = get_site_option( 'mainwp_backupwp_gen_Schedules' );
		if ( ! is_array( $current_schedules ) || ! isset( $current_schedules[ $sch_id ] ) ) {
			return array(); }

		$value = $current_schedules[ $sch_id ];
		if ( ! is_array( $value ) ) {
			return array(); }

		return $value;
	}

	private function update_general_schedule( $sch_id, $data ) {
		$current_schedules = get_site_option( 'mainwp_backupwp_gen_Schedules' );
		if ( ! is_array( $current_schedules ) ) {
			$current_schedules = array(); }
		$value = array();
		$this->map_data_fields( $value, $data );
		$current_schedules[ $sch_id ] = $value;
		return update_site_option( 'mainwp_backupwp_gen_Schedules', $current_schedules );
	}

	public static function get_general_schedules_ids() {
		$current_schedules = get_site_option( 'mainwp_backupwp_gen_Schedules' );
		$ids = array();
		if ( is_array( $current_schedules ) ) {
			foreach ( $current_schedules as $id => $val ) {
				$ids[] = $id;
			}
		}
		//$this->refresh_BackupsListHtml_of_GeneralSchedules($ids);
		return $ids;
	}

	public function map_data_fields( &$input, $data ) {
		if ( ! is_array( $input ) ) {
			$input = array(); }

		$fields = array(
		'options',
			'next_occurrence',
			'excludes_html',
			'backups_html',
			'backups_count',
			'lasttime_reload_backups',
			'lasttime_reload_excluded',
			'file_size_text',
			'scheduleStatus',
			'started_ago',
		);

		foreach ( $fields as $field ) {
			if ( isset( $data[ $field ] ) ) {
				$input[ $field ] = $data[ $field ];
			}
		}

		return $input;
	}

	private function delete_general_schedule( $sch_id ) {
		if ( empty( $sch_id ) ) {
			return false; }
		$current_schedules = get_site_option( 'mainwp_backupwp_gen_Schedules' );

		if ( ! is_array( $current_schedules ) || ! isset( $current_schedules[ $sch_id ] ) ) {
			return true; }

		unset( $current_schedules[ $sch_id ] );
		return update_site_option( 'mainwp_backupwp_gen_Schedules', $current_schedules );
	}

	public static function ajax_general_load_sites( $what = null, $scheduleId = null ) {

		global $mainWPBackUpWordPressExtensionActivator;
		$websites = apply_filters( 'mainwp-getsites', $mainWPBackUpWordPressExtensionActivator->get_child_file(), $mainWPBackUpWordPressExtensionActivator->get_child_key(), null );
		$sites_ids = array();
		if ( is_array( $websites ) ) {
			foreach ( $websites as $website ) {
				$sites_ids[] = $website['id'];
			}
			unset( $websites );
		}
		$option = array(
            'plugin_upgrades' => true,
			'plugins' => true,
		);
		$dbwebsites = apply_filters( 'mainwp-getdbsites', $mainWPBackUpWordPressExtensionActivator->get_child_file(), $mainWPBackUpWordPressExtensionActivator->get_child_key(), $sites_ids, array(), $option );
		$dbwebsites_backupwp = MainWP_BackUp_WordPress_Plugin::get_instance()->get_websites_with_the_plugin( $dbwebsites );
		unset( $dbwebsites );

		$title = '';
		if ( 'delete_schedule' == $what ) {
			$title = __( 'Deleting Schedule on child sites...', 'mainwp-backupwordpress-extension' );
		} else if ( 'reload_backups' == $what ) {
			$title = __( 'Reloading Data from Child Sites...', 'mainwp-backupwordpress-extension' );
		} else if ( 'run_schedule' == $what ) {
			$title = __( 'Run Schedule Backup on child sites...', 'mainwp-backupwordpress-extension' );
		} else if ( 'update_schedule' == $what ) {
			$title = __( 'Saving Schedule to child sites...', 'mainwp-backupwordpress-extension' );
		} else if ( 'cancel_schedule' == $what ) {
			$title = __( 'Cancel Schedule on child sites...', 'mainwp-backupwordpress-extension' );
		} else if ( 'general_exclude_rules' == $what ) {
			$title = __( 'Exclude/Un-Exclude directories and files on child sites...', 'mainwp-backupwordpress-extension' );
		}

		echo '<div class="ui segment">';

		if ( ! empty( $title ) ) {
			echo '<h3 class="ui dividing header">' . $title . '</h3>';
		}

		$have_active = false;
		if ( is_array( $dbwebsites_backupwp ) && count( $dbwebsites_backupwp ) > 0 ) {
			foreach ( $dbwebsites_backupwp as $website ) {
				if ( ! isset( $website['backupwp_active'] ) || empty( $website['backupwp_active'] ) ) {
					continue; }
				$have_active = true;
				echo '<div><strong>' . $website['name'] . '</strong>: ';
				echo '<span class="siteItemProcess" site-id="' . $website['id'] . '" status="queue"><span class="status">Queue ...</span> <i style="display: none;" class="notched circle loading icon"></i></span>';
				echo '</div><br />';
			}
		}

		if ( ! $have_active ) {
			echo '<div class="ui red message">' . __( 'No websites were found with the BackUpWordPress plugin installed.', 'mainwp-backupwordpress-extension' ) . '</div>';
			return;
		}
		echo '</div>';
		?>
        <script type="text/javascript">
            jQuery(document).ready(function ($) {
                backupwp_bulkTotalThreads = jQuery('.siteItemProcess[status=queue]').length;
                if (backupwp_bulkTotalThreads > 0) {
				<?php if ( ! empty( $what ) ) { ?>
								mainwp_backupwp_perform_schedule_start_next('<?php echo $what; ?>');
				<?php } ?>
                }
            });
        </script>
		<?php
		if ( isset( $_POST['_backupwpNonce'] ) ) {
			die();
		}
	}

	public static function get_open_location_link( $site_id, $loc ) {
		$loc = base64_encode( $loc );
		return 'admin.php?page=Extensions-Mainwp-Backupwordpress-Extension&action=mwpBackupWPOpenSite&websiteid=' . $site_id . '&open_location=' . $loc;
	}

	function ajax_check_data( $check_schedule_id = true ) {
		if ( ! isset( $_REQUEST['_backupwpNonce'] ) || ! wp_verify_nonce( $_REQUEST['_backupwpNonce'], 'mainwp_hmbkp_nonce' ) ) {
			die( json_encode( array( 'error' => 'Security Error.' ) ) ); }

		if ( empty( $_POST['backupwpRequestSiteID'] ) ) {
			die( json_encode( array( 'error' => 'Empty site id.' ) ) ); }

		if ( $check_schedule_id ) {
			if ( ! isset( $_REQUEST['scheduleId'] ) || empty( $_REQUEST['scheduleId'] ) ) {
				die( json_encode( array( 'error' => 'Empty schedule id.' ) ) );
			}
		}
	}

	function ajax_check_individual_action( $pSiteId ) {
		$site_backupwp = MainWP_BackUp_WordPress_DB::get_instance()->get_backupwp_by( 'site_id', $pSiteId, 'override' );
		$individual = isset( $_POST['individual'] ) && ! empty( $_POST['individual'] ) ? true : false;
		if ( $individual ) {
			if ( $site_backupwp && ! $site_backupwp->override ) {
				die( json_encode( array( 'error' => 'Action could not be performed: Override General Settings needs to be set to Yes.' ) ) );
			}
		} else {
			if ( $site_backupwp && $site_backupwp->override ) {
				die( json_encode( array( 'message' => __( 'Not perform action - Individual site settings are in use.', 'mainwp-backupwordpress-extension' ) ) ) );
			}
		}
	}

	function ajax_override_settings() {
		$this->ajax_check_data( false );
		$websiteId = $_POST['backupwpRequestSiteID'];
		global $mainWPBackUpWordPressExtensionActivator;
		$website = apply_filters( 'mainwp-getsites', $mainWPBackUpWordPressExtensionActivator->get_child_file(), $mainWPBackUpWordPressExtensionActivator->get_child_key(), $websiteId );
		if ( $website && is_array( $website ) ) {
			$website = current( $website );
		}

		if ( ! $website ) {
			die( json_encode( array( 'error' => 'Error site data.' ) ) ); }

		$update = array(
			'site_id' => $website['id'],
			'override' => $_POST['override'],
		);

		MainWP_BackUp_WordPress_DB::get_instance()->update_backupwp( $update );
		die( json_encode( array( 'result' => 'success' ) ) );
	}

	function ajax_delete_schedule() {
		$this->ajax_check_data();
		$websiteId = $_POST['backupwpRequestSiteID'];
		$this->ajax_check_individual_action( $websiteId );

		global $mainWPBackUpWordPressExtensionActivator;
		$post_data = array(
		'mwp_action' => 'delete_schedule',
			'schedule_id' => $_REQUEST['scheduleId'],
		);

		$information = apply_filters( 'mainwp_fetchurlauthed', $mainWPBackUpWordPressExtensionActivator->get_child_file(), $mainWPBackUpWordPressExtensionActivator->get_child_key(), $websiteId, 'backup_wp', $post_data );
		die( json_encode( $information ) );
	}

	function ajax_run_schedule() {
		$this->ajax_check_data();

		$websiteId = $_POST['backupwpRequestSiteID'];

		$this->ajax_check_individual_action( $websiteId );

		$sch_id = $_REQUEST['scheduleId'];
		$individual = isset( $_POST['individual'] ) && ! empty( $_POST['individual'] ) ? true : false;

		global $mainWPBackUpWordPressExtensionActivator;
		$post_data = array(
		'mwp_action' => 'run_schedule',
			'schedule_id' => $sch_id,
		);

		$information = apply_filters( 'mainwp_fetchurlauthed', $mainWPBackUpWordPressExtensionActivator->get_child_file(), $mainWPBackUpWordPressExtensionActivator->get_child_key(), $websiteId, 'backup_wp', $post_data );

		if ( $individual && is_array( $information ) && isset( $information['scheduleStatus'] ) ) {
			$update = array(
				'scheduleStatus' => $information['scheduleStatus'],
				'file_size_text' => $information['file_size_text'],
			);
			\MainWP_BackUp_WordPress::get_instance()->update_backupwp_schedule( $sch_id, $update, $websiteId );
		}

		die( json_encode( $information ) );
	}

	function ajax_cancel_schedule() {
		$this->ajax_check_data();

		$websiteId = $_POST['backupwpRequestSiteID'];

		$this->ajax_check_individual_action( $websiteId );

		$sch_id = $_REQUEST['scheduleId'];
		$individual = isset( $_POST['individual'] ) && ! empty( $_POST['individual'] ) ? true : false;

		global $mainWPBackUpWordPressExtensionActivator;
		$post_data = array(
		'mwp_action' => 'cancel_schedule',
			'schedule_id' => $sch_id,
		);

		$information = apply_filters( 'mainwp_fetchurlauthed', $mainWPBackUpWordPressExtensionActivator->get_child_file(), $mainWPBackUpWordPressExtensionActivator->get_child_key(), $websiteId, 'backup_wp', $post_data );

		if ( is_array( $information ) ) {
			if ( isset( $information['scheduleStatus'] ) ) {
				if ( $individual ) {
					$update = array(
						'scheduleStatus' => $information['scheduleStatus'],
					);
					\MainWP_BackUp_WordPress::get_instance()->update_backupwp_schedule( $sch_id, $update, $websiteId );
				} else {
					unset( $information['scheduleStatus'] );
				}
			}
		}
		die( json_encode( $information ) );
	}

	function ajax_refresh_backup_status() {
		$this->ajax_check_data();

		$websiteId = $_POST['backupwpRequestSiteID'];

		$this->ajax_check_individual_action( $websiteId );

		$sch_id = $_REQUEST['scheduleId'];
		$individual = isset( $_POST['individual'] ) && ! empty( $_POST['individual'] ) ? true : false;

		global $mainWPBackUpWordPressExtensionActivator;
		$post_data = array(
		'mwp_action' => 'get_backup_status',
			'schedule_id' => $sch_id,
		);

		$information = apply_filters( 'mainwp_fetchurlauthed', $mainWPBackUpWordPressExtensionActivator->get_child_file(), $mainWPBackUpWordPressExtensionActivator->get_child_key(), $websiteId, 'backup_wp', $post_data );

		if ( is_array( $information ) ) {
			if ( isset( $information['scheduleStatus'] ) ) {
				if ( $individual ) {
					$update = array(
						'scheduleStatus' => $information['scheduleStatus'],
					);
					if ( empty( $information['scheduleStatus'] ) ) {
						$update['lasttime_reload_backups'] = 0; // to reload
					}

					\MainWP_BackUp_WordPress::get_instance()->update_backupwp_schedule( $sch_id, $update, $websiteId );
				} else {
					unset( $information['scheduleStatus'] );
				}
			}
		}
		die( json_encode( $information ) );
	}

	function ajax_update_schedule() {
		$this->ajax_check_data();

		$websiteId = $_POST['backupwpRequestSiteID'];

		$this->ajax_check_individual_action( $websiteId );

		$sch_id = sanitize_text_field( $_REQUEST['scheduleId'] );

		$individual = isset( $_POST['individual'] ) && ! empty( $_POST['individual'] ) ? true : false;

		global $mainWPBackUpWordPressExtensionActivator;
		$schedule = \MainWP_BackUp_WordPress::get_instance()->get_backupwp_schedule( $sch_id, $websiteId, $individual );

		if ( empty( $schedule ) || ! is_array( $schedule ) || ! isset( $schedule['options'] ) || ! is_array( $schedule['options'] ) ) {
			die( json_encode( array( 'error' => 'Error schedule data.' ) ) ); }

		// fix for new version of backupwordpress plugin
		$schedule_options = is_array($schedule['options']) ? $schedule['options'] : array();
		if (isset($schedule_options['reoccurrence'])) {
			$schedule_options['reoccurrence'] = str_replace('hmbkp_', '', $schedule_options['reoccurrence']);
		}

        // will save those value at ajax_general_exclude_rules
        $un_save_fields = array(
            'exclude_paths',
            'un_exclude_paths'
        );

        foreach($un_save_fields as $field) {
            if (isset($schedule_options[$field])) {
                unset($schedule_options[$field]);
            }
        }

		$post_data = array(
            'mwp_action' => 'update_schedule',
			'schedule_id' => $sch_id,
			'options' => base64_encode( serialize( $schedule_options ) ),
		);
		$information = apply_filters( 'mainwp_fetchurlauthed', $mainWPBackUpWordPressExtensionActivator->get_child_file(), $mainWPBackUpWordPressExtensionActivator->get_child_key(), $websiteId, 'backup_wp', $post_data );
		if ( is_array( $information ) && isset( $information['next_occurrence'] ) ) {
			if ( $individual ) {
				$update = array( 'next_occurrence' => $information['next_occurrence'] );
				\MainWP_BackUp_WordPress::get_instance()->update_backupwp_schedule( $sch_id, $update, $websiteId );
			}
		}
		die( json_encode( $information ) );
	}

	function mainwp_apply_plugin_settings($websiteId) {
		global $mainWPBackUpWordPressExtensionActivator;
		$current_schedules = get_site_option( 'mainwp_backupwp_gen_Schedules' );

		if ( empty( $current_schedules ) || ! is_array( $current_schedules ) ) {
			die( json_encode( array( 'error' => 'Schedule data empty.' ) ) ); }
		//isset( $schedule['options'] ) || ! is_array( $schedule['options']
		$post_data = array(
		'mwp_action' => 'save_all_schedules',
			'all_schedules' => base64_encode( serialize( $current_schedules ) ),
		);
		$information = apply_filters( 'mainwp_fetchurlauthed', $mainWPBackUpWordPressExtensionActivator->get_child_file(), $mainWPBackUpWordPressExtensionActivator->get_child_key(), $websiteId, 'backup_wp', $post_data );

		$result = array();
		if (is_array($information)) {
			if ( isset( $information['result']) && 'SUCCESS' == $information['result']) {
				$result = array('result' => 'success');
			} else if (isset($information['error'])) {
				$result = array('error' => $information['error']);
			} else {
				$result = array('result' => 'failed');
			}
		} else {
			$result = array('error' => __('Undefined error', $this->plugin_translate));
		}
		die( json_encode( $result ) );
	}

	function ajax_reload_backups() {
		$this->ajax_check_data( false );

		$websiteId = $_POST['backupwpRequestSiteID'];

		if ( empty( $websiteId ) ) {
			die( json_encode( array( 'error' => 'Empty site id.' ) ) ); }
		// check individual reload backups
		$site_backupwp = MainWP_BackUp_WordPress_DB::get_instance()->get_backupwp_by( 'site_id', $websiteId, 'override' );
		$individual = isset( $_POST['individual'] ) && ! empty( $_POST['individual'] ) ? true : false;
		if ( $individual ) {
			if ( $site_backupwp && ! $site_backupwp->override ) {
				die( json_encode( array( 'error' => __( 'Action could not be performed: Override General Settings needs to be set to Yes.', 'mainwp-backupwordpress-extension' ) ) ) );
			}
		}
		if ( $individual ) {
			$sch_ids = $this->get_schedules_ids( $websiteId );
		}
		else
		{
			$sch_ids = self::get_general_schedules_ids();
		}

			//        if (empty($sch_ids) && $individual)
			//            die(json_encode(array('error' => 'Schedules IDs empty.')));

			global $mainWPBackUpWordPressExtensionActivator;

			$post_data = array(
			'mwp_action' => 'reload_backupslist',
			'schedule_ids' => $sch_ids,
			);

			$information = apply_filters( 'mainwp_fetchurlauthed', $mainWPBackUpWordPressExtensionActivator->get_child_file(), $mainWPBackUpWordPressExtensionActivator->get_child_key(), $websiteId, 'backup_wp', $post_data );

			if ( is_array( $information ) && isset( $information['backups_path'] ) ) {
				if ( isset( $information['send_back_schedules'] ) && is_array( $information['send_back_schedules'] ) ) {
					$sync_schedules_ids = array();
					foreach ( $information['send_back_schedules'] as $back_sch_id => $back_schedule ) {
						$sch_options = $back_schedule['options'];
						if (is_array($sch_options) && isset($sch_options['reoccurrence'])) {
							if ($sch_options['reoccurrence'] != "manually") {
								if (strpos($sch_options['reoccurrence'], 'hmbkp_') === false) {
									$sch_options['reoccurrence'] = 'hmbkp_' . $sch_options['reoccurrence'];
								}
							}
						}
						$update = array(
						'options' => $sch_options,
						'backups_html' => $back_schedule['b'],
						'backups_count' => $back_schedule['count'],
						'lasttime_reload_backups' => time(),
						'file_size_text' => $back_schedule['file_size_text'],
						'scheduleStatus' => $back_schedule['scheduleStatus'],
						'started_ago' => $back_schedule['started_ago'],
						);
						\MainWP_BackUp_WordPress::get_instance()->update_backupwp_schedule( $back_sch_id, $update, $websiteId );
						$sync_schedules_ids[] = $back_sch_id;
					}

//					if (count($sync_schedules_ids) > 0) {
//						MainWP_BackUp_WordPress_DB::get_instance()->sync_backupwp_schedule( $websiteId, $sync_schedules_ids );
//					}
					unset( $information['send_back_schedules'] );
				}

				if ( isset( $information['backups'] ) && is_array( $information['backups'] ) ) {
					MainWP_BackUp_WordPress_DB::get_instance()->delete_schedule_data_of_site( $websiteId, 'backups_html' );  // clear backups_html of schedules first
					foreach ( $information['backups'] as $sch_id => $backup ) {
						$update = array(
						'backups_html' => $backup['b'],
						'backups_count' => $backup['count'],
						'lasttime_reload_backups' => time(),
						'file_size_text' => $backup['file_size_text'],
						'scheduleStatus' => $backup['scheduleStatus'],
						'started_ago' => $backup['started_ago'],
						);
						\MainWP_BackUp_WordPress::get_instance()->update_backupwp_schedule( $sch_id, $update, $websiteId );
					}
				}
				$update = array(
				'site_id' => $websiteId,
				'backups_path' => $information['backups_path'],
				);

				MainWP_BackUp_WordPress_DB::get_instance()->update_backupwp( $update );
				$information['backupslist_html'] = $this->get_backuplist_html_of_site( $websiteId );
			}

			if ( is_array( $information ) && isset( $information['error'] ) && ( ('Not found schedules.' == $information['error']) || ('notfounds_schedules' == $information['error']) ) ) {
				$information['error'] = __( 'No schedules found.', 'mainwp-backupwordpress-extension' );
			}

			die( json_encode( $information ) );
	}

	function get_backuplist_html_of_site( $websiteId ) {
		// Refresh the schedules from the database to make sure we have the latest changes
		MAINWP\BackUpWordPress\Schedules::get_instance()->refresh_schedules();
		$schedules = MAINWP\BackUpWordPress\Schedules::get_instance()->get_schedules();
		$backups_list_data = MainWP_BackUp_WordPress::get_instance()->get_individual_backup( $websiteId );

		ob_start();
		MainWP_BackUp_WordPress::gen_backupslist_html( $schedules, $backups_list_data, $websiteId );
		$backupslist = ob_get_clean();
		return $backupslist;
	}

	function ajax_delete_backups() {
		$this->ajax_check_data();
		$websiteId = $_POST['backupwpRequestSiteID'];

		if ( empty( $websiteId ) ) {
			die( json_encode( array( 'error' => 'Empty site id.' ) ) ); }

		$this->ajax_check_individual_action( $websiteId );

		$individual = isset( $_POST['individual'] ) && ! empty( $_POST['individual'] ) ? true : false;

		$sch_id = sanitize_text_field( $_REQUEST['scheduleId'] );

		global $mainWPBackUpWordPressExtensionActivator;

		$post_data = array(
		'mwp_action' => 'delete_backup',
			'schedule_id' => $sch_id,
			'hmbkp_backuparchive' => $_POST['hmbkp_encoded_file'],
		);

		$information = apply_filters( 'mainwp_fetchurlauthed', $mainWPBackUpWordPressExtensionActivator->get_child_file(), $mainWPBackUpWordPressExtensionActivator->get_child_key(), $websiteId, 'backup_wp', $post_data );

		if ( is_array( $information ) && isset( $information['result'] ) ) {
			$update = array(
			'backups_html' => $information['b'],
				'backups_count' => $information['count'],
				'lasttime_reload_backups' => time(),
				'file_size_text' => $information['file_size_text'],
				'scheduleStatus' => $information['scheduleStatus'],
			);
			\MainWP_BackUp_WordPress::get_instance()->update_backupwp_schedule( $sch_id, $update, $websiteId );
		}

		die( json_encode( $information ) );
	}

	function ajax_reload_excluded() {
		$this->ajax_check_data();

		$websiteId = $_POST['backupwpRequestSiteID'];

		$this->ajax_check_individual_action( $websiteId );

		$sch_id = $_REQUEST['scheduleId'];

		$individual = isset( $_POST['individual'] ) && ! empty( $_POST['individual'] ) ? true : false;

		if ( empty( $websiteId ) ) {
			die( json_encode( array( 'error' => 'Empty site id.' ) ) ); }

		if ( empty( $sch_id ) ) {
			die( json_encode( array( 'error' => 'Empty schedule id.' ) ) ); }

		global $mainWPBackUpWordPressExtensionActivator;

		$post_data = array(
		'mwp_action' => 'get_excluded',
			'schedule_id' => $sch_id,
		);

		$information = apply_filters( 'mainwp_fetchurlauthed', $mainWPBackUpWordPressExtensionActivator->get_child_file(), $mainWPBackUpWordPressExtensionActivator->get_child_key(), $websiteId, 'backup_wp', $post_data );

		if ( is_array( $information ) && isset( $information['e'] ) ) {
			if ( $individual ) {
				$update = array( 'excludes_html' => $information['e'], 'lasttime_reload_excluded' => time() );
				\MainWP_BackUp_WordPress::get_instance()->update_backupwp_schedule( $sch_id, $update, $websiteId );
			}
		}

		die( json_encode( $information ) );
	}

	function ajax_directory_browse() {
		$this->ajax_check_data();

		$websiteId = $_POST['backupwpRequestSiteID'];

		$this->ajax_check_individual_action( $websiteId );

		$sch_id = $_REQUEST['scheduleId'];

		$individual = isset( $_POST['individual'] ) && ! empty( $_POST['individual'] ) ? true : false;

		if ( empty( $websiteId ) ) {
			die( json_encode( array( 'error' => 'Empty site id.' ) ) ); }

		if ( empty( $sch_id ) ) {
			die( json_encode( array( 'error' => 'Empty schedule id.' ) ) ); }

		global $mainWPBackUpWordPressExtensionActivator;

		$post_data = array(
		'mwp_action' => 'directory_browse',
			'schedule_id' => $sch_id,
			'browse_dir' => $_POST['browse_dir'],
		);

		$information = apply_filters( 'mainwp_fetchurlauthed', $mainWPBackUpWordPressExtensionActivator->get_child_file(), $mainWPBackUpWordPressExtensionActivator->get_child_key(), $websiteId, 'backup_wp', $post_data );

		die( json_encode( $information ) );
	}

	function ajax_exclude_add_rule() {
		$this->ajax_check_data();

		$websiteId = $_POST['backupwpRequestSiteID'];

		$this->ajax_check_individual_action( $websiteId );

		$sch_id = $_REQUEST['scheduleId'];

		$individual = isset( $_POST['individual'] ) && ! empty( $_POST['individual'] ) ? true : false;

		if ( empty( $websiteId ) ) {
			die( json_encode( array( 'error' => 'Empty site id.' ) ) ); }

		if ( empty( $sch_id ) ) {
			die( json_encode( array( 'error' => 'Empty schedule id.' ) ) ); }

		global $mainWPBackUpWordPressExtensionActivator;

		$post_data = array(
		'mwp_action' => 'exclude_add_rule',
			'schedule_id' => $sch_id,
			'exclude_pathname' => $_POST['exclude_pathname'],
			'browse_dir' => $_POST['browse_dir'],
		);

		$information = apply_filters( 'mainwp_fetchurlauthed', $mainWPBackUpWordPressExtensionActivator->get_child_file(), $mainWPBackUpWordPressExtensionActivator->get_child_key(), $websiteId, 'backup_wp', $post_data );

		if ( is_array( $information ) && isset( $information['e'] ) ) {
			if ( $individual ) {
				$update = array( 'excludes_html' => $information['e'], 'lasttime_reload_excluded' => time() );
				\MainWP_BackUp_WordPress::get_instance()->update_backupwp_schedule( $sch_id, $update, $websiteId );
			}
		}

		die( json_encode( $information ) );
	}

	function ajax_remove_exclude_rule() {

		$this->ajax_check_data();

		$websiteId = $_POST['backupwpRequestSiteID'];

		$this->ajax_check_individual_action( $websiteId );

		$sch_id = $_REQUEST['scheduleId'];

		$individual = isset( $_POST['individual'] ) && ! empty( $_POST['individual'] ) ? true : false;

		if ( empty( $websiteId ) ) {
			die( json_encode( array( 'error' => 'Empty site id.' ) ) ); }

		if ( empty( $sch_id ) ) {
			die( json_encode( array( 'error' => 'Empty schedule id.' ) ) ); }

		global $mainWPBackUpWordPressExtensionActivator;

		$post_data = array(
            'mwp_action' => 'exclude_remove_rule',
			'schedule_id' => $sch_id,
			'remove_rule' => $_POST['remove_rule'],
			'browse_dir' => $_POST['browse_dir'],
		);

		$information = apply_filters( 'mainwp_fetchurlauthed', $mainWPBackUpWordPressExtensionActivator->get_child_file(), $mainWPBackUpWordPressExtensionActivator->get_child_key(), $websiteId, 'backup_wp', $post_data );

		if ( is_array( $information ) && isset( $information['e'] ) ) {
			if ( $individual ) {
				$update = array( 'excludes_html' => $information['e'], 'lasttime_reload_excluded' => time() );
				\MainWP_BackUp_WordPress::get_instance()->update_backupwp_schedule( $sch_id, $update, $websiteId );
			}
		}

		die( json_encode( $information ) );
	}


    function ajax_general_exclude_rules() {

		$this->ajax_check_data();
		$websiteId = $_POST['backupwpRequestSiteID'];
		$this->ajax_check_individual_action( $websiteId );
		$sch_id = $_REQUEST['scheduleId'];

		if ( empty( $websiteId ) ) {
			die( json_encode( array( 'error' => 'Empty site id.' ) ) ); }

		if ( empty( $sch_id ) ) {
			die( json_encode( array( 'error' => 'Empty schedule id.' ) ) ); }

		global $mainWPBackUpWordPressExtensionActivator;

        $schedule = \MainWP_BackUp_WordPress::get_instance()->get_backupwp_schedule( $sch_id, false, false );

		if ( empty( $schedule ) || ! is_array( $schedule ) || ! isset( $schedule['options'] ) || ! is_array( $schedule['options'] ) ) {
			die( json_encode( array( 'error' => 'Error schedule settings.' ) ) ); }

		// fix for new version of backupwordpress plugin
		$schedule_options = is_array($schedule['options']) ? $schedule['options'] : array();

		$post_data = array(
            'mwp_action' => 'general_exclude_add_rule',
			'schedule_id' => $sch_id,
			'exclude_paths' => isset($schedule_options['exclude_paths']) ? $schedule_options['exclude_paths'] : '',
            'un_exclude_paths' => isset($schedule_options['un_exclude_paths']) ? $schedule_options['un_exclude_paths'] : ''
		);

		$information = apply_filters( 'mainwp_fetchurlauthed', $mainWPBackUpWordPressExtensionActivator->get_child_file(), $mainWPBackUpWordPressExtensionActivator->get_child_key(), $websiteId, 'backup_wp', $post_data );
		die( json_encode( $information ) );

	}

}
