jQuery( document ).ready(function ($) {

	// Don't ever cache ajax requests
	$.ajaxSetup( {'cache': false} );

	if ($( 'select#mainwp_hmbkp_schedule_recurrence_type' ).size()) {

		mainwpHmbkpToggleScheduleFields( $( 'select#mainwp_hmbkp_schedule_recurrence_type' ).val() );

		$( document ).on('change', 'select#mainwp_hmbkp_schedule_recurrence_type', function () {
			mainwpHmbkpToggleScheduleFields( $( this ).val() );
		});

	}

	// Show delete confirm message for delete schedule
	$( document ).on('click', '.mwp-hmbkp-schedule-actions .delete-action', function (e) {

		if ( ! confirm( mainwp_hmbkp_loc.delete_schedule )) {
			e.preventDefault();
		}

	});

	// Show delete confirm message for delete backup
	$( document ).on('click', '.mainwp_hmbkp_manage_backups_row .delete-action', function (e) {

		if ( ! confirm( mainwp_hmbkp_loc.delete_backup )) {
			e.preventDefault();
		}

	});

	// Show delete confirm message for remove exclude rule
	$( document ).on('click', '.hmbkp-edit-schedule-excludes-form .delete-action', function (e) {

		if ( ! confirm( mainwp_hmbkp_loc.remove_exclude_rule )) {
			e.preventDefault();
		}

	});


	// Send the schedule id with the heartbeat
	$( document ).on('heartbeat-send', function (e, data) {


	});

	// Update schedule status on heartbeat tick
	$( document ).on('heartbeat-tick', function (e, data) {


	});

	// Closing ThickBox Modal Window
	$( document ).on('click', '.hmbkp-thickbox-close', function (e) {

		e.preventDefault();
		window.parent.tb_remove();

	});

});

function mainwpHmbkpToggleScheduleFields(recurrence) {

	recurrence = (typeof recurrence !== 'undefined') ? recurrence : 'manually';

	var settingFields = jQuery( '.recurring-setting' );
	var scheduleSettingFields = jQuery( '#schedule-start' );
	var twiceDailyNote = jQuery( 'p.twice-js' );

	switch (recurrence) {

		case 'manually':
			settingFields.hide();
			break;

		case 'hmbkp_hourly' :
			settingFields.hide();
			break;

		case 'hmbkp_daily' :
			settingFields.hide();
			scheduleSettingFields.show();
			twiceDailyNote.hide();
			break;

		case 'hmbkp_twicedaily' :
			settingFields.hide();
			scheduleSettingFields.show();
			twiceDailyNote.show();
			break;

		case 'hmbkp_weekly' : // fall through
		case 'hmbkp_fortnightly' :
			settingFields.hide();
			jQuery( '#start-day' ).show();
			scheduleSettingFields.show();
			twiceDailyNote.hide();
			break;

		case 'hmbkp_monthly' :
			settingFields.hide();
			scheduleSettingFields.show();
			jQuery( '#start-date' ).show();
			twiceDailyNote.hide();
			break;

	}

}

function mainwpHmbkpCatchResponseAndOfferToEmail(data) {

	// Backup Succeeded
	if ( ! data || data === 0) {
		location.reload( true );
	} // The backup failed, show the error and offer to have it emailed back
	else {

		jQuery( '.mwp-hmbkp-schedule-sentence.hmbkp-running' ).removeClass( 'hmbkp-running' ).addClass( 'hmbkp-error' );

		jQuery.post(
			ajaxurl,
			{'nonce': mainwp_hmbkp_loc.nonce, 'action': 'mainwp_hmbkp_backup_error', 'mainwp_hmbkp_error': data},
			function (data) {

				if ( ! data || data === 0) {
					return;
				} else {
					location.reload( true );
				}
			}
		);

	}

	jQuery( document ).one('click', '.mainwp_hmbkp_send_error_via_email', function (e) {

		e.preventDefault();

		jQuery( this ).addClass( 'hmbkp-ajax-loading' ).attr( 'disabled', 'disabled' );

		jQuery.post(
			ajaxurl,
			{'nonce': mainwp_hmbkp_loc.nonce, 'action': 'mainwp_hmbkp_email_error', 'mainwp_hmbkp_error': data},
			function () {
				//jQuery.colorbox.close();
			}
		);

	});

}
