<?php

/**
 * Delete the backup and then redirect back to the backups page
 */
function mainwp_hmbkp_request_delete_backup() {

	check_admin_referer( 'mainwp_hmbkp_delete_backup', 'mainwp_hmbkp_delete_backup_nonce' );

	$schedule = new MAINWP\BackUpWordPress\Scheduled_Backup( sanitize_text_field( urldecode( $_GET['mainwp_hmbkp_schedule_id'] ) ) );

	$deleted = $schedule->delete_backup( sanitize_text_field( base64_decode( $_GET['mainwp_hmbkp_backup_archive'] ) ) );

	if ( is_wp_error( $deleted ) ) {
		wp_die( $deleted->get_error_message() );
	}

	wp_safe_redirect( mainwp_hmbkp_get_settings_url(), 303 );

	die;
}

add_action( 'admin_post_mainwp_hmbkp_request_delete_backup', 'mainwp_hmbkp_request_delete_backup' );

/**
 * Enable support and then redirect back to the backups page
 */
function mainwp_hmbkp_request_enable_support() {

	//  check_admin_referer( 'mainwp_hmbkp_enable_support', 'mainwp_hmbkp_enable_support_nonce' );
	//
	//  update_option( 'mainwp_hmbkp_enable_support', true );
	//
	//  wp_safe_redirect( mainwp_hmbkp_get_settings_url(), 303 );
	//
	//  die;
}

//add_action( 'admin_post_mainwp_hmbkp_request_enable_support', 'mainwp_hmbkp_request_enable_support' );

/**
 * Delete a schedule and all it's backups and then redirect back to the backups page
 */
function mainwp_hmbkp_request_delete_schedule() {

	check_admin_referer( 'mainwp_hmbkp_delete_schedule', 'mainwp_hmbkp_delete_schedule_nonce' );

	$schedule = new MAINWP\BackUpWordPress\Scheduled_Backup( sanitize_text_field( urldecode( $_GET['mainwp_hmbkp_schedule_id'] ) ) );
	$schedule->cancel( true );

	wp_safe_redirect( mainwp_hmbkp_get_delete_schedule_url(), 303 );

	die;
}

add_action( 'admin_post_mainwp_hmbkp_request_delete_schedule', 'mainwp_hmbkp_request_delete_schedule' );


/**
 * Dismiss an error and then redirect back to the backups page
 */
function mainwp_hmbkp_dismiss_error() {

	check_admin_referer( 'mainwp_hmbkp_dismiss_error', 'mainwp_hmbkp_dismiss_error_nonce' );

	//  MAINWP\BackUpWordPress\Path::get_instance()->cleanup();

	MAINWP\BackUpWordPress\Notices::get_instance()->clear_all_notices();

	wp_safe_redirect( wp_get_referer(), 303 );

	die;
}

add_action( 'admin_post_mainwp_hmbkp_dismiss_error', 'mainwp_hmbkp_dismiss_error' );

/**
 * Catch the schedule service settings form submission
 *
 * Validate and either return errors or update the schedule
 */
function mainwp_hmbkp_edit_schedule_services_submit() {

	check_admin_referer( 'hmbkp-edit-schedule-services', 'hmbkp-edit-schedule-services-nonce' );

	if ( empty( $_POST['mainwp_hmbkp_schedule_id'] ) ) {
		wp_die( __( 'The schedule ID was not provided. Aborting.', 'mainwp-backupwordpress-extension' ) );
	}

	$schedule = new MAINWP\BackUpWordPress\Scheduled_Backup( sanitize_text_field( $_POST['mainwp_hmbkp_schedule_id'] ) );

	$errors = array();

	// Save the service options
	foreach ( MAINWP\BackUpWordPress\Services::get_services( $schedule ) as $service ) {
		$errors = array_merge( $errors, $service->save() );
	}

	$schedule->save();

	if ( $errors ) {
		foreach ( $errors as $error ) {
			mainwp_hmbkp_add_settings_error( $error );
		}
	}

	wp_safe_redirect( wp_get_referer(), '303' );
	die;
}

add_action( 'admin_post_mainwp_hmbkp_edit_schedule_services_submit', 'mainwp_hmbkp_edit_schedule_services_submit' );

/**
 * Catch the schedule settings form submission
 *
 * Validate and either return errors or update the schedule
 */
function mainwp_hmbkp_edit_schedule_submit() {

	check_admin_referer( 'mainwp-hmbkp-edit-schedule', 'mainwp-hmbkp-edit-schedule-nonce' );

	if ( empty( $_POST['mainwp_hmbkp_schedule_id'] ) ) {
		die;
	}

	$schedule = new MAINWP\BackUpWordPress\Scheduled_Backup( sanitize_text_field( $_POST['mainwp_hmbkp_schedule_id'] ) );

	$errors = array();

	$settings = array();

	if ( isset( $_POST['mainwp_hmbkp_schedule_type'] ) ) {

		$schedule_type = sanitize_text_field( $_POST['mainwp_hmbkp_schedule_type'] );

		if ( ! trim( $schedule_type ) ) {
			$errors['mainwp_hmbkp_schedule_type'] = __( 'Backup type cannot be empty', 'mainwp-backupwordpress-extension' );
		} elseif ( ! in_array( $schedule_type, array( 'complete', 'file', 'database' ) ) ) {
			$errors['mainwp_hmbkp_schedule_type'] = __( 'Invalid backup type', 'mainwp-backupwordpress-extension' );
		} else {
			$settings['type'] = $schedule_type;
		}
	}

	if ( isset( $_POST['mainwp_hmbkp_schedule_recurrence']['mainwp_hmbkp_type'] ) ) {

		$schedule_recurrence_type = sanitize_text_field( $_POST['mainwp_hmbkp_schedule_recurrence']['mainwp_hmbkp_type'] );

		if ( empty( $schedule_recurrence_type ) ) {
			$errors['mainwp_hmbkp_schedule_recurrence']['mainwp_hmbkp_type'] = __( 'Schedule cannot be empty', 'mainwp-backupwordpress-extension' );
		} elseif ( ! in_array( $schedule_recurrence_type, array_keys( mainwp_hmbkp_get_cron_schedules() ) ) && 'manually' !== $schedule_recurrence_type ) {
			$errors['mainwp_hmbkp_schedule_recurrence']['mainwp_hmbkp_type'] = __( 'Invalid schedule', 'mainwp-backupwordpress-extension' );
		} else {
			$settings['recurrence'] = $schedule_recurrence_type;
		}
	}

	if ( isset( $_POST['mainwp_hmbkp_schedule_recurrence']['mainwp_hmbkp_schedule_start_day_of_week'] ) ) {

		$day_of_week = sanitize_text_field( $_POST['mainwp_hmbkp_schedule_recurrence']['mainwp_hmbkp_schedule_start_day_of_week'] );

		if ( ! in_array( $day_of_week, array( 'monday', 'tuesday', 'wednesday', 'thursday', 'friday', 'saturday', 'sunday' ) ) ) {
			$errors['mainwp_hmbkp_schedule_start_day_of_week'] = __( 'Day of the week must be a valid lowercase day name', 'mainwp-backupwordpress-extension' );
		} else {
			$settings['start_time']['day_of_week'] = $day_of_week;
		}
	}

	if ( ( 'hmbkp_monthly' === $schedule_recurrence_type ) && isset( $_POST['mainwp_hmbkp_schedule_recurrence']['mainwp_hmbkp_schedule_start_day_of_month'] ) ) {

		$day_of_month = absint( $_POST['mainwp_hmbkp_schedule_recurrence']['mainwp_hmbkp_schedule_start_day_of_month'] );

		$options = array(
			'min_range' => 1,
			'max_range' => 31,
		);

		if ( false === filter_var( $day_of_month, FILTER_VALIDATE_INT, array( 'options' => $options ) ) ) {
			$errors['mainwp_hmbkp_schedule_start_day_of_month'] = __( 'Day of month must be between 1 and 31', 'mainwp-backupwordpress-extension' );
		} else {
			$settings['start_time']['day_of_month'] = $day_of_month;
		}
	}

	if ( isset( $_POST['mainwp_hmbkp_schedule_recurrence']['mainwp_hmbkp_schedule_start_hours'] ) ) {

		$hours = absint( $_POST['mainwp_hmbkp_schedule_recurrence']['mainwp_hmbkp_schedule_start_hours'] );

		$options = array(
			'min_range' => 0,
			'max_range' => 23,
		);

		if ( false === filter_var( $hours, FILTER_VALIDATE_INT, array( 'options' => $options ) ) ) {
			$errors['mainwp_hmbkp_schedule_start_hours'] = __( 'Hours must be between 0 and 23', 'mainwp-backupwordpress-extension' );
		} else {
			$settings['start_time']['hours'] = $hours;
		}
	}

	if ( isset( $_POST['mainwp_hmbkp_schedule_recurrence']['mainwp_hmbkp_schedule_start_minutes'] ) ) {

		$minutes = absint( $_POST['mainwp_hmbkp_schedule_recurrence']['mainwp_hmbkp_schedule_start_minutes'] );

		$options = array(
			'min_range' => 0,
			'max_range' => 59,
		);

		if ( false === filter_var( $minutes, FILTER_VALIDATE_INT, array( 'options' => $options ) ) ) {
			$errors['mainwp_hmbkp_schedule_start_minutes'] = __( 'Minutes must be between 0 and 59', 'mainwp-backupwordpress-extension' );
		} else {
			$settings['start_time']['minutes'] = $minutes;
		}
	}

	if ( isset( $_POST['mainwp_hmbkp_schedule_max_backups'] ) ) {

		$max_backups = sanitize_text_field( $_POST['mainwp_hmbkp_schedule_max_backups'] );

		if ( empty( $max_backups ) ) {
			$errors['mainwp_hmbkp_schedule_max_backups'] = __( 'Max backups can\'t be empty', 'mainwp-backupwordpress-extension' );
		} elseif ( ! is_numeric( $max_backups ) ) {
			$errors['mainwp_hmbkp_schedule_max_backups'] = __( 'Max backups must be a number', 'mainwp-backupwordpress-extension' );
		} elseif ( ! ( $max_backups >= 1 ) ) {
			$errors['mainwp_hmbkp_schedule_max_backups'] = __( 'Max backups must be greater than 0', 'mainwp-backupwordpress-extension' );
		} else {
			$settings['max_backups'] = absint( $max_backups );
		}
	}

	// Save the service options
	foreach ( MAINWP\BackUpWordPress\Services::get_services( $schedule ) as $service ) {
		$errors = array_merge( $errors, $service->save() );
	}

	if ( ! empty( $settings['recurrence'] ) && ! empty( $settings['start_time'] ) ) {

		// Calculate the start time depending on the recurrence
		$start_time = mainwp_hmbkp_determine_start_time( $settings['recurrence'], $settings['start_time'] );

		if ( $start_time ) {
			$schedule->set_schedule_start_time( $start_time );
		}
	}

	if ( ! empty( $settings['recurrence'] ) ) {
		$schedule->set_reoccurrence( $settings['recurrence'] );
	}

	if ( ! empty( $settings['type'] ) ) {
		$schedule->set_type( $settings['type'] );
	}

	if ( ! empty( $settings['max_backups'] ) ) {
		$schedule->set_max_backups( $settings['max_backups'] );
	}

	// Save the new settings
	$schedule->save();

	// Remove any old backups in-case max backups was reduced
	//  $schedule->delete_old_backups();

	if ( $errors ) {

		foreach ( $errors as $error ) {
			mainwp_hmbkp_add_settings_error( $error );
		}
	}
	$redirect = mainwp_hmbkp_get_update_schedule_url();
	if ( $errors ) {
		$redirect = wp_get_referer();
	}

	wp_safe_redirect( $redirect, '303' );
	die;
}

add_action( 'admin_post_mainwp_hmbkp_edit_schedule_submit', 'mainwp_hmbkp_edit_schedule_submit' );


function mainwp_hmbkp_edit_schedule_excluded_submit() {
	check_admin_referer( 'mainwp-hmbkp-edit-schedule-excluded', 'mainwp-hmbkp-edit-schedule-excluded-nonce' );
    $schedule = new MAINWP\BackUpWordPress\Scheduled_Backup( sanitize_text_field( $_POST['mainwp_hmbkp_schedule_id'] ) );

	if ( isset( $_POST['mainwp_hmbkp_schedule_excluded'] ) ) {
        $schedule->set_option( 'exclude_paths', $_POST['mainwp_hmbkp_schedule_excluded'] );
	}

    if ( isset( $_POST['mainwp_hmbkp_schedule_un_excluded'] ) ) {
        $schedule->set_option( 'un_exclude_paths', $_POST['mainwp_hmbkp_schedule_un_excluded'] );
	}

	// Save the new settings
	$schedule->save();

	$redirect = mainwp_hmbkp_get_update_schedule_excluded_url();

	wp_safe_redirect( $redirect, '303' );
	die;
}

add_action( 'admin_post_mainwp_hmbkp_edit_schedule_excluded_submit', 'mainwp_hmbkp_edit_schedule_excluded_submit' );

/**
 * Add an exclude rule
 *
 * @access public
 * @return void
 */
function mainwp_hmbkp_add_exclude_rule() {

	//  check_admin_referer( 'hmbkp-add-exclude-rule', 'hmbkp-add-exclude-rule-nonce' );
	//
	//  if ( ! isset( $_GET['mainwp_hmbkp_exclude_pathname'] ) ) {
	//      return;
	//  }
	//
	//  $schedule = new MAINWP\BackUpWordPress\Scheduled_Backup( sanitize_text_field( $_GET['mainwp_hmbkp_schedule_id'] ) );
	//
	//  $exclude_rule = sanitize_text_field( $_GET['mainwp_hmbkp_exclude_pathname'] );
	//
	//  $schedule->set_excludes( $exclude_rule, true );
	//
	//  $schedule->save();
	//
	//  wp_safe_redirect( wp_get_referer(), '303' );
	//
	//  die;
}

//add_action( 'admin_post_mainwp_hmbkp_add_exclude_rule', 'mainwp_hmbkp_add_exclude_rule' );

/**
 * Delete an exclude rule
 *
 * @access public
 * @return void
 */
function mainwp_hmbkp_remove_exclude_rule() {

	//  check_admin_referer( 'mainwp_hmbkp_remove_exclude_rule', 'hmbkp-remove_exclude_rule_nonce' );
	//
	//  if ( ! isset( $_GET['mainwp_hmbkp_remove_exclude'] ) ) {
	//      die;
	//  }
	//
	//  $schedule = new MAINWP\BackUpWordPress\Scheduled_Backup( sanitize_text_field( $_GET['mainwp_hmbkp_schedule_id'] ) );
	//
	//  $excludes = $schedule->get_excludes();
	//
	//  $schedule->set_excludes( array_diff( $excludes, (array) stripslashes( sanitize_text_field( $_GET['mainwp_hmbkp_remove_exclude'] ) ) ) );
	//
	//  $schedule->save();
	//
	//  wp_safe_redirect( wp_get_referer(), '303' );
	//
	//  die;
}

//add_action( 'admin_post_mainwp_hmbkp_remove_exclude_rule', 'mainwp_hmbkp_remove_exclude_rule' );


function mainwp_hmbkp_calculate_site_size() {

	//  if ( isset( $_GET['mainwp_hmbkp_schedule_id'] ) ) {
	//
	//      $current_schedule = new MAINWP\BackUpWordPress\Scheduled_Backup( sanitize_text_field( $_GET['mainwp_hmbkp_schedule_id'] ) );
	//
	//  } else {
	//
	//      // Refresh the schedules from the database to make sure we have the latest changes
	//      MAINWP\BackUpWordPress\Schedules::get_instance()->refresh_schedules();
	//
	//      $schedules = MAINWP\BackUpWordPress\Schedules::get_instance()->get_schedules();
	//
	//      $current_schedule = reset( $schedules );
	//
	//  }
	//  if ( ! $current_schedule->is_site_size_cached() ) {
	//      $root = new SplFileInfo( $current_schedule->backup->get_root() );
	//      $current_schedule->filesize( $root );
	//  }
}

//add_action( 'load-' . MAINWP_HMBKP_ADMIN_PAGE, 'mainwp_hmbkp_calculate_site_size' );

/**
 * Receive the heartbeat and return backup status
 */
function mainwp_hmbkp_heartbeat_received( $response, $data ) {

	//  $response['heartbeat_interval'] = 'fast';

	if ( ! empty( $data['mainwp_hmbkp_schedule_id'] ) ) {

		$schedule = new MAINWP\BackUpWordPress\Scheduled_Backup( sanitize_text_field( urldecode( $data['mainwp_hmbkp_schedule_id'] ) ) );


		if ( ! empty( $data['mainwp_hmbkp_client_request'] ) ) {

		}
	}
	return $response;
}

//add_filter( 'heartbeat_received', 'mainwp_hmbkp_heartbeat_received', 10, 2 );
// TODO needs work
function mainwp_hmbkp_display_error_and_offer_to_email_it() {

	check_ajax_referer( 'mainwp_hmbkp_nonce', 'nonce' );

	if ( empty( $_POST['mainwp_hmbkp_error'] ) ) {
		die;
	}

	//  $errors = explode( "\n", wp_strip_all_tags( stripslashes( $_POST['mainwp_hmbkp_error'] ) ) );
	//
	//  MAINWP\BackUpWordPress\Notices::get_instance()->set_notices( 'backup_errors', $errors );

	wp_send_json_success( wp_get_referer() );
}

add_action( 'wp_ajax_mainwp_hmbkp_backup_error', 'mainwp_hmbkp_display_error_and_offer_to_email_it' );

// TODO needs work
function mainwp_hmbkp_send_error_via_email() {

	check_ajax_referer( 'mainwp_hmbkp_nonce', 'nonce' );

	if ( empty( $_POST['mainwp_hmbkp_error'] ) ) {
		die;
	}

	$error = wp_strip_all_tags( $_POST['mainwp_hmbkp_error'] );

	wp_mail( 'support@humanmade.co.uk', 'BackUpWordPress Fatal error on ' . parse_url( home_url(), PHP_URL_HOST ), $error, 'From: BackUpWordPress <' . get_bloginfo( 'admin_email' ) . '>' . "\r\n" );

	die;
}

add_action( 'wp_ajax_mainwp_hmbkp_email_error', 'mainwp_hmbkp_send_error_via_email' );

/**
 * Load the enable support modal contents
 *
 * @return void
 */
function mainwp_hmbkp_load_enable_support() {

	check_ajax_referer( 'mainwp_hmbkp_nonce', '_wpnonce' );

	require_once MAINWP_HMBKP_PLUGIN_PATH . 'admin/enable-support.php';

	die;
}

add_action( 'wp_ajax_load_enable_support', 'mainwp_hmbkp_load_enable_support' );

/**
 * Display the running status via ajax
 */
function mainwp_hmbkp_ajax_is_backup_in_progress() {

	
}


/**
 * Display the calculated size via ajax
 */
function mainwp_hmbkp_ajax_calculate_backup_size() {

	check_ajax_referer( 'mainwp_hmbkp_nonce', 'nonce' );

	if ( empty( $_POST['mainwp_hmbkp_schedule_id'] ) ) {
		die;
	}

	$schedule = new MAINWP\BackUpWordPress\Scheduled_Backup( sanitize_text_field( urldecode( $_POST['mainwp_hmbkp_schedule_id'] ) ) );

	$recalculate_filesize = true;

	//require( MAINWP_HMBKP_PLUGIN_PATH . 'admin/schedule-sentence.php' );

	die;
}

add_action( 'wp_ajax_mainwp_hmbkp_calculate', 'mainwp_hmbkp_ajax_calculate_backup_size' );

/**
 * Test the cron response and if it's not 200 show a warning message
 */
function mainwp_hmbkp_ajax_cron_test() {

}

//add_action( 'wp_ajax_mainwp_hmbkp_cron_test', 'mainwp_hmbkp_ajax_cron_test' );

function mainwp_hmbkp_add_meta_box() {
	add_meta_box(
		'mainwp_hmbkp_metabox_schedule_settings', __( 'Schedule Settings', 'mainwp-backupwordpress-extension' ), array( 'MainWP_BackUp_WordPress', 'gen_metabox_schedule_settings' ), 'mainwp_hmbkp_page_schedule_settings', 'advanced', 'core'
	);

	add_meta_box(
		'mainwp_hmbkp_metabox_schedule_excluded', __( 'Currently Excluded ', 'mainwp-backupwordpress-extension' ), array( 'MainWP_BackUp_WordPress', 'gen_metabox_schedule_excluded' ), 'mainwp_hmbkp_page_schedule_excluded', 'advanced', 'core'
	);

	//    wp_enqueue_script( 'postbox' );
}

add_action( 'load-' . MAINWP_HMBKP_ADMIN_PAGE, 'mainwp_hmbkp_add_meta_box' );
