<?php
/**
 * Uptime Robot Stats
 *
 * Renders Stats table content when Uptime Robot service is selected.
 *
 * @package MainWP/Extensions/AUM
 */

namespace MainWP\Extensions\AUM;

?>
<table class="ui single line table">
<thead>
<tr>
<th><?php esc_html_e( 'Monitor', 'advanced-uptime-monitor-extension' ); ?></th>
<th><?php esc_html_e( 'URL', 'advanced-uptime-monitor-extension' ); ?></th>
<th><?php esc_html_e( 'Type', 'advanced-uptime-monitor-extension' ); ?></th>
<th><?php esc_html_e( 'Status', 'advanced-uptime-monitor-extension' ); ?></th>
</tr>
</thead>
<tbody>
<tr>
<td><?php echo $url->url_name; ?></td>
<td><a href="<?php echo $url->url_address; ?>" target="_blank" rel="noopener noreferrer"><?php echo $url->url_address; ?></a></td>
<td><?php echo MainWP_AUM_UptimeRobot_Controller::get_monitor_types( $url->monitor_type ); ?></td>
<td>
<?php
$last_status = isset( $stats[0] ) ? $stats[0] : null;

if ( ! is_object( $last_status ) ) {
	echo esc_html__( 'Unknown', 'advanced-uptime-monitor-extension' );
} elseif ( isset( $last_status->monitor_type ) && '-1' === (string) $last_status->monitor_type ) {
	$status_type = isset( $last_status->type ) ? $last_status->type : null;
	if ( isset( $status_type ) && isset( $event_statuses[ $status_type ] ) ) {
		echo esc_html( ucfirst( $event_statuses[ $status_type ] ) );
	} else {
		echo esc_html__( 'Unknown', 'advanced-uptime-monitor-extension' );
	}
} else {
	$monitor_type = isset( $last_status->monitor_type ) ? (string) $last_status->monitor_type : '';
	switch ( $monitor_type ) {
		case '0':
			echo esc_html__( 'Paused', 'advanced-uptime-monitor-extension' );
			break;
		case '1':
			echo esc_html__( 'Started', 'advanced-uptime-monitor-extension' );
			break;
		default:
			echo esc_html__( 'Unknown', 'advanced-uptime-monitor-extension' );
			break;
	}
}
?>
</td>
</tr>
</tbody>
</table>
<?php
$api_timezone = MainWP_AUM_UptimeRobot_API::instance()->get_option( 'api_timezone', false );
$offset_time  = 0;
if ( is_array( $api_timezone ) && isset( $api_timezone['offset_time'] ) ) {
	$offset_time = $api_timezone['offset_time'];
	$offset_time = $offset_time * 60 * 60;
}
if ( ! empty( $stats ) ) {
	?>
<table class="ui single line table">
<thead>
<tr>
<th><?php esc_html_e( 'Status', 'advanced-uptime-monitor-extension' ); ?></th>
<th><?php esc_html_e( 'Details', 'advanced-uptime-monitor-extension' ); ?></th>
<th><?php esc_html_e( 'Date / Time', 'advanced-uptime-monitor-extension' ); ?></th>
<th><?php esc_html_e( 'Duration', 'advanced-uptime-monitor-extension' ); ?></th>
</tr>
</thead>
<tbody>
	<?php
	foreach ( $stats as $event ) {
		$type   = $event->type;
		$status = ucfirst( $event_statuses[ $type ] );
		?>
<tr>
<td class="<?php echo strtolower( $status ); ?>">
		<?php
		switch ( $status ) {
			case 'Started':
				echo esc_html__( 'Started', 'advanced-uptime-monitor-extension' );
				break;
			case 'Up':
				echo esc_html__( 'Up', 'advanced-uptime-monitor-extension' );
				break;
			case 'Paused':
				echo esc_html__( 'Paused', 'advanced-uptime-monitor-extension' );
				break;
			case 'Down':
				echo esc_html__( 'Down', 'advanced-uptime-monitor-extension' );
				break;
		}
		?>
</td>
<td>
		<?php
		switch ( $status ) {
			case 'Started':
				echo esc_html__( 'The monitor is started manually', 'advanced-uptime-monitor-extension' );
				break;
			case 'Up':
				echo esc_html__( 'Successful response received.', 'advanced-uptime-monitor-extension' );
				break;
			case 'Paused':
				echo esc_html__( 'The monitor is paused manually', 'advanced-uptime-monitor-extension' );
				break;
			case 'Down':
				if ( $url->monitor_type == '2' ) {
					echo esc_html__( 'The keyword exists.', 'advanced-uptime-monitor-extension' );
				} else {
					echo esc_html__( 'No Response From The Website.', 'advanced-uptime-monitor-extension' );
				}
				break;
		}
		?>
</td>
<td>
		<?php
		$datetime = strtotime( $event->event_datetime_gmt ) + $offset_time;
		$datetime = MainWP_AUM_Main::format_timestamp( $datetime );
		echo $datetime;
		?>
</td>
<td>
		<?php
		$duration = $event->duration;
		$hrs      = floor( $duration / 3600 );
		$mins     = floor( ( $duration - $hrs * 3600 ) / 60 );
		echo $hrs . ' hrs, ' . $mins . ' mins';
		?>
</td>
</tr>
	<?php } ?>
</tbody>
</table>
	<?php
}
