<?php

/**
 * 	Function used by or with SendPress
 */
// Prevent loading this file directly
if ( !defined('SENDPRESS_VERSION') ) {
	header('HTTP/1.0 403 Forbidden');
	die;
} ?>// Generated by the SendPress Plugin //

Multisite:                <?php echo is_multisite() ? 'Yes' . "\n" : 'No' . "\n" ?>

SITE_URL:                 <?php echo site_url() . "\n"; ?>
HOME_URL:                 <?php echo home_url() . "\n"; ?>

WordPress Version:        <?php echo get_bloginfo( 'version' ) . "\n"; ?>
Permalink Structure:      <?php echo get_option( 'permalink_structure' ) . "\n"; ?>
Active Theme:             <?php echo $theme . "\n"; ?>
<?php if( $host ) : ?>
Host:                     <?php echo $host . "\n"; ?>
<?php endif; ?>

Registered Post Stati:    <?php echo implode( ', ', get_post_stati() ) . "\n\n"; ?>
<?php if (  SPNL()->validate->_isset('system_info' ) ) {
	echo '// Browser of Current Viewer //';
	echo "\r\n\r\n";
} ?>
<?php echo $browser ; ?>
<?php if (  SPNL()->validate->_isset('system_info' ) ) {
	echo "\r\n";
	echo '// End Browser of Current Viewer //';
	echo "\r\n\r\n";
} ?>

Send Setup: <?php echo SendPress_Option::get( 'sendmethod' ) . "\n"; ?>
SP Version:               <?php echo SENDPRESS_VERSION . "\n"; ?>
<?php if(defined('SENDPRESS_PRO_VERSION')){ ?>SP Pro Version: 	  <?php echo SENDPRESS_PRO_VERSION . "\n"; ?><?php	} ?>

PHP Version:              <?php echo PHP_VERSION . "\n"; ?>
<?php
	$host= spnl_get_host();
// Can we determine the site's host?
	if( $host ) {
		$return ='';
		$return .= 'Host:                     ' . $host . "\n";
		echo $return;
	}
?>
MySQL Version:            <?php echo $wpdb->db_version() . "\n"; ?>
Web Server Info:          <?php echo $_SERVER['SERVER_SOFTWARE'] . "\n"; ?>

WordPress Memory Limit:   <?php echo ( self::let_to_num( WP_MEMORY_LIMIT )/( 1024 ) )."MB"; ?><?php echo "\n"; ?>
PHP Memory Limit:         <?php echo ini_get( 'memory_limit' ) . "\n"; ?>
PHP Upload Max Size:      <?php echo ini_get( 'upload_max_filesize' ) . "\n"; ?>
PHP Post Max Size:        <?php echo ini_get( 'post_max_size' ) . "\n"; ?>
PHP Upload Max Filesize:  <?php echo ini_get( 'upload_max_filesize' ) . "\n"; ?>
PHP Time Limit:           <?php echo ini_get( 'max_execution_time' ) . "\n"; ?>
PHP Max Input Vars:       <?php echo ini_get( 'max_input_vars' ) . "\n"; ?>
PHP Arg Separator:        <?php echo ini_get( 'arg_separator.output' ) . "\n"; ?>
PHP Allow URL File Open:  <?php echo ini_get( 'allow_url_fopen' ) ? "Yes" : "No\n"; ?>

WP_DEBUG:                 <?php echo defined( 'WP_DEBUG' ) ? WP_DEBUG ? 'Enabled' . "\n" : 'Disabled' . "\n" : 'Not set' . "\n" ?>

WP Table Prefix:          <?php echo 'Length: ' . strlen( $wpdb->prefix ); echo ' Status:'; if ( strlen( $wpdb->prefix ) >16 ) { echo ' ERROR: Too Long'; } else { echo ' Acceptable'; } echo "\n"; ?>

Show On Front:            <?php echo get_option( 'show_on_front' ) . "\n" ?>
Page On Front:            <?php $id = get_option( 'page_on_front' ); echo get_the_title( $id ) . ' (#' . $id . ')' . "\n" ?>
Page For Posts:           <?php $id = get_option( 'page_for_posts' ); echo get_the_title( $id ) . ' (#' . $id . ')' . "\n" ?>

WP Remote Post:           <?php echo $WP_REMOTE_POST; ?>

Session:                  <?php echo isset( $_SESSION ) ? 'Enabled' : 'Disabled'; ?><?php echo "\n"; ?>
Session Name:             <?php echo esc_html( ini_get( 'session.name' ) ); ?><?php echo "\n"; ?>
Cookie Path:              <?php echo esc_html( ini_get( 'session.cookie_path' ) ); ?><?php echo "\n"; ?>
Save Path:                <?php echo esc_html( ini_get( 'session.save_path' ) ); ?><?php echo "\n"; ?>
Use Cookies:              <?php echo ini_get( 'session.use_cookies' ) ? 'On' : 'Off'; ?><?php echo "\n"; ?>
Use Only Cookies:         <?php echo ini_get( 'session.use_only_cookies' ) ? 'On' : 'Off'; ?><?php echo "\n"; ?>

DISPLAY ERRORS:           <?php echo ( ini_get( 'display_errors' ) ) ? 'On (' . ini_get( 'display_errors' ) . ')' : 'N/A'; ?><?php echo "\n"; ?>
FSOCKOPEN:                <?php echo ( function_exists( 'fsockopen' ) ) ? 'Your server supports fsockopen.' : 'Your server does not support fsockopen.'; ?><?php echo "\n"; ?>
cURL:                     <?php echo ( function_exists( 'curl_init' ) ) ? 'Your server supports cURL.' : 'Your server does not support cURL.'; ?><?php echo "\n"; ?>
SOAP Client:              <?php echo ( class_exists( 'SoapClient' ) ) ? 'Your server has the SOAP Client enabled.' : 'Your server does not have the SOAP Client enabled.'; ?><?php echo "\n"; ?>
SUHOSIN:                  <?php echo ( extension_loaded( 'suhosin' ) ) ? 'Your server has SUHOSIN installed.' : 'Your server does not have SUHOSIN installed.'; ?><?php echo "\n"; ?>



ACTIVE PLUGINS:

<?php $plugins = get_plugins();
$active_plugins = get_option( 'active_plugins', array() );

foreach ( $plugins as $plugin_path => $plugin ) {
	// If the plugin isn't active, don't show it.
	if ( ! in_array( $plugin_path, $active_plugins ) )
		continue;

	echo $plugin['Name'] . ': ' . $plugin['Version'] ."\n";
}

if ( is_multisite() ) : ?>

NETWORK ACTIVE PLUGINS:

	<?php $plugins  = wp_get_active_network_plugins();
	$active_plugins = get_site_option( 'active_sitewide_plugins', array() );

	foreach ( $plugins as $plugin_path ) {
		$plugin_base = plugin_basename( $plugin_path );

		// If the plugin isn't active, don't show it.
		if ( ! array_key_exists( $plugin_base, $active_plugins ) )
			continue;

		$plugin = get_plugin_data( $plugin_path );

echo $plugin['Name'] . ' :' . $plugin['Version'] ."\n";
	}
endif;

if ( has_action( 'ssi_extra_info' ) ) {
	echo "\n";
	do_action( 'ssi_extra_info' );
}


function spnl_get_host() { 
    $host = false; 
 
    if( defined( 'WPE_APIKEY' ) ) { 
        $host = 'WP Engine'; 
    } elseif( defined( 'PAGELYBIN' ) ) { 
        $host = 'Pagely'; 
    } elseif( DB_HOST == 'localhost:/tmp/mysql5.sock' ) { 
        $host = 'ICDSoft'; 
    } elseif( DB_HOST == 'mysqlv5' ) { 
        $host = 'NetworkSolutions'; 
    } elseif( strpos( DB_HOST, 'ipagemysql.com' ) !== false ) { 
        $host = 'iPage'; 
    } elseif( strpos( DB_HOST, 'ipowermysql.com' ) !== false ) { 
        $host = 'IPower'; 
    } elseif( strpos( DB_HOST, '.gridserver.com' ) !== false ) { 
        $host = 'MediaTemple Grid'; 
    } elseif( strpos( DB_HOST, '.pair.com' ) !== false ) { 
        $host = 'pair Networks'; 
    } elseif( strpos( DB_HOST, '.stabletransit.com' ) !== false ) { 
        $host = 'Rackspace Cloud'; 
    } elseif( strpos( DB_HOST, '.sysfix.eu' ) !== false ) { 
        $host = 'SysFix.eu Power Hosting'; 
    } elseif( strpos( $_SERVER['SERVER_NAME'], 'Flywheel' ) !== false ) { 
        $host = 'Flywheel'; 
    } else { 
        // Adding a general fallback for data gathering 
        $host = 'DBH: ' . DB_HOST . ', SRV: ' . $_SERVER['SERVER_NAME']; 
    } 
 
    return $host; 
} 