<?php

/**
 * ======================================================================
 * LICENSE: This file is subject to the terms and conditions defined in *
 * file 'license.txt', which is part of this source code package.       *
 * ======================================================================
 */

/**
 * Access Level types
 *
 * @package AAM
 * @version 7.0.0
 */
class AAM_Framework_Type_AccessLevel
{

    /**
     * Role access level
     *
     * @version 7.0.0
     */
    const ROLE = 'role';

    /**
     * User access level
     *
     * @version 7.0.0
     */
    const USER = 'user';

    /**
     * Default access level
     *
     * @version 7.0.0
     */
    const DEFAULT = 'default';

    /**
     * Alias for the default access level
     *
     * @version 7.0.0
     */
    const ALL = 'default';

    /**
     * Alias for the default access level
     *
     * @version 7.0.0
     */
    const ANYONE = 'default';

    /**
     * Alias for the default access level
     *
     * @version 7.0.0
     */
    const EVERYONE = 'default';

    /**
     * Visitor access level
     *
     * @version 7.0.0
     */
    const VISITOR   = 'visitor';

    /**
     * Alias for the visitor access level
     *
     * @version 7.0.0
     */
    const GUEST     = 'visitor';

    /**
     * Alias for the visitor access level
     *
     * @version 7.0.0
     */
    const ANONYMOUS = 'visitor';

}