<?php
namespace EAddonsProFormActions\Modules\Actions\Shortcodes;

use EAddonsForElementor\Base\Base_Shortcode;
use EAddonsForElementor\Modules\Template;
use EAddonsForElementor\Core\Utils\Form;

/**
 * Description of template
 *
 * @author fra
 */
class Submissions extends Base_Shortcode {
        
    public function get_name() {
        return 'e_submissions';
    }
    
    public function get_title() {
        return 'Submissions Counter';
    }
    
    
    public function get_pid() {
        return 24300;
    }
        
    public function get_icon() {
        return 'eadd-submission-counter';
    }
        
    /**
     * Execute the Shortcode
     *
     * @since 1.0.0
     *
     * @access public
     */
    public function do_shortcode($atts) {
        $atts = shortcode_atts(
                array(
                    'id' => '',
                    'post_id' => '',
                    'user_id' => '',
                    'is_read' => '',
                    'status' => '',
                    'plus' => 0,
                ),
                $atts,
                $this->get_name()
        );
        
        if ($atts['id'] == 'auto') {
            $atts['id'] = Form::get_form_id();
        }
        
        if ($atts['post_id'] == 'auto') {
            $atts['post_id'] = get_the_ID();
        }
        
        if ($atts['user_id'] == 'auto') {
            $atts['user_id'] = get_current_user_id();
        }
        
        global $wpdb;
        $sql = 'SELECT COUNT(*) FROM `'.$wpdb->prefix . 'e_submissions`';
        if ($atts['id'] || $atts['post_id'] || $atts['is_read'] != '') {
            $sql .= " WHERE `type` = 'submission'";
            if ($atts['id']) {
                $sql .= " AND `element_id` = '".$atts['id']."'";
            }
            if ($atts['post_id']) {
                $sql .= " AND `post_id` = '".$atts['post_id']."'";
            }
            if ($atts['user_id']) {
                $sql .= " AND `user_id` = '".$atts['user_id']."'";
            }
            if ($atts['is_read'] != '') {
                $sql .= " AND `is_read` = '".$atts['is_read']."'";
            }
            if ($atts['status'] != '') {
                $sql .= " AND `status` = '".$atts['status']."'";
            }
        }
        $sub_count = $wpdb->get_var($sql);
        if (!empty($atts['plus'])) {
            $sub_count += intval($atts['plus']);
        }
        return $sub_count;
    }
    
}
