<?php

namespace EAddonsProFormActions\Modules\Actions\Actions;

use EAddonsForElementor\Base\Base_Action;
use Elementor\Controls_Manager;
use EAddonsForElementor\Core\Utils;
use EAddonsForElementor\Core\Utils\Form;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

class Term extends Base_Action {
    
    public $term = [];
    
    public function __construct() {
        parent::__construct();

        add_action("elementor/widget/render_content", [$this, 'render_content'], 10, 2);        
    }

    /**
     * Get Name
     *
     * Return the action name
     *
     * @access public
     * @return string
     */
    public function get_name() {
        return 'term';
    }

    public function get_icon() {
        return 'eadd-el-form-pro-act-save-terms';
    }

    /**
     * Get Label
     *
     * Returns the action label
     *
     * @access public
     * @return string
     */
    public function get_label() {
        return esc_html__('Add Term', 'e-addons');
    }

    public function get_pid() {
        return 10857;
    }

    /**
     * Register Settings Section
     *
     * Registers the Action controls
     *
     * @access public
     * @param \Elementor\Widget_Base $widget
     */
    public function register_settings_section($widget) {

        $taxonomies = Utils::get_taxonomies();

        $this->start_controls_section($widget);

        $widget->add_control(
                'e_form_save_term_override', [
            'label' => esc_html__('Add or Update', 'e-addons'),
            'type' => Controls_Manager::CHOOSE,
            'options' => [
                'add' => [
                    'title' => esc_html__('Add', 'e-addons'),
                    'icon' => 'eicon-plus',
                ],
                'update' => [
                    'title' => esc_html__('Update', 'e-addons'),
                    'icon' => 'eicon-sync',
                ],
            ],
            'default' => 'add',
            'toggle' => false,
            'description' => esc_html__('Updated data of current object or create a new one', 'e-addons'),
                ]
        );

        $widget->add_control(
                'e_form_save_type_term_term', [
            'label' => esc_html__('Find Term to update', 'e-addons'),
            'type' => 'e-query',
            'placeholder' => esc_html__('Find a Term', 'e-addons'),
            'label_block' => true,
            'query_type' => 'terms',
            'description' => esc_html__('Search Term or leave empty for Current Term.', 'e-addons'),
            'condition' => [
                'e_form_save_term_override' => 'update',
            ],
                ]
        );

        $widget->add_control(
                'e_form_save_type_term_heading', [
            'label' => esc_html__('Term', 'e-addons'),
            'type' => Controls_Manager::HEADING,
            'separator' => 'before',
        ]);
        $widget->add_control(
                'e_form_save_type_term_name', [
            'label' => esc_html__('Term Name', 'e-addons'),
            'type' => Controls_Manager::TEXT,
            'default' => '[field id="name"]',
            'description' => esc_html__('Can use static text, field Shortcode, Token or mixed', 'e-addons') . '<br>' . esc_html__('or leave empty for rand value', 'e-addons'),
            'label_block' => 'true',
                ]
        );
        $widget->add_control(
                'e_form_save_type_term_description', [
            'label' => esc_html__('Term Description', 'e-addons'),
            'type' => Controls_Manager::WYSIWYG,
            'default' => '[field id="message"]',
            'description' => esc_html__('Can use static text, field Shortcode, Token or mixed', 'e-addons'),
            'label_block' => 'true',
                ]
        );
        $widget->add_control(
                'e_form_save_type_term_taxonomy', [
            'label' => esc_html__('Term Taxonomy', 'e-addons'),
            'type' => 'e-query',
            'query_type' => 'taxonomies',
            'default' => 'category',
            'label_block' => 'true',
                ]
        );
        $widget->add_control(
                'e_form_save_type_term_parent', [
            'label' => esc_html__('Parent Term', 'e-addons'),
            'placeholder' => 'Search Term',
            //'type' => Controls_Manager::TEXT,
            'query_type' => 'terms',
            'label_block' => 'true',
            'type' => 'e-query',
            'description' => esc_html__('Optionally set Term Parent for Hierarchical Taxonomy, use Field Shortcode or set Term ID', 'e-addons'),
                ]
        );

        $widget->add_control(
                'e_form_save_term_file', [
            'label' => esc_html__('Save Uploaded Files in Media Library', 'e-addons'),
            'type' => Controls_Manager::SWITCHER,
            'description' => esc_html__('Generate new attachment in Media Library for each submitted Files', 'e-addons'),
            'separator' => 'before',
                ]
        );
        $widget->add_control(
                'e_form_save_term_array', [
            'label' => esc_html__('Store Multiple as Array', 'e-addons'),
            'type' => Controls_Manager::SWITCHER,
            'description' => esc_html__('Save submitted fields with multiple values as Array instead default string values separated by comma', 'e-addons'),
                ]
        );
        
        $widget->add_control(
                'e_form_save_type_term_multiple', [
            'label' => esc_html__('Multiple Terms in Repeater', 'e-addons'),
            'type' => 'form_fields',
            'separator' => 'before',
            'description' => esc_html__('Save multiple Terms managed by a Repeater field', 'e-addons'),
            'condition' => [
                'e_form_save_term_override' => 'add',
            ],
                ]
        );

        $widget->add_control(
                'e_form_save_term_redirect', [
            'label' => esc_html__('Redirect to Term Archive', 'e-addons'),
            'type' => Controls_Manager::SWITCHER,
            'separator' => 'before',
            'condition' => [
                'e_form_save_type_term_multiple' => ['', [], ['']],
            ],
            'description' => esc_html__('Redirect user to the Term Archive page', 'e-addons'),
                ]
        );

        Utils::add_help_control($this, $widget);

        $widget->end_controls_section();
    }

    /**
     * Run
     *
     * Runs the action after submit
     *
     * @access public
     * @param \ElementorPro\Modules\Forms\Classes\Form_Record $record
     * @param \ElementorPro\Modules\Forms\Classes\Ajax_Handler $ajax_handler
     */
    public function run($record, $ajax_handler) {

        $post_id = absint($_POST['post_id']);
        $queried_id = absint($_POST['queried_id']);
        $form_id = sanitize_key($_POST['form_id']);
        $fields = Form::get_form_data($record);
        $settings = $this->get_settings(true, $fields);                
                   
        if (!empty($settings['e_form_save_type_term_multiple'])) {
            $settings_raw = $this->get_settings(false);   
            
            if (!empty($fields[$settings['e_form_save_type_term_multiple']])) {
                $fields_row = $fields;
                unset($fields_row[$settings['e_form_save_type_term_multiple']]);
                $rvalue = $fields[$settings['e_form_save_type_term_multiple']];
                $repeater = Form::get_field($settings['e_form_save_type_term_multiple']);
                $rvalue = Form::list_to_array($rvalue, $repeater);
                //var_dump($rvalue); 
                foreach ($rvalue as $rid => $row) {
                    if (is_array($row) && !empty($row)) {                            
                        foreach ($row as $cid => $fvalue) {
                            $fields_row[$cid] = $fvalue;
                        }
                    }                    
                    $settings_row = $this->get_settings(true, $fields_row);      
                    //var_dump($settings_row['e_form_save_type_term_name']);
                    $settings_row['e_form_save_type_term_name'] = Form::do_setting_shortcodes($settings_raw['e_form_save_type_term_name'], $fields_row);
                    $settings_row['e_form_save_type_term_description'] = Form::do_setting_shortcodes($settings_raw['e_form_save_type_term_description'], $fields_row);
                    //var_dump($fields_row); //var_dump($settings_row); die();
                    $term_id = $this->update_obj($settings_row, $fields_row);
                }
            }
            
        } else {

            $term_id = $this->update_obj($settings, $fields);
         
            if ($settings['e_form_save_term_redirect']) {
                $goto = Utils::get_permalink($term_id, 'term');
                if (!empty($goto) && filter_var($goto, FILTER_VALIDATE_URL)) {
                    $ajax_handler->add_response_data('redirect_url', $goto);
                }
            }
        }
        
        
        
    }
    
    public function update_obj($settings, $fields) {
        $term_id = false;

        $fields = $this->fields_filter($fields);
        
        $this->term = array();
        if (!empty($settings['e_form_save_type_term_name'])) {
            $this->term['name'] = $settings['e_form_save_type_term_name'];
        }
        if (!empty($settings['e_form_save_type_term_description'])) {
            $this->term['description'] = $settings['e_form_save_type_term_description'];
        }
        if (!empty($settings['e_form_save_type_term_parent'])) {
            $this->term['parent'] = $settings['e_form_save_type_term_parent'];
        }

        $fields = $this->set_wp_obj_fields($fields);
        
        //var_dump($settings['e_form_save_type_term_name']); die();
        
        $term_id = $queried_id;
        if (!empty($settings['e_form_save_type_term_term'])) {
            $term_id = $this->get_wp_obj_id($settings['e_form_save_type_term_term'], 'term', $ajax_handler);
        } 
        
        if ($settings['e_form_save_term_override'] == 'update') {
            if (!$term_id) {
                return false;
            }
            $term = get_term($term_id);
            if (!$term) {
                return false;
            }            
        }
        
        $term_tmp = false;
        switch ($settings['e_form_save_term_override']) {
            case 'add':
                // ADD NEW
                if (empty($this->term['name'])) {
                    $this->term['name'] = 'Term ' . time();
                }
                $taxonomy = 'category';
                if (!empty($settings['e_form_save_type_term_taxonomy'])) {
                    $taxonomy = $settings['e_form_save_type_term_taxonomy'];
                } else {
                    if ($settings['e_form_save_type_term_parent']) {
                        $parent_term = Utils::get_term($settings['e_form_save_type_term_parent']);
                        if ($parent_term && is_object($parent_term) && get_class($parent_term) == 'WP_Term') {
                            $taxonomy = $parent_term->taxonomy;
                        }
                    }
                }
                $term_tmp = wp_insert_term($this->term['name'], $taxonomy, $this->term);
                break;
            case 'update':
                // UPDATE
                if (!empty($this->term)) {
                    $term = get_term($term_id);
                    $taxonomy = $term->taxonomy;
                    $term_tmp = wp_update_term($term_id, $taxonomy, $this->term);
                }
                break;
        }
        

        if (!$term_tmp || is_wp_error($term_tmp)) {
            $ajax_handler->add_error_message(\ElementorPro\Modules\Forms\Classes\Ajax_Handler::get_default_message(\ElementorPro\Modules\Forms\Classes\Ajax_Handler::SERVER_ERROR, $settings));
        }
        
        if ($term_id = $term_tmp['term_id']) {
            Form::save_extra($term_id, 'term', $settings, $fields);
        } else {
            $ajax_handler->add_error_message(\ElementorPro\Modules\Forms\Classes\Ajax_Handler::get_default_message(\ElementorPro\Modules\Forms\Classes\Ajax_Handler::SERVER_ERROR, $settings));
        }
        
        /**
	 * Fires immediately after a new term is created, before the term cache is cleaned.
	 *
	 * The {@see 'create_$taxonomy'} hook is also available for targeting a specific
	 * taxonomy.
	 *
	 * @since 2.3.0
	 *
	 * @param int    $term_id  Term ID.
	 * @param int    $tt_id    Term taxonomy ID.
	 * @param string $taxonomy Taxonomy slug.ù
         * @param []     $fields   Submitted Form Fields.
	 */
        $tt_id = $term_tmp['term_taxonomy_id'];
	do_action( 'e_addons/forms/add_term', $term_id, $tt_id, $taxonomy, $fields );
        
        return $term_id;
    }
    
    public function render_content($content, $widget) {
        if ($widget->get_name() == 'form') {
            $settings = $widget->get_settings();
            if (in_array($this->get_name(), $settings['submit_actions'])) {
                if ($settings['e_form_save_term_override'] == 'update') {
                    $queried_object = get_queried_object();
                    if ($queried_object && is_object($queried_object) && get_class($queried_object) == 'WP_Term') {
                        if (strpos($content, '<input type="hidden" name="queried_id"') == false) {
                            $content = str_replace('</form>', '<input type="hidden" name="queried_id" value="'.$queried_object->term_id.'"/></form>', $content);
                        }
                    }
                }
            }
        }
        return $content;
    }

}
