<?php

namespace EAddonsProFormActions\Modules\Actions\Actions;

use EAddonsForElementor\Base\Base_Action;
use Elementor\Controls_Manager;
use EAddonsForElementor\Core\Utils;
use EAddonsForElementor\Core\Utils\Form;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

class Telegram extends Base_Action {

    /**
     * Get Name
     *
     * Return the action name
     *
     * @access public
     * @return string
     */
    public function get_name() {
        return 'telegram';
    }

    /**
     * Get Label
     *
     * Returns the action label
     *
     * @access public
     * @return string
     */
    public function get_label() {
        return esc_html__('Telegram', 'e-addons');
    }

    public function get_icon() {
        return 'eadd-el-form-pro-act-send-telegtam';
    }

    public function get_pid() {
        return 1257;
    }

    /**
     * Register Settings Section
     *
     * Registers the Action controls
     *
     * @access public
     * @param \Elementor\Widget_Base $widget
     */
    public function register_settings_section($widget) {

        $this->start_controls_section($widget);

        $widget->add_control(
                'e_form_telegram_token', [
            'label' => esc_html__('BOT Token', 'e-addons'),
            'type' => \Elementor\Controls_Manager::TEXT,
            'placeholder' => '123456:abcdefghilmnopqrstuvz',
            'separator' => 'after',
            'description' => esc_html__('You can create a new one for free from Telegram BotFather.', 'e-addons') . ' ' . esc_html__('<a target="_blank" href="https://core.telegram.org/bots">Get from HERE</a>', 'e-addons'),
                ]
        );

        $repeater_fields = new \Elementor\Repeater();
        $repeater_fields->add_control(
                'e_form_telegram_enable',
                [
                    'label' => esc_html__('Enable Message', 'e-addons'),
                    'type' => \Elementor\Controls_Manager::SWITCHER,
                    'default' => 'yes',
                    'description' => esc_html__('You can temporary disable it without delete settings and reactivate it next time', 'e-addons'),
                    'separator' => 'after',
                ]
        );

        $repeater_fields->add_control(
                'e_form_telegram_chat_last',
                [
                    'label' => esc_html__('Send to latest active users', 'e-addons'),
                    'type' => \Elementor\Controls_Manager::SWITCHER,
                    'description' => esc_html__('Retrieve automatically last User Unique Chat ID from the Bot with getUpdates call', 'e-addons'),
                ]
        );
        $repeater_fields->add_control(
                'e_form_telegram_chat', [
            'label' => esc_html__('Recipient', 'e-addons'),
            'type' => \Elementor\Controls_Manager::TEXT,
            'placeholder' => '@eaddons, 987654321',
            'description' => esc_html__('Unique identifier for the target chat or username of the target channel (in the format @channelusername)', 'e-addons'),
            'condition' => [
                'e_form_telegram_chat_last' => '',
            ],
                ]
        );
        $repeater_fields->add_control(
                'e_form_telegram_content',
                [
                    'label' => esc_html__('Message', 'elementor-pro'),
                    'type' => Controls_Manager::WYSIWYG,
                    'default' => '[all-fields]',
                    'placeholder' => '[all-fields]',
                    'description' => sprintf(__('By default, all form fields are sent via %s shortcode. To customize sent fields, copy the shortcode that appears inside each field and paste it above.', 'elementor-pro'), '<code>[all-fields]</code>'),
                    'label_block' => true,
                    'render_type' => 'none',
                ]
        );

        $repeater_fields->add_control(
                'e_form_attachments',
                [
                    'label' => esc_html__('Add Upload files as Attachments', 'e-addons'),
                    'type' => \Elementor\Controls_Manager::SWITCHER,
                    'description' => esc_html__('Send all Uploaded Files as Message Attachments', 'e-addons'),
                    'separator' => 'before',
                ]
        );


        $widget->add_control(
                'e_form_telegram_repeater', [
            'label' => esc_html__('Messages', 'e-addons'),
            'type' => \Elementor\Controls_Manager::REPEATER,
            'title_field' => '{{{ e_form_telegram_chat }}}',
            'fields' => $repeater_fields->get_controls(),
            'description' => esc_html__('Send all Telegram Messages you need', 'e-addons'),
                ]
        );

        Utils::add_help_control($this, $widget);

        $widget->end_controls_section();
    }

    /**
     * Run
     *
     * Runs the action after submit
     *
     * @access public
     * @param \ElementorPro\Modules\Forms\Classes\Form_Record $record
     * @param \ElementorPro\Modules\Forms\Classes\Ajax_Handler $ajax_handler
     */
    public function run($record, $ajax_handler) {

        $fields = Form::get_form_data($record);
        $settings = $this->get_settings(true, $fields);

        $bot_url = 'https://api.telegram.org/bot' . $settings['e_form_telegram_token'];


        // get all recent chat ids
        $msg_sent = wp_remote_get($bot_url . '/getUpdates');
        $body = wp_remote_retrieve_body($msg_sent);
        $updates = json_decode($body, true);
        $update_chat_ids = [];
        foreach ($updates['result'] as $result) {
            $chat_id = $result['message']['chat']['id'];
            $update_chat_ids[$chat_id] = $chat_id;
        }


        foreach ($settings['e_form_telegram_repeater'] as $mkey => $amsg) {

            if ($amsg['e_form_telegram_enable']) {

                $line_break = '%0A';
                $line_break = '<br>';
                $line_break = PHP_EOL;

                $settings_raw = $record->get('form_settings');
                // from message textarea with dynamic token
                $e_message_content = $settings_raw['e_form_telegram_repeater'][$mkey]['e_form_telegram_content'];
                $e_message_content = Form::replace_content_shortcodes($e_message_content, $record, $line_break);
                $e_message_content = Form::do_setting_shortcodes($e_message_content, $fields);
                $e_message_content = Utils::get_dynamic_data($e_message_content, $fields, 'form');

                // generate the TEXT/PLAIN version
                $e_message_content_txt = Form::get_plain_txt($e_message_content, $line_break);
                $e_message_content_txt = apply_filters('e_addons/forms/wp_telegram_message', $e_message_content_txt);
                $e_message_content = $e_message_content_txt;

                if (empty($amsg['e_form_telegram_chat_last'])) {
                    $e_form_telegram_chat = $amsg['e_form_telegram_chat'];
                    $e_form_telegram_chat = Utils::get_dynamic_data($e_form_telegram_chat, $fields, 'form');
                    $chat_ids = Utils::explode($e_form_telegram_chat);
                } else {
                    $chat_ids = $update_chat_ids;
                }
                //var_dump($chat_ids); die();

                if (!empty($chat_ids)) {
                    foreach ($chat_ids as $chat_id) {
                        $msg_url = $bot_url . '/sendMessage';
                        //$msg_url .= '?chat_id=' . $amsg['e_form_telegram_chat'];
                        //$msg_url .= '&text=' . $e_message_content_txt;
                        //$msg_url .= '&parse_mode=HTML';
                        //$msg_sent = wp_remote_get($msg_url);              
                        $tg_body = [
                            'chat_id' => $chat_id,
                            'text' => $e_message_content, // max 4096 char length
                            'parse_mode' => 'HTML',
                        ];
                        $msg_sent = wp_remote_post($msg_url, ['body' => $tg_body]);
                        //var_dump($msg_sent); die();

                        if (!empty($amsg['e_form_attachments'])) {
                            $attachments = $this->get_attachments($fields, $settings, $amsg, $e_message_content_txt, true);
                            if (!empty($attachments)) {
                                foreach ($attachments as $att) {
                                    $file_ext = pathinfo($att, PATHINFO_EXTENSION);
                                    switch ($file_ext) {
                                        case 'mp3':
                                        case 'm4a':
                                            $action = 'sendAudio';
                                            $param = 'audio';
                                            break;
                                        case 'png':
                                        case 'jpg':
                                            $action = 'sendPhoto';
                                            $param = 'photo';
                                            break;
                                        case 'mp4':
                                        case 'm4v':
                                            $action = 'sendVideo';
                                            $param = 'video';
                                            break;
                                        case 'gif':
                                        case 'pdf':
                                        case 'zip':
                                            $action = 'sendDocument';
                                            $param = 'document';
                                            break;
                                        default:
                                            $action = 'sendMessage';
                                            $param = 'text';
                                    }
                                    $doc_url = $bot_url . '/' . $action;
                                    $doc_url .= '?chat_id=' . $chat_id;
                                    $doc_url .= '&' . $param . '=' . $att;
                                    $doc_sent = wp_remote_get($doc_url);
                                }
                            }
                        }
                    }
                }

                /**
                 * Elementor form msg sent.
                 *
                 * Fires when an msg was sent successfully.
                 *
                 * @since 1.0.0
                 *
                 * @param array       $settings Form settings.
                 * @param Form_Record $record   An instance of the form record.
                 */
                do_action('e_addons/forms/telegram_sent', $amsg, $record);

                if (is_wp_error($msg_sent)) {
                    $ajax_handler->add_error_message(wp_remote_retrieve_body($msg_sent));
                }
            }
        }
    }

}
