<?php

namespace EmailLog\Core\UI\Component;

use EmailLog\Core\DB\TableManager;
use EmailLog\Core\EmailLog;
use Sudar\WPSystemInfo\SystemInfo;

defined( 'ABSPATH' ) || exit; // Exit if accessed directly.

/**
 * Email Log System Info.
 *
 * Uses the WPSystemInfo library.
 *
 * @since 2.3.0
 * @link https://github.com/sudar/wp-system-info
 */
class EmailLogSystemInfo extends SystemInfo {

	/**
	 * Setup hooks and filters.
	 */
	public function load() {
		add_action( 'before_system_info_for_email-log', array( $this, 'print_email_log_details' ) );
	}

	/**
	 * Print details about Email Log.
	 *
	 * PHPCS is disabled for this function since alignment will mess up the system info output.
	 * phpcs:disable
	 */
	public function print_email_log_details() {
		$email_log = email_log();

		$email_log_core = get_option( 'email-log-core' );
		?>
-- Email Log Configuration --

Email Log Version:                  <?php echo EmailLog::VERSION . "\n"; ?>
Number of Logs:                     <?php echo $email_log->table_manager->get_logs_count() . "\n"; ?>
Email Log DB Version:               <?php echo get_option( TableManager::DB_OPTION_NAME ) . "\n"; ?>
<?php if ( is_array( $email_log_core ) ) : ?>
Additional allowed user roles:      <?php echo implode( ', ', $email_log_core['allowed_user_roles'] ) . "\n"; ?>
Remove All Data on Uninstallation:  <?php echo $email_log_core['remove_on_uninstall'] !== '' ? 'Yes' : 'No' . "\n"; ?>
Disable DashBoard Widget:           <?php echo $email_log_core['hide_dashboard_widget'] === 'true' ? 'Yes' : 'No' . "\n"; ?>
<?php endif; ?>

<?php
	}
	// phpcs:enable

	/**
	 * Change the default config.
	 *
	 * @return array Modified config.
	 */
	protected function get_default_config() {
		$config = parent::get_default_config();

		$config['show_posts']      = false;
		$config['show_taxonomies'] = false;
		$config['show_users']      = false;

		return $config;
	}
}
