<?php

namespace EAddonsProFormActions\Modules\Actions\Actions;

use EAddonsForElementor\Base\Base_Action;
use Elementor\Controls_Manager;
use Elementor\Modules\DynamicTags\Module as TagsModule;
use EAddonsForElementor\Core\Utils;
use EAddonsForElementor\Core\Utils\Form;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

class Redirect extends Base_Action {

    /**
     * Get Name
     *
     * Return the action name
     *
     * @access public
     * @return string
     */
    public function get_name() {
        return 'multi-redirect';
    }

    public function get_icon() {
        return 'eadd-el-form-pro-act-multi-redirects';
    }

    public function get_pid() {
        return 280;
    }

    /**
     * Get Label
     *
     * Returns the action label
     *
     * @access public
     * @return string
     */
    public function get_label() {
        return esc_html__('Multi Redirects', 'e-addons');
    }

    /**
     * Register Settings Section
     *
     * Registers the Action controls
     *
     * @access public
     * @param \Elementor\Widget_Base $widget
     */
    public function register_settings_section($widget) {

        $this->start_controls_section($widget);

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
                'e_form_redirect_condition_field', [
            'label' => esc_html__('Redirect IF this Field', 'e-addons'),
            'type' => 'form_fields',
            'label_block' => true,
                ]
        );
        $repeater->add_control(
                'e_form_redirect_condition_nofield', [
            //'label' => esc_html__('ATTENTION', 'e-addons'),
            'raw' => esc_html__('WARNING: If no field is selected this Redirect will always be performed if the above redirect conditions are not met'),
            'type' => Controls_Manager::RAW_HTML,
            'condition' => [
                'e_form_redirect_condition_field' => '',
            ]
                ]
        );
        $repeater->add_control(
                'e_form_redirect_condition_status', [
            'label' => esc_html__('Comparison operator', 'e-addons'),
            'type' => Controls_Manager::SELECT,
            'options' => $this->form_operator_options,
            'default' => 'not_empty',
            'label_block' => true,
            'condition' => [
                'e_form_redirect_condition_field!' => '',
            ],
                ]
        );
        $repeater->add_control(
                'e_form_redirect_condition_value', [
            'label' => esc_html__('Compared with this Value', 'e-addons'),
            'type' => Controls_Manager::TEXT,
            'label_block' => true,
            'condition' => [
                'e_form_redirect_condition_field!' => '',
                'e_form_redirect_condition_status' => $this->operator_with_value,
            ],
                ]
        );

        //elementor-pro/modules/forms/actions/redirect.php:34
        $repeater->add_control(
                'e_form_redirect_to',
                [
                    'label' => esc_html__('Redirect To', 'elementor-pro'),
                    'type' => Controls_Manager::URL,
                    'placeholder' => esc_html__('https://your-link.com', 'elementor-pro'),
                    'label_block' => true,
                    'render_type' => 'none',
                    'classes' => 'elementor-control-direction-ltr',
                ]
        );

        $widget->add_control(
                'e_form_redirect_repeater', [
            'label' => esc_html__('Redirects', 'e-addons'),
            'type' => \Elementor\Controls_Manager::REPEATER,
            'title_field' => 'IF {{{ e_form_redirect_condition_field }}} {{{ e_form_redirect_condition_status }}} {{{ e_form_redirect_condition_value }}} redirect to: {{{ e_form_redirect_to.url }}}',
            'fields' => $repeater->get_controls(),
                ]
        );

        $widget->add_control(
                'e_form_redirect_hide_url_options', [
            'type' => \Elementor\Controls_Manager::RAW_HTML,
            'raw' => '<style>.elementor-control-e_form_redirect_to.elementor-control-type-url .elementor-control-url-more { display: none; }</style>',
                ]
        );

        Utils::add_help_control($this, $widget);

        $widget->end_controls_section();
    }

    /**
     * Run
     *
     * Runs the action after submit
     *
     * @access public
     * @param \ElementorPro\Modules\Forms\Classes\Form_Record $record
     * @param \ElementorPro\Modules\Forms\Classes\Ajax_Handler $ajax_handler
     */
    public function run($record, $ajax_handler) {

        $fields = Form::get_form_data($record);
        $settings = $this->get_settings(true, $fields);

        foreach ($settings['e_form_redirect_repeater'] as $redirect) {

            $run = true;
            $field_id = $redirect['e_form_redirect_condition_field'];
            
            if (!empty($field_id) && isset($fields[$field_id])) {
                $field_value = $fields[$field_id];                
                $field_type = Form::get_field_type($field_id, $settings);
                if ($field_type == 'checkbox') {
                    $field_value = Utils::explode($field_value);
                }
                $run = $this->check_condition($field_value, $redirect['e_form_redirect_condition_status'], $redirect['e_form_redirect_condition_value']);
            }
            
            if ($run) {
                //elementor-pro/modules/forms/actions/redirect.php:70
                $redirect_to = $redirect['e_form_redirect_to']['url'];
                $redirect_to = Utils::get_dynamic_data($redirect_to, $fields, 'form');
                $redirect_to = trim($redirect_to);
                if ( ! empty( $redirect_to ) && filter_var($redirect_to, FILTER_VALIDATE_URL) ) {
                    $ajax_handler->add_response_data('redirect_url', $redirect_to);
                    return;
                }
            }
        }
    }

}
