<?php

namespace EAddonsProFormActions\Modules\Actions\Actions;

use EAddonsForElementor\Base\Base_Action;
use Elementor\Controls_Manager;
use EAddonsForElementor\Core\Utils;
use EAddonsForElementor\Core\Utils\Form;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

class Post extends Base_Action {

    public $post = [];

    /**
     * Get Name
     *
     * Return the action name
     *
     * @access public
     * @return string
     */
    public function get_name() {
        return 'post';
    }

    public function get_icon() {
        return 'eadd-el-form-pro-act-save-posts';
    }

    /**
     * Get Label
     *
     * Returns the action label
     *
     * @access public
     * @return string
     */
    public function get_label() {
        return esc_html__('Create Post', 'e-addons');
    }

    public function get_pid() {
        return 10785;
    }

    /**
     * Register Settings Section
     *
     * Registers the Action controls
     *
     * @access public
     * @param \Elementor\Widget_Base $widget
     */
    public function register_settings_section($widget) {

        $this->start_controls_section($widget);

        $widget->add_control(
                'e_form_save_post_override', [
            'label' => esc_html__('Add or Update', 'e-addons'),
            'type' => Controls_Manager::CHOOSE,
            'options' => [
                'add' => [
                    'title' => esc_html__('Add', 'e-addons'),
                    'icon' => 'eicon-plus',
                ],
                'update' => [
                    'title' => esc_html__('Update', 'e-addons'),
                    'icon' => 'eicon-sync',
                ],
            ],
            'default' => 'add',
            'toggle' => false,
            'description' => esc_html__('Updated Post data or create a new one', 'e-addons'),
                ]
        );
        $widget->add_control(
                'e_form_save_type_post_post', [
            'label' => esc_html__('Find Post to update', 'e-addons'),
            'type' => 'e-query',
            'placeholder' => esc_html__('Select a Post or leave empty for Current', 'e-addons'),
            'label_block' => true,
            'query_type' => 'posts',
            'description' => esc_html__('Search Post by Title or leave empty for Current Post', 'e-addons'),
            'condition' => [
                'e_form_save_post_override' => 'update',
            ],
                ]
        );

        $widget->add_control(
                'e_form_save_type_post_heading', [
            'label' => esc_html__('Post', 'e-addons'),
            'type' => Controls_Manager::HEADING,
            'separator' => 'before',
        ]);
        $widget->add_control(
                'e_form_save_type_post_title', [
            'label' => esc_html__('Post Title', 'e-addons'),
            'type' => Controls_Manager::TEXT,
            'default' => '[field id="name"]',
            'description' => esc_html__('You can set static text, field Shortcodes or mixed', 'e-addons'),
            'label_block' => 'true',
                ]
        );
        $widget->add_control(
                'e_form_save_type_post_content', [
            'label' => esc_html__('Post Content', 'e-addons'),
            'type' => Controls_Manager::WYSIWYG,
            'default' => '[field id="message"]',
            'description' => esc_html__('You can set static text, field Shortcodes or mixed', 'e-addons'),
            'label_block' => 'true',
                ]
        );
        $widget->add_control(
                'e_form_save_type_post_type', [
            'label' => esc_html__('Post Type', 'e-addons'),
            'type' => 'e-query',
            'placeholder' => esc_html__('Search Post Type', 'e-addons'),
            'label_block' => true,
            'query_type' => 'posts',
            'object_type' => 'type',
            'default' => 'post',
            'condition' => [
                'e_form_save_post_override' => 'add',
            ],
            'label_block' => 'true',
                ]
        );
        $widget->add_control(
                'e_form_save_type_post_term',
                [
                    'label' => esc_html__('Post Terms', 'e-addons'),
                    'type' => 'e-query',
                    'placeholder' => esc_html__('Select Terms', 'e-addons'),
                    'label_block' => true,
                    'query_type' => 'terms',
                    'multiple' => true,
                    'condition' => [
                        'e_form_save_post_override' => 'add',
                    ],
                ]
        );

        $widget->add_control(
                'e_form_save_type_post_status', [
            'label' => esc_html__('Post Status', 'e-addons'),
            'type' => Controls_Manager::SELECT,
            'options' => array('' => esc_html__('Default', 'elementor')) + get_post_stati() + array('password' => esc_html__('Password', 'elementor'), 'custom' => esc_html__('Custom', 'elementor')),
            'description' => esc_html__('By default is "draft" when Add new post and the previous one on post Update', 'e-addons'),
                ]
        );
        $widget->add_control(
                'e_form_save_type_post_password', [
            'label' => esc_html__('Post Password', 'e-addons'),
            'type' => Controls_Manager::TEXT,
            'condition' => [
                'e_form_save_type_post_status' => 'password',
            ],
                ]
        );
        $widget->add_control(
                'e_form_save_type_post_status_custom', [
            'label' => esc_html__('Custom Post Status', 'e-addons'),
            'type' => Controls_Manager::TEXT,
            'condition' => [
                'e_form_save_type_post_status' => 'custom',
            ],
                ]
        );

        $widget->add_control(
                'e_form_save_parent', [
            'label' => esc_html__('Current Post as Parent', 'e-addons'),
            'type' => Controls_Manager::SWITCHER,
            'condition' => [
                'e_form_save_post_override' => 'add',
            ],
                ]
        );

        $widget->add_control(
                'e_form_save_type_post_author',
                [
                    'label' => esc_html__('Author', 'elementor'),
                    'type' => 'e-query',
                    'placeholder' => esc_html__('Select Author', 'e-addons'),
                    'label_block' => true,
                    'query_type' => 'users',
                    'multiple' => true,
                    'description' => esc_html__('By default will be set the current logged in User', 'e-addons'),
                ]
        );

        $widget->add_control(
                'e_form_save_post_file', [
            'label' => esc_html__('Save Uploaded Files in Media Library', 'e-addons'),
            'type' => Controls_Manager::SWITCHER,
            'description' => esc_html__('Generate new attachment in Media Library for each submitted Files', 'e-addons'),
                ]
        );
        $widget->add_control(
                'e_form_save_post_thumbnail_id', [
            'type' => Controls_Manager::RAW_HTML,
            'raw' => esc_html__('NOTE: for Post Featured Image create an Upload or Media field type with Custom ID "_thumbnail_id"', 'e-addons'),
            'condition' => [
                'e_form_save_post_file!' => '',
            ],
                ]
        );
        $widget->add_control(
                'e_form_save_post_array', [
            'label' => esc_html__('Store Multiple as Array', 'e-addons'),
            'type' => Controls_Manager::SWITCHER,
            'description' => esc_html__('Save submitted fields with multiple values as Array instead default string values separated by comma', 'e-addons'),
                ]
        );

        $widget->add_control(
                'e_form_save_post_redirect', [
            'label' => esc_html__('Redirect to Post', 'e-addons'),
            'type' => Controls_Manager::SWITCHER,
            'description' => esc_html__('Redirect User to single Post page', 'e-addons'),
                ]
        );

        Utils::add_help_control($this, $widget);

        $widget->end_controls_section();
    }

    /**
     * Run
     *
     * Runs the action after submit
     *
     * @access public
     * @param \ElementorPro\Modules\Forms\Classes\Form_Record $record
     * @param \ElementorPro\Modules\Forms\Classes\Ajax_Handler $ajax_handler
     */
    public function run($record, $ajax_handler) {

        $post_id = absint($_POST['post_id']);
        $queried_id = absint($_POST['queried_id']);
        $form_id = sanitize_key($_POST['form_id']);
        $fields = Form::get_form_data($record);
        $settings = $this->get_settings(true, $fields);
        $taxonomies = Utils::get_taxonomies();

        if (!empty($settings['e_form_save_extra'])) {
            $fields = Form::get_form_data($record, false, true, $settings);
        }

        //var_dump($fields); die();
        $fields = $this->fields_filter($fields);

        $this->post = array();
        if ($settings['e_form_save_type_post_title']) {
            $this->post['post_title'] = $settings['e_form_save_type_post_title'];
        }
        if ($settings['e_form_save_type_post_content']) {
            $this->post['post_content'] = $settings['e_form_save_type_post_content'];
        }
        if ($settings['e_form_save_type_post_author']) {
            $this->post['post_author'] = $settings['e_form_save_type_post_author'];
        }
        
        $fields = $this->set_wp_obj_fields($fields);

        if ($post_id != $queried_id && $queried_id) {
            if (get_post($queried_id)) {
                $post_id = $queried_id;
            }
        }
        if (!empty($settings['e_form_save_type_post_post'])) {
            if (!$post_id = $this->get_wp_obj_id($settings['e_form_save_type_post_post'], 'post', $ajax_handler)) {
                return false;
            }
        }

        switch ($settings['e_form_save_post_override']) {
            case 'add':
                // ADD NEW POST
                $this->post['post_type'] = $settings['e_form_save_type_post_type'];
                if ($settings['e_form_save_parent']) {
                    $this->post['post_parent'] = $queried_id;
                }
                $post_id = wp_insert_post($this->post);
                break;
            case 'update':
                // UPDATE POST
                if ($status == 'trash') {
                    wp_trash_post($post_id);
                }
                if (!empty($this->post)) {
                    $this->post['ID'] = $post_id;
                    $post_id = wp_update_post($this->post);
                }
                break;
        }

        // VERIFY IF SAVED CORRECTLY
        if (is_wp_error($post_id) || !$post_id) {
            $ajax_handler->add_error_message(\ElementorPro\Modules\Forms\Classes\Ajax_Handler::get_default_message(\ElementorPro\Modules\Forms\Classes\Ajax_Handler::SERVER_ERROR, $settings));
        }

        // SET META
        //var_dump($fields); die();
        Form::save_extra($post_id, 'post', $settings, $fields);

        // SET TERMS
        $obj = get_post($post_id);
        $terms = array();
        if (!empty($settings['e_form_save_type_post_term'])) {
            $term_ids = Utils::explode($settings['e_form_save_type_post_term']);
            foreach ($term_ids as $term_id) {
                $term = get_term($term_id);
                $terms[$term->taxonomy][] = $term->slug;
            }
        }
        if (!empty($taxonomies)) {
            foreach ($taxonomies as $key => $taxonomy) {
                if (!empty($fields[$key])) {
                    $term_ids = Utils::explode($fields[$key]);
                    if (!empty($term_ids)) {
                        foreach ($term_ids as $term_id) {
                            $term = Utils::get_term($term_id, $key);
                            $terms[$key][] = $term ? $term->slug : $term_id;
                        }
                    }
                }
            }
        }
        // add or create new terms related to current post
        if (!empty($terms)) {
            foreach ($terms as $taxonomy => $term_ids) {
                $set_terms = wp_set_object_terms($post_id, $term_ids, $taxonomy);
                $this->add_wc_attribute($obj, $taxonomy);
            }
        }
        
        // save status
        $status = $this->get_status($settings);
        if ($status) {
            $args = array(
                'ID' => $post_id,
                'post_status' => $status,
            );
            if ($status == 'password') {
                $args['post_status'] = 'publish';
                $args['post_password'] = $settings['e_form_save_type_post_password'];
            }
            wp_update_post( $args );
        }
        
        /**
	 * Fires once a post has been saved.
	 *
	 * @since 2.0.0
	 *
	 * @param int     $post_ID Post ID.
	 * @param WP_Post $post    Post object.
	 * @param bool    $update  Whether this is an existing post being updated.
         * @param []      $fields  Submitted Form Fields.
         *          
         */        
        $update = $settings['e_form_save_post_override'] == 'update';
	do_action( 'e_addons/forms/create_post', $post_id, $obj, $update, $fields );

        if ($settings['e_form_save_post_redirect']) {
            $ajax_handler->add_response_data('redirect_url', get_permalink($post_id));
        }
    }

    public function get_status($settings) {
        $status = $settings['e_form_save_type_post_status'];
        if ($status == 'custom') {
            $status = sanitize_key($settings['e_form_save_type_post_status_custom']);
        }
        /*if (empty($status) && $settings['e_form_save_post_override'] == 'add') {
            $status = 'publish';
        }*/
        return $status;
    }

    public function add_wc_attribute($obj, $taxonomy) {
        // WooCommerce Product Attributes
        if (substr($taxonomy, 0, 3) == 'pa_') {// && !in_array($taxonomy, array('product_cat', 'product_tag', 'product_type', 'product_visibility'))) {
            if ($obj->post_type == 'product') {
                $product_attributes = array_filter((array) get_post_meta($obj->ID, '_product_attributes', true));
                if (empty($product_attributes[$taxonomy])) {
                    if (empty($product_attributes)) {
                        $product_attributes = array();
                    }
                    $product_attributes[$taxonomy] = array(
                        'name' => $taxonomy,
                        'value' => '',
                        'position' => 0,
                        'is_visible' => 1,
                        'is_variation' => 0,
                        'is_taxonomy' => 1,
                    );
                    update_post_meta($obj->ID, '_product_attributes', $product_attributes);
                }
            }
        }
    }

}
