<?php

namespace EAddonsProFormActions\Modules\Actions\Actions;

use EAddonsForElementor\Base\Base_Action;
use Elementor\Controls_Manager;
use EAddonsForElementor\Core\Utils;
use EAddonsForElementor\Core\Utils\Form;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

class Login extends Base_Action {

    /**
     * Get Name
     *
     * Return the action name
     *
     * @access public
     * @return string
     */
    public function get_name() {
        return 'login';
    }

    public function get_icon() {
        return 'eadd-el-form-pro-act-login';
    }

    /**
     * Get Label
     *
     * Returns the action label
     *
     * @access public
     * @return string
     */
    public function get_label() {
        return esc_html__('Login', 'e-addons');
    }

    public function get_pid() {
        return 6988;
    }

    /**
     * Register Settings Section
     *
     * Registers the Action controls
     *
     * @access public
     * @param \Elementor\Widget_Base $widget
     */
    public function register_settings_section($widget) {

        $this->start_controls_section($widget);

        $widget->add_control(
                'e_form_login_log', [
            'label' => esc_html__('UserName or Email', 'e-addons'),
            'type' => Controls_Manager::TEXT,
            'default' => '[field id="log"]',
            'placeholder' => '[field id="log"]',
            'description' => esc_html__('Use field Shortcode for UserName or Email', 'e-addons'),
            'label_block' => 'true',
                ]
        );
        $widget->add_control(
                'e_form_login_pwd', [
            'label' => esc_html__('Password', 'e-addons'),
            'type' => Controls_Manager::TEXT,
            'default' => '[field id="pwd"]',
            'placeholder' => '[field id="pwd"]',
            'label_block' => 'true',
                ]
        );
        $widget->add_control(
                'e_form_login_rememberme', [
            'label' => esc_html__('Remember Me', 'e-addons'),
            'type' => Controls_Manager::TEXT,
            'default' => '[field id="rememberme"]',
            'label_block' => 'true',
            'description' => esc_html__('If not empty a cookie will be stored', 'e-addons'),
                ]
        );

        $widget->add_control(
                'e_form_login_error', [
            'label' => esc_html__('User Login Error Message', 'e-addons'),
            'type' => Controls_Manager::TEXT,
            'placeholder' => esc_html__('Leave empty for default WP error messages', 'e-addons'),
            'label_block' => true,
            'separator' => 'before',
                ]
        );

        $widget->add_control(
                'e_form_login_loggedin', [
            'label' => esc_html__('Ignore for Logged', 'e-addons'),
            'description' => esc_html__('Ignore this Action if current User is already Logged In', 'e-addons'),
            'type' => Controls_Manager::SWITCHER,
            'default' => 'yes',
                ]
        );
        $widget->add_control(
                'e_form_login_error_loggedin', [
            'label' => esc_html__('User Logged In Error Message', 'e-addons'),
            'type' => Controls_Manager::TEXT,
            'default' => esc_html__('You are already Logged In, please Log Out and retry', 'e-addons'),
            'label_block' => true,
            'condition' => [
                'e_form_login_loggedin' => '',
            ],
                ]
        );
        $widget->add_control(
                'e_form_login_error_stop', [
            'label' => esc_html__('Stop Actions on Error', 'e-addons'),
            'type' => Controls_Manager::SWITCHER,
            'description' => esc_html__('Stop next actions execution on Error', 'e-addons'),
                ]
        );

        Utils::add_help_control($this, $widget);

        $widget->end_controls_section();
    }

    /**
     * Run
     *
     * Runs the action after submit
     *
     * @access public
     * @param \ElementorPro\Modules\Forms\Classes\Form_Record $record
     * @param \ElementorPro\Modules\Forms\Classes\Ajax_Handler $ajax_handler
     */
    public function run($record, $ajax_handler) {

        $fields = Form::get_form_data($record);
        $settings = $this->get_settings(true, $fields);
        $settings_raw = $record->get('form_settings');
        $error_msg = false;
        $user_id = get_current_user_id();
        if ($user_id) {
            if (empty($settings['e_form_login_loggedin'])) {
                $error_msg = $settings['e_form_login_error_loggedin'];
            }
        } else {
            global $user;
            global $current_user;

            $pwd = $settings['e_form_login_pwd'];
            if (strpos($settings_raw['e_form_login_pwd'], '[field id="') !== false) {
                $tmp = str_replace('[field id="', '', $settings_raw['e_form_login_pwd']);
                $field = str_replace('"]', '', $tmp);
                if (!empty($_POST['form_fields'][$field])) {
                    $pwd = $_POST['form_fields'][$field];
                }
            }
            //var_dump($pwd); die();
            $user = wp_signon(
                    array(
                        'user_login' => $settings['e_form_login_log'],
                        'user_password' => $pwd,
                        'remember' => $settings['e_form_login_rememberme']
                    )
            );
            if (is_wp_error($user)) {
                $error_msg = $settings['e_form_login_error'];
                if (empty($error_msg)) {
                    $error_msg = Utils::to_string($user->get_error_messages());
                }
            }
            $current_user = $user;
        }
        if ($error_msg) {
            $ajax_handler->add_error_message($error_msg);
            if (!empty($settings['e_form_login_error_stop'])) {
                $ajax_handler->send();
                die();
            }
        }
    }

}
