<?php

namespace EAddonsProFormActions\Modules\Actions\Actions;

use EAddonsForElementor\Base\Base_Action;
use Elementor\Controls_Manager;
use EAddonsForElementor\Core\Utils;
use EAddonsForElementor\Core\Utils\Form;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

class Db extends Base_Action {

    /**
     * Get Name
     *
     * Return the action name
     *
     * @access public
     * @return string
     */
    public function get_name() {
        return 'db';
    }

    public function get_icon() {
        return 'eadd-el-form-pro-act-save-db';
    }

    /**
     * Get Label
     *
     * Returns the action label
     *
     * @access public
     * @return string
     */
    public function get_label() {
        return esc_html__('Save to Custom DB', 'e-addons');
    }

    public function get_pid() {
        return 273;
    }

    /**
     * Register Settings Section
     *
     * Registers the Action controls
     *
     * @access public
     * @param \Elementor\Widget_Base $widget
     */
    public function register_settings_section($widget) {

        $this->start_controls_section($widget);

        $widget->add_control(
                'e_form_db_override', [
            'label' => esc_html__('Add or Update', 'e-addons'),
            'type' => Controls_Manager::CHOOSE,
            'options' => [
                'add' => [
                    'title' => esc_html__('Add', 'e-addons'),
                    'icon' => 'eicon-plus',
                ],
                'update' => [
                    'title' => esc_html__('Update', 'e-addons'),
                    'icon' => 'eicon-sync',
                ],
            ],
            'default' => 'add',
            'toggle' => false,
            'description' => esc_html__('Updated Row or create a new one in Table', 'e-addons'),
                ]
        );


        $widget->add_control(
                'e_form_db_table', [
            'label' => esc_html__('DB Table', 'e-addons'),
            'type' => Controls_Manager::TEXT,
                ]
        );
        $widget->add_control(
                'e_form_db_table_prefix', [
            'label' => esc_html__('Add WP Table Prefix', 'e-addons'),
            'type' => Controls_Manager::SWITCHER,
            'condition' => [
                'e_form_db_table!' => '',
            ],
                ]
        );
        $widget->add_control(
                'e_form_db_user', [
            'label' => esc_html__('DB User', 'e-addons'),
            'type' => Controls_Manager::TEXT,
            'condition' => [
                'e_form_db_table!' => '',
            ],
                ]
        );
        $widget->add_control(
                'e_form_db_password', [
            'label' => esc_html__('DB Password', 'e-addons'),
            'type' => Controls_Manager::TEXT,
            'condition' => [
                'e_form_db_table!' => '',
                'e_form_db_user!' => '',
            ],
                ]
        );
        $widget->add_control(
                'e_form_db_name', [
            'label' => esc_html__('DB Name', 'e-addons'),
            'type' => Controls_Manager::TEXT,
            'condition' => [
                'e_form_db_table!' => '',
                'e_form_db_user!' => '',
            ],
                ]
        );

        $widget->add_control(
                'e_form_db_host', [
            'label' => esc_html__('DB Host', 'e-addons'),
            'placeholder' => 'localhost:3306',
            'type' => Controls_Manager::TEXT,
            'condition' => [
                'e_form_db_table!' => '',
                'e_form_db_user!' => '',
            ],
                ]
        );

        $repeater_fields = new \Elementor\Repeater();
        $repeater_fields->add_control(
                'e_form_db_field_key', [
            'label' => esc_html__('Field Key', 'e-addons'),
            'description' => esc_html__('Is the key of the Field in the DB Table', 'e-addons'),
            'type' => Controls_Manager::TEXT,
                ]
        );
        $repeater_fields->add_control(
                'e_form_db_primary_key', [
            'label' => esc_html__('Is Primary Key', 'e-addons'),
            'type' => Controls_Manager::SWITCHER,
                ]
        );
        $repeater_fields->add_control(
                'e_form_db_field_value', [
            'label' => esc_html__('Field Value', 'e-addons'),
            'description' => esc_html__('Is the value of the Field in the Form', 'e-addons'),
            'type' => Controls_Manager::TEXT,
                ]
        );

        $repeater_fields->add_control(
                'e_form_db_field_format', [
            'label' => esc_html__('Field Format', 'e-addons'),
            'description' => esc_html__('Is the Format of the Field in the DB Table', 'e-addons'),
            'type' => Controls_Manager::SELECT,
            'options' => [
                '%d' => 'integer',
                '%f' => 'float',
                '%s' => 'string',
            ],
            'default' => '%s',
                ]
        );
        $repeater_fields->add_control(
                'e_form_db_field_sanitize', [
            'label' => esc_html__('Sanitize Value', 'e-addons'),
            'description' => esc_html__('Sanitize Field Value before insert it in the DB Table.', 'e-addons').'<a href="https://codex.wordpress.org/Validating_Sanitizing_and_Escaping_User_Data" target="_blank">'.esc_html__('Read more', 'elementor').'</a>',
            'type' => Controls_Manager::SELECT,
            'options' => [
                '' => esc_html__('None', 'elementor'),
                'sanitize_text_field' => 'sanitize_text_field',
                'sanitize_title' => 'sanitize_title',
                'sanitize_email' => 'sanitize_email',
                'sanitize_file_name' => 'sanitize_file_name',
                'sanitize_html_class' => 'sanitize_html_class',
                'sanitize_key' => 'sanitize_key',
                'sanitize_meta' => 'sanitize_meta',
                'sanitize_mime_type' => 'sanitize_mime_type',
                'sanitize_option' => 'sanitize_option',
                'sanitize_sql_orderby' => 'sanitize_sql_orderby',
                'sanitize_title_for_query' => 'sanitize_title_for_query',
                'sanitize_title_with_dashes' => 'sanitize_title_with_dashes',
                'sanitize_user' => 'sanitize_user',
                'esc_url_raw' => 'esc_url_raw',
                'wp_filter_post_kses' => 'wp_filter_post_kses',
                'wp_filter_nohtml_kses' => 'wp_filter_nohtml_kses',
            ],
                ]
        );

        //
        $widget->add_control(
                'e_form_db_fields', [
            'label' => esc_html__('Fields', 'e-addons'),
            'type' => \Elementor\Controls_Manager::REPEATER,
            'fields' => $repeater_fields->get_controls(),
            'title_field' => '{{{ e_form_db_field_key }}} = {{{ e_form_db_field_value }}}',
            'prevent_empty' => false,
            'separator' => 'after',
                ]
        );

        $widget->add_control(
                'e_form_db_file', [
            'label' => esc_html__('Save Files as Media', 'e-addons'),
            'type' => Controls_Manager::SWITCHER,
            'description' => esc_html__('Create a Media and save his ID instead the URL', 'e-addons'),
                ]
        );
        $widget->add_control(
                'e_form_db_array', [
            'label' => esc_html__('Save Multiple as Array', 'e-addons'),
            'type' => Controls_Manager::SWITCHER,
            'description' => esc_html__('Save Files, Select and Checkboxes submitted value as Array instead a comma separated values string', 'e-addons'),
                ]
        );
        $widget->add_control(
                'e_form_db_array_encode', [
            'label' => esc_html__('Array Encoding', 'e-addons'),
            'type' => Controls_Manager::CHOOSE,
            'options' => [
                'serialize' => [
                    'title' => esc_html__('Serialize', 'e-addons'),
                    'icon' => 'eicon-wordpress-light',
                ],
                'json' => [
                    'title' => esc_html__('Json', 'e-addons'),
                    'icon' => 'eicon-editor-code',
                ],
            ],
            'default' => 'serialize',
            'toggle' => false,
            'condition' => [
                'e_form_db_array!' => '',
            ],
                ]
        );
        // json or serialized

        $widget->add_control(
                'e_form_db_error', [
            'label' => esc_html__('Custom Error Message', 'e-addons'),
            'type' => Controls_Manager::TEXT,
            'separator' => 'before',
                ]
        );

        Utils::add_help_control($this, $widget);

        $widget->end_controls_section();
    }

    /**
     * Run
     *
     * Runs the action after submit
     *
     * @access public
     * @param \ElementorPro\Modules\Forms\Classes\Form_Record $record
     * @param \ElementorPro\Modules\Forms\Classes\Ajax_Handler $ajax_handler
     */
    public function run($record, $ajax_handler) {

        global $wpdb;

        $post_id = absint($_POST['post_id']);
        $queried_id = absint($_POST['queried_id']);
        $form_id = sanitize_key($_POST['form_id']);

        $fields = Form::get_form_data($record);
        $fields = $this->fields_filter($fields);
        
        // manage multiple fields (like Repeaters)
        $settings = $this->get_settings(false);
        if (!empty($fields) && is_array($fields)) {
            if ($settings['e_form_db_file']) {
                $fields = Form::save_upload_media($fields, $settings, $queried_id);
            }
            foreach ($fields as $akey => $adata) {
                if ($settings['e_form_db_array']) {
                    $afield = Form::get_field($akey, $settings);                    
                    if ($afield) {
                        if (Form::is_multiple($afield)) { 
                            if ($afield['field_type'] == 'repeater') {
                                if (is_string($adata)) {
                                    $adata = Form::list_to_array($adata, $afield);
                                }
                                if ($settings['e_form_db_file']) {
                                    foreach($adata as $row_id => $rfields) {
                                        $adata[$row_id] = Form::save_upload_media($rfields, $settings);
                                    }
                                }
                            }
                            $adata = Utils::explode($adata);
                            if ($settings['e_form_db_array_encode'] == 'json') {
                                $fields[$akey] = wp_json_encode($adata);
                            } else {
                                $fields[$akey] = maybe_serialize($adata);
                            }
                        }
                    }
                }
            }
        }
        //var_dump($fields);
        $settings = $this->get_settings(true, $fields);
        $settings_raw = $this->get_settings(false);
        //var_dump($settings_raw['e_form_db_fields']); 
        
        $success = true;
        $errors = '';

        // Save to DB
        if (!empty($settings['e_form_db_user'])) {

            $mydb = new \wpdb(DB_USER, DB_PASSWORD, DB_NAME, DB_HOST);
            
            $db_name = $settings['e_form_db_name'] ? $settings['e_form_db_name'] : DB_NAME;
            $db_host = $settings['e_form_db_host'] ? $settings['e_form_db_host'] : DB_HOST;
            $mydb->dbuser = $settings['e_form_db_user'];
            $mydb->dbpassword = $settings['e_form_db_password'];
            $mydb->dbname = $db_name;
            $mydb->dbhost = $db_host;
            //var_dump($mydb->db_connect(false)); die();
            if ($mydb->db_connect(false)) {
                $mydb = new \wpdb($settings['e_form_db_user'], $settings['e_form_db_password'], $db_name, $db_host);
            } else {
                $errors = esc_html__('Error establishing a database connection') . ', ' . esc_html__('This either means that the username and password information in your %1$s file is incorrect or we can&#8217;t contact the database server at %2$s. This could mean your host&#8217;s database server is down.');
            }
        } else {
            $mydb = $wpdb;
        }

        $table = $settings['e_form_db_table'];
        if (!empty($table) && !$errors) {

            if ($settings['e_form_db_table_prefix']) {
                $table = $wpdb->prefix . $table;
            }

            //$mydb->hide_errors();

            if (!empty($settings['e_form_db_fields'])) {
                $data = array();
                $format = array();
                $where = array();
                $where_format = array();

                ob_start();

                if ($settings['e_form_db_override'] == 'add') {
                    foreach ($settings_raw['e_form_db_fields'] as $akey => $afield) {                        
                        $data[$afield['e_form_db_field_key']] = $this->get_value($afield, $fields, $settings, $akey);
                        $format[] = $afield['e_form_db_field_format'];
                    }                    
                    $success = $mydb->insert($table, $data, $format);
                } else {

                    foreach ($settings_raw['e_form_db_fields'] as $akey => $afield) {                        
                        if ($afield['e_form_db_primary_key']) {
                            $where[$afield['e_form_db_field_key']] = $this->get_value($afield, $fields, $settings, $akey);
                            $where_format[] = $afield['e_form_db_field_format'];
                        } else {
                            $data[$afield['e_form_db_field_key']] = $this->get_value($afield, $fields, $settings, $akey);
                            $format[] = $afield['e_form_db_field_format'];
                        }
                    }
                    $success = $mydb->update($table, $data, $where, $format, $where_format);
                }

                $errors = ob_get_clean();
            }
        }

        if (!$success || $errors || is_wp_error($errors)) {
            //var_dump($errors); echo 'test'; die();
            if (is_wp_error($errors)) {
                $error_msg = Utils::to_string($errors->get_error_messages());
            } else {
                if ($errors) {
                    $error_msg = $errors;
                    /*$tmp = explode('</h1>', $errors);
                    if (count($tmp) > 1) {
                        $errors = reset($tmp);
                    }                    
                    $error_msg = strip_tags($errors);
                    $error_msg = str_replace('`', "", $error_msg);
                    $error_msg = str_replace('&#039;', "", $error_msg);
                    */
                } else {
                    $error_msg = esc_html__('Save to DB Error', 'elementor');
                }
            }
            //$ajax_handler->add_error($this->get_name(), $error_msg);

            if ($settings['e_form_db_error']) {
                $error_msg = $settings['e_form_db_error'];
            }
            $ajax_handler->add_error_message($error_msg);
        }
    }

    public function get_value($afield, $fields, $settings = array(), $key = 0) {
        $value = $afield['e_form_db_field_value'];
        if (empty($value)) {
            $value = $settings['e_form_db_fields'][$key]['e_form_db_field_value'];
        }
        
        if (!empty($settings['e_form_db_array'])) {
            $field = Form::get_field($akey, $settings);                    
            if ($field) {
                if (Form::is_multiple($field)) {
                    
                    if ($field['field_type'] == 'repeater') {
                        if (is_string($value)) {
                            $value = Form::list_to_array($value, $field);
                        }

                        if ($settings['e_form_db_file']) {
                            foreach($value as $row_id => $rfields) {
                                $value[$row_id] = Form::save_upload_media($rfields, $settings);
                            }
                        }
                        
                        if ($settings['e_form_db_array_encode'] == 'json') {
                            $value = wp_json_encode($value);
                        }
                    }
                    
                    if ($settings['e_form_db_array_encode'] == 'json') {
                        foreach ($fields as $akey => $adata) {            
                            if (Utils::json_validate($adata)) {
                                $value = str_replace('[field id="'.$akey.'"]', $adata, $value);
                            }
                        }
                    }
                }
            
            }
        }
        $value = Utils::get_dynamic_data($value, $fields, 'form');
        if ($afield['e_form_db_field_sanitize']) {
            $value = call_user_func($afield['e_form_db_field_sanitize'], $value);
        }
        return $value;
    }

}
