<?php

namespace EAddonsProFormActions\Modules\Actions\Actions;

use EAddonsForElementor\Base\Base_Action;
use Elementor\Controls_Manager;
use EAddonsForElementor\Core\Utils;
use EAddonsForElementor\Core\Utils\Form;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

class Custom extends Base_Action {

    public function get_description() {
        return esc_html__('Add Custom Action to Elementor PRO Form', 'e-addons');
    }

    /**
     * Get Name
     *
     * Return the action name
     *
     * @access public
     * @return string
     */
    public function get_name() {
        return 'custom';
    }

    /**
     * Get Label
     *
     * Returns the action label
     *
     * @access public
     * @return string
     */
    public function get_label() {
        return esc_html__('Custom PHP Script', 'e-addons');
    }

    public function get_icon() {
        return 'eadd-el-form-pro-act-custom-php-script';
    }

    public function get_pid() {
        return 3647;
    }

    /**
     * Register Settings Section
     *
     * Registers the Action controls
     *
     * @access public
     * @param \Elementor\Widget_Base $widget
     */
    public function register_settings_section($widget) {

        $this->start_controls_section($widget);

        $widget->add_control(
                'e_form_custom_php', [
            'label' => esc_html__('Custom PHP', 'e-addons'),
            'type' => Controls_Manager::CODE,
            //'language' => 'PHP',
            'default' => "wp_send_json_success([
                'message' => 'Hello World!',
                'data' => \$ajax_handler->data,
            ]);",
            'description' => __('<b>EXAMPLE:</b> ', 'e-addons').'<br>'.'$ajax_handler->add_response_data("redirect_url", "https://www.e-addons.com");'
                . '<br>' . __('<b>WARNING:</b> a dirty code can stop the Action execution and next Actions', 'e-addons'),
                ]
        );
        
        $widget->add_control(
                'e_form_custom_php_info', [
            'label' => __('<b>NOTE</b>', 'e-addons'),
            'type' => Controls_Manager::RAW_HTML,
            'raw' => __('You can use this variables inside your code: <ul><li>- <b>$fields</b>, submitted values indexed by field custom id</li><li>- <b>$settings</b>, form configuration</li><li>- <b>$ajax_handler</b>, form actions handler</li></ul><br>For more info please refer to <a href="https://developers.elementor.com/forms-api/custom-form-action/" target="_blank">PRO From API docs</a>', 'e-addons'),
                ]
        );

        Utils::add_help_control($this, $widget);

        $widget->end_controls_section();
    }

    /**
     * Run
     *
     * Runs the action after submit
     *
     * @access public
     * @param \ElementorPro\Modules\Forms\Classes\Form_Record $record
     * @param \ElementorPro\Modules\Forms\Classes\Ajax_Handler $ajax_handler
     */
    public function run($record, $ajax_handler) {
        $fields = Form::get_form_data($record, false);
        $settings = $this->get_settings(true, $fields);

        if (!empty($settings['e_form_custom_php'])) {
            eval($settings['e_form_custom_php']);
        }
    }

}