<?php

namespace EAddonsProFormActions\Modules\Actions;

use EAddonsForElementor\Base\Module_Base;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

class Actions extends Module_Base {

    public function __construct() {
        parent::__construct();
        
        if (!is_user_logged_in()) {
            
            add_action( 'elementor_pro/init', function () {
                
                if (!empty($_GET['e_act']) && !empty($_GET['email']) && !empty($_GET['key']) && $_GET['e_act'] == 'login') {
                    
                    $user_email = get_user_by('email', $_GET['email']);
                    if ($user_email && is_object($user_email) && get_class($user_email) == 'WP_User') {
                        
                        if (check_password_reset_key($_GET['key'], $user_email->user_login)) {
                            
                            global $user;
                            $userdata = [
                                'ID' => $user_email->ID,
                                'user_pass' => wp_generate_password(),
                            ];
                            $user_id = wp_update_user($userdata);
                            $user = wp_signon([
                                'user_login' => $user_email->user_login, 
                                'user_password' => $userdata['user_pass'], 
                                'remember' => true
                            ]);
                            
                            $redirect_to = home_url();
                            if (!empty($_GET['redirect_to'])) {
                                $redirect_to = $_GET['redirect_to'];
                            }
                            wp_safe_redirect($redirect_to);
                            die();
                        }
                    }
                }
            }, 9);
        }
    }

}	 